/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DirectionCondition<E extends TitanRelation>
extends Literal<E> {
    private final TitanVertex vertex;
    private final int relationPos;
    private final Direction direction;

    public DirectionCondition(TitanVertex vertex, Direction dir) {
        assert (vertex != null && dir != null);
        this.vertex = vertex;
        this.direction = dir;
        this.relationPos = dir == Direction.BOTH ? -1 : EdgeDirection.position(dir);
    }

    @Override
    public boolean evaluate(E element) {
        if (this.relationPos < 0) {
            return true;
        }
        if (element instanceof CacheEdge) {
            return this.direction == ((CacheEdge)element).getVertexCentricDirection();
        }
        return ((InternalRelation)element).getVertex(this.relationPos).equals(this.vertex);
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append(this.relationPos).append((Object)this.vertex).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        DirectionCondition oth = (DirectionCondition)other;
        return this.relationPos == oth.relationPos && this.vertex.equals(oth.vertex);
    }

    @Override
    public String toString() {
        return "dir[" + this.getDirection() + "]";
    }
}

