/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LabelCondition<E extends TitanRelation>
extends Literal<E> {
    private final TitanType label;

    public LabelCondition(TitanType label) {
        Preconditions.checkNotNull((Object)label);
        this.label = label;
    }

    @Override
    public boolean evaluate(E element) {
        return this.label.equals(element.getType());
    }

    public TitanType getLabel() {
        return this.label;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.label).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other) && this.label.equals(((LabelCondition)other).label);
    }

    @Override
    public String toString() {
        return "label[" + this.label.toString() + "]";
    }
}

