/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractTypedRelation;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.StringFactory;

public abstract class AbstractEdge
extends AbstractTypedRelation
implements TitanEdge {
    private final InternalVertex start;
    private final InternalVertex end;

    public AbstractEdge(long id, TitanLabel label, InternalVertex start, InternalVertex end) {
        super(id, label);
        assert (start != null && end != null);
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public String getLabel() {
        return this.type.getName();
    }

    @Override
    public InternalVertex getVertex(int pos) {
        switch (pos) {
            case 0: {
                return this.start;
            }
            case 1: {
                return this.end;
            }
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public int getLen() {
        return this.isUnidirected() ? 1 : 2;
    }

    @Override
    public TitanLabel getTitanLabel() {
        return (TitanLabel)((Object)this.type);
    }

    @Override
    public TitanVertex getVertex(Direction dir) {
        return this.getVertex(EdgeDirection.position(dir));
    }

    @Override
    public TitanVertex getOtherVertex(TitanVertex vertex) {
        long otherId = vertex.getID();
        if (this.start.getID() == otherId) {
            return this.end;
        }
        if (this.end.getID() == otherId) {
            return this.start;
        }
        throw new IllegalArgumentException("Edge is not incident on vertex");
    }

    @Override
    public boolean isDirected() {
        return !this.isUnidirected();
    }

    @Override
    public boolean isUnidirected() {
        return ((TitanLabel)((Object)this.type)).isUnidirected();
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public boolean isEdge() {
        return true;
    }
}

