/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.tinkerpop.blueprints.Direction;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractTypedRelation
extends AbstractElement
implements InternalRelation {
    protected final InternalType type;

    public AbstractTypedRelation(long id, TitanType type) {
        super(id);
        assert (type != null && type instanceof InternalType);
        this.type = (InternalType)type;
    }

    @Override
    public InternalRelation it() {
        InternalVertex v = this.getVertex(0);
        if (v == v.it()) {
            return this;
        }
        InternalRelation next = (InternalRelation)RelationIdentifier.get(v, this.type, super.getID()).findRelation(this.tx());
        if (next == null) {
            throw new InvalidElementException("Relation has been removed", this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.getVertex(0).tx();
    }

    @Override
    public Direction getDirection(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return EdgeDirection.fromPosition(i);
        }
        throw new IllegalArgumentException("Relation is not incident on vertex");
    }

    @Override
    public boolean isIncidentOn(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.type.isHidden();
    }

    @Override
    public boolean isModifiable() {
        return this.type.isModifiable();
    }

    @Override
    public boolean isLoop() {
        return this.getArity() == 2 && this.getVertex(0).equals(this.getVertex(1));
    }

    @Override
    public TitanType getType() {
        return this.type;
    }

    @Override
    public RelationIdentifier getId() {
        return RelationIdentifier.get(this);
    }

    protected void verifyRemoval() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException("This relation is not modifiable and hence cannot be removed");
        }
    }

    @Override
    public <O> O removeProperty(String key) {
        if (!this.tx().containsType(key)) {
            return null;
        }
        return this.removeProperty(this.tx().getType(key));
    }

    @Override
    public <O> O removeProperty(TitanType type) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        return this.it().removePropertyDirect(type);
    }

    @Override
    public void setProperty(TitanLabel label, TitanVertex vertex) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        Preconditions.checkArgument((boolean)label.isUnidirected(), (Object)"Label must be unidirected");
        Preconditions.checkArgument((boolean)label.isUnique(Direction.OUT), (Object)"Label must have unique end point");
        Preconditions.checkArgument((vertex != null ? 1 : 0) != 0, (Object)"Vertex cannot be null");
        this.it().setPropertyDirect(label, vertex);
    }

    @Override
    public void setProperty(TitanKey key, Object value) {
        Preconditions.checkArgument((!this.it().isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        Preconditions.checkArgument((boolean)key.isUnique(Direction.OUT), (Object)"Key must have unique assignment");
        this.it().setPropertyDirect(key, this.tx().verifyAttribute(key, value));
    }

    @Override
    public void setProperty(String key, Object value) {
        TitanType type = this.tx().getType(key);
        if (type instanceof TitanKey) {
            this.setProperty((TitanKey)type, value);
        } else if (type instanceof TitanLabel) {
            Preconditions.checkArgument((boolean)(value instanceof TitanVertex), (Object)"Value must be a vertex");
            this.setProperty((TitanLabel)type, (InternalVertex)value);
        } else if (type == null) {
            if (value instanceof TitanVertex) {
                this.setProperty(this.tx().getEdgeLabel(key), (TitanVertex)value);
            }
            this.setProperty(this.tx().getPropertyKey(key), value);
        } else {
            throw new IllegalArgumentException("Invalid key argument: " + key);
        }
    }

    @Override
    public <O> O getProperty(TitanKey key) {
        return this.it().getPropertyDirect(key);
    }

    @Override
    public <O> O getProperty(String key) {
        if (!this.tx().containsType(key)) {
            return null;
        }
        TitanType type = this.tx().getType(key);
        if (type == null) {
            return null;
        }
        if (type.isPropertyKey()) {
            return this.getProperty((TitanKey)type);
        }
        return (O)this.getProperty((TitanLabel)type);
    }

    @Override
    public TitanVertex getProperty(TitanLabel label) {
        Object val = this.it().getPropertyDirect(label);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return this.tx().getExistingVertex(((Number)val).longValue());
        }
        if (val instanceof TitanVertex) {
            return (TitanVertex)val;
        }
        throw new IllegalStateException("Invalid object found instead of vertex: " + val);
    }

    @Override
    public <O> O getProperty(TitanType type) {
        if (type.isEdgeLabel()) {
            return (O)this.getProperty((TitanLabel)type);
        }
        return this.getProperty((TitanKey)type);
    }

    public Set<String> getPropertyKeys() {
        HashSet result = Sets.newHashSet();
        for (TitanType type : this.it().getPropertyKeysDirect()) {
            result.add(type.getName());
        }
        return result;
    }
}

