/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractEdge;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CacheEdge
extends AbstractEdge {
    private final byte position;
    private final Entry data;

    public CacheEdge(long id, TitanLabel label, InternalVertex start, InternalVertex end, byte position, Entry data) {
        super(id, label, start, end);
        assert (data != null);
        assert (position >= 0 && position <= 1);
        this.data = data;
        this.position = position;
    }

    public Direction getVertexCentricDirection() {
        return this.data.getCache().direction;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            final long id = super.getID();
            List<InternalRelation> previous = startVertex.getAddedRelations(new Predicate<InternalRelation>(){

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return internalRelation instanceof StandardEdge && ((StandardEdge)internalRelation).getPreviousID() == id;
                }
            });
            assert (Iterables.size(previous) <= 1 || this.isLoop() && Iterables.size(previous) == 2);
            it = (InternalRelation)Iterables.getFirst(previous, null);
        }
        if (it != null) {
            return it;
        }
        return super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            to.setPropertyDirect(this.tx().getExistingType(entry.key), entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardEdge copy = new StandardEdge(super.getID(), this.getTitanLabel(), this.getVertex(0), this.getVertex(1), 2);
        this.copyProperties(copy);
        copy.remove();
        StandardEdge u = (StandardEdge)this.tx().addEdge((TitanVertex)this.getVertex(0), (TitanVertex)this.getVertex(1), this.getLabel());
        u.setPreviousID(super.getID());
        this.copyProperties(u);
        return u;
    }

    @Override
    public long getID() {
        InternalRelation it = this.it();
        return it == this ? super.getID() : it.getID();
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = this.tx().getGraph().getEdgeSerializer().readRelation(this.getVertex(this.position), this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getPropertyDirect(TitanType type) {
        return this.getPropertyMap().get(type.getID());
    }

    @Override
    public Iterable<TitanType> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<TitanType> types = new ArrayList<TitanType>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingType(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(TitanType type, Object value) {
        this.update().setPropertyDirect(type, value);
    }

    @Override
    public <O> O removePropertyDirect(TitanType type) {
        return this.update().removePropertyDirect(type);
    }

    @Override
    public byte getLifeCycle() {
        InternalVertex startVertex = this.getVertex(0);
        return (byte)((startVertex.hasRemovedRelations() || startVertex.isRemoved()) && this.tx().isRemovedRelation(super.getID()) ? 6 : 2);
    }

    @Override
    public void remove() {
        this.verifyRemoval();
        if (!this.tx().isRemovedRelation(super.getID())) {
            this.tx().removeRelation(this);
        }
    }
}

