/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractProperty;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.relations.StandardProperty;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class CacheProperty
extends AbstractProperty {
    private final Entry data;

    public CacheProperty(long id, TitanKey key, InternalVertex start, Object value, Entry data) {
        super(id, key, start, value);
        this.data = data;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            final long id = super.getID();
            it = (InternalRelation)Iterables.getOnlyElement(startVertex.getAddedRelations(new Predicate<InternalRelation>(){

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return internalRelation instanceof StandardProperty && ((StandardProperty)internalRelation).getPreviousID() == id;
                }
            }), null);
        }
        return it != null ? it : super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            to.setPropertyDirect(this.tx().getExistingType(entry.key), entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardProperty copy = new StandardProperty(super.getID(), this.getPropertyKey(), this.getVertex(0), this.getValue(), 2);
        this.copyProperties(copy);
        copy.remove();
        StandardProperty u = (StandardProperty)this.tx().addProperty((TitanVertex)this.getVertex(0), this.getPropertyKey(), this.getValue());
        u.setPreviousID(super.getID());
        this.copyProperties(u);
        return u;
    }

    @Override
    public long getID() {
        InternalRelation it = this.it();
        return it == this ? super.getID() : it.getID();
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = this.tx().getGraph().getEdgeSerializer().readRelation(this.getVertex(0), this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getPropertyDirect(TitanType type) {
        return this.getPropertyMap().get(type.getID());
    }

    @Override
    public Iterable<TitanType> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<TitanType> types = new ArrayList<TitanType>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingType(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(TitanType type, Object value) {
        this.update().setPropertyDirect(type, value);
    }

    @Override
    public <O> O removePropertyDirect(TitanType type) {
        return this.update().removePropertyDirect(type);
    }

    @Override
    public byte getLifeCycle() {
        if ((this.getVertex(0).hasRemovedRelations() || this.getVertex(0).isRemoved()) && this.tx().isRemovedRelation(super.getID())) {
            return 6;
        }
        return 2;
    }

    @Override
    public void remove() {
        this.verifyRemoval();
        if (!this.tx().isRemovedRelation(super.getID())) {
            this.tx().removeRelation(this);
        }
    }
}

