/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractProperty;
import com.thinkaurelius.titan.graphdb.relations.StandardRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StandardProperty
extends AbstractProperty
implements StandardRelation {
    private static final Map<TitanType, Object> EMPTY_PROPERTIES = ImmutableMap.of();
    private byte lifecycle;
    private long previousID = 0L;
    private volatile Map<TitanType, Object> properties = EMPTY_PROPERTIES;

    public StandardProperty(long id, TitanKey type, InternalVertex vertex, Object value, byte lifecycle) {
        super(id, type, vertex, value);
        this.lifecycle = lifecycle;
    }

    @Override
    public long getPreviousID() {
        return this.previousID;
    }

    @Override
    public void setPreviousID(long previousID) {
        Preconditions.checkArgument((previousID > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.previousID == 0L ? 1 : 0) != 0);
        this.previousID = previousID;
    }

    @Override
    public <O> O getPropertyDirect(TitanType type) {
        return (O)this.properties.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyDirect(TitanType type, Object value) {
        if (this.properties == EMPTY_PROPERTIES) {
            if (this.tx().getConfiguration().isSingleThreaded()) {
                this.properties = new HashMap<TitanType, Object>(5);
            } else {
                StandardProperty standardProperty = this;
                synchronized (standardProperty) {
                    if (this.properties == EMPTY_PROPERTIES) {
                        this.properties = Collections.synchronizedMap(new HashMap(5));
                    }
                }
            }
        }
        this.properties.put(type, value);
    }

    @Override
    public Iterable<TitanType> getPropertyKeysDirect() {
        return this.properties.keySet();
    }

    @Override
    public <O> O removePropertyDirect(TitanType type) {
        if (!this.properties.isEmpty()) {
            return (O)this.properties.remove(type);
        }
        return null;
    }

    @Override
    public byte getLifeCycle() {
        return this.lifecycle;
    }

    @Override
    public synchronized void remove() {
        this.verifyRemoval();
        if (!ElementLifeCycle.isRemoved(this.lifecycle)) {
            this.tx().removeRelation(this);
            this.lifecycle = ElementLifeCycle.update(this.lifecycle, ElementLifeCycle.Event.REMOVED);
        }
    }
}

