/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.KeyMaker;
import com.thinkaurelius.titan.core.LabelMaker;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsTransaction;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.ElementType;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.GraphCentricQuery;
import com.thinkaurelius.titan.graphdb.query.GraphCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.IndexQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.query.MetricsQueryExecutor;
import com.thinkaurelius.titan.graphdb.query.MultiVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.QueryExecutor;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.VertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.relations.StandardProperty;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import com.thinkaurelius.titan.graphdb.transaction.UniqueLockApplication;
import com.thinkaurelius.titan.graphdb.transaction.VertexIterable;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.AddedRelationsContainer;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.ConcurrentBufferAddedRelations;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.SimpleBufferAddedRelations;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.ConcurrentIndexCache;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.IndexCache;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.SimpleIndexCache;
import com.thinkaurelius.titan.graphdb.transaction.vertexcache.GuavaVertexCache;
import com.thinkaurelius.titan.graphdb.transaction.vertexcache.VertexCache;
import com.thinkaurelius.titan.graphdb.types.StandardKeyMaker;
import com.thinkaurelius.titan.graphdb.types.StandardLabelMaker;
import com.thinkaurelius.titan.graphdb.types.TitanTypeClass;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemType;
import com.thinkaurelius.titan.graphdb.types.system.SystemTypeManager;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanKeyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanTypeVertex;
import com.thinkaurelius.titan.graphdb.util.FakeLock;
import com.thinkaurelius.titan.graphdb.util.VertexCentricEdgeIterable;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import com.thinkaurelius.titan.util.stats.MetricManager;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTitanTx
extends TitanBlueprintsTransaction {
    private static final Logger log = LoggerFactory.getLogger(StandardTitanTx.class);
    private static final Map<Long, InternalRelation> EMPTY_DELETED_RELATIONS = ImmutableMap.of();
    private static final ConcurrentMap<UniqueLockApplication, Lock> UNINITIALIZED_LOCKS = null;
    private final StandardTitanGraph graph;
    private final TransactionConfiguration config;
    private final IDInspector idInspector;
    private final AttributeHandling attributeHandler;
    private final BackendTransaction txHandle;
    private final EdgeSerializer edgeSerializer;
    private final IndexSerializer indexSerializer;
    private final VertexCache vertexCache;
    private final AddedRelationsContainer addedRelations;
    private Map<Long, InternalRelation> deletedRelations;
    private final Cache<IndexQuery, List<Object>> indexCache;
    private final IndexCache newVertexIndexEntries;
    private ConcurrentMap<UniqueLockApplication, Lock> uniqueLocks;
    private final Map<String, Long> typeCache;
    private final AtomicLong temporaryID;
    private boolean isOpen;
    private final Retriever<Long, InternalVertex> existingVertexRetriever = new VertexConstructor(false);
    private final Retriever<Long, InternalVertex> externalVertexRetriever;
    private final Retriever<Long, InternalVertex> internalVertexRetriever;
    public final QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery> edgeProcessor;
    public final QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery> edgeProcessorImpl = new QueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery>(){

        @Override
        public Iterator<TitanRelation> getNew(final VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew() || vertex.hasAddedRelations()) {
                return vertex.getAddedRelations(new Predicate<InternalRelation>(){
                    private TitanRelation previous = null;

                    public boolean apply(@Nullable InternalRelation relation) {
                        if (relation instanceof TitanEdge && relation.isLoop() && query.getDirection() != Direction.BOTH) {
                            if (relation.equals(this.previous)) {
                                return false;
                            }
                            this.previous = relation;
                        }
                        return query.matches(relation);
                    }
                }).iterator();
            }
            return Iterators.emptyIterator();
        }

        @Override
        public boolean hasDeletions(VertexCentricQuery query) {
            return !StandardTitanTx.this.deletedRelations.isEmpty() && !query.getVertex().isNew() && query.getVertex().hasRemovedRelations();
        }

        @Override
        public boolean isDeleted(VertexCentricQuery query, TitanRelation result) {
            return StandardTitanTx.this.deletedRelations.containsKey(result.getID()) || result != ((InternalRelation)result).it();
        }

        @Override
        public Iterator<TitanRelation> execute(VertexCentricQuery query, SliceQuery sq, Object exeInfo) {
            assert (exeInfo == null);
            if (query.getVertex().isNew()) {
                return Iterators.emptyIterator();
            }
            final InternalVertex v = query.getVertex();
            Collection<Entry> iter = v.loadRelations(sq, new Retriever<SliceQuery, List<Entry>>(){

                @Override
                public List<Entry> get(SliceQuery query) {
                    return StandardTitanTx.this.graph.edgeQuery(v.getID(), query, StandardTitanTx.this.txHandle);
                }
            });
            return Iterables.transform(iter, (Function)new Function<Entry, TitanRelation>(){

                public TitanRelation apply(@Nullable Entry entry) {
                    return StandardTitanTx.this.edgeSerializer.readRelation(v, entry);
                }
            }).iterator();
        }
    };
    public final QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery> elementProcessor;
    public final QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery> elementProcessorImpl = new QueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery>(){

        private PredicateCondition<TitanKey, TitanElement> getEqualityCondition(Condition<TitanElement> condition) {
            if (condition instanceof PredicateCondition) {
                PredicateCondition pc = (PredicateCondition)condition;
                if (pc.getPredicate() == Cmp.EQUAL && StandardTitanTx.isVertexIndexProperty((TitanKey)pc.getKey())) {
                    return pc;
                }
            } else if (condition instanceof And) {
                for (Condition<TitanElement> condition2 : ((And)condition).getChildren()) {
                    PredicateCondition<TitanKey, TitanElement> p = this.getEqualityCondition(condition2);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        @Override
        public Iterator<TitanElement> getNew(final GraphCentricQuery query) {
            Preconditions.checkArgument((query.getResultType() == ElementType.VERTEX || query.getResultType() == ElementType.EDGE ? 1 : 0) != 0);
            if (!query.getCondition().hasChildren()) {
                return Iterators.emptyIterator();
            }
            if (query.getResultType() == ElementType.VERTEX && StandardTitanTx.this.hasModifications()) {
                Iterator vertices;
                Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(query.getCondition()));
                PredicateCondition<TitanKey, TitanElement> standardIndexKey = this.getEqualityCondition(query.getCondition());
                if (standardIndexKey == null) {
                    final HashSet keys = Sets.newHashSet();
                    ConditionUtil.traversal(query.getCondition(), new Predicate<Condition<TitanElement>>(){

                        public boolean apply(@Nullable Condition<TitanElement> cond) {
                            Preconditions.checkArgument((cond.getType() != Condition.Type.LITERAL || cond instanceof PredicateCondition ? 1 : 0) != 0);
                            if (cond instanceof PredicateCondition) {
                                keys.add(((PredicateCondition)cond).getKey());
                            }
                            return true;
                        }
                    });
                    Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (String)"Invalid query condition: %s", (Object[])new Object[]{query.getCondition()});
                    HashSet vertexSet = Sets.newHashSet();
                    for (TitanRelation titanRelation : StandardTitanTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                        public boolean apply(@Nullable InternalRelation relation) {
                            return keys.contains(relation.getType());
                        }
                    })) {
                        vertexSet.add(((TitanProperty)titanRelation).getVertex());
                    }
                    for (TitanRelation titanRelation : StandardTitanTx.this.deletedRelations.values()) {
                        TitanVertex v;
                        if (!keys.contains(titanRelation.getType()) || (v = ((TitanProperty)titanRelation).getVertex()).isRemoved()) continue;
                        vertexSet.add(v);
                    }
                    vertices = vertexSet.iterator();
                } else {
                    vertices = Iterators.transform(StandardTitanTx.this.newVertexIndexEntries.get(standardIndexKey.getValue(), standardIndexKey.getKey()).iterator(), (Function)new Function<TitanProperty, TitanVertex>(){

                        @Nullable
                        public TitanVertex apply(@Nullable TitanProperty o) {
                            return o.getVertex();
                        }
                    });
                }
                return Iterators.filter((Iterator)vertices, (Predicate)new Predicate<TitanVertex>(){

                    public boolean apply(@Nullable TitanVertex vertex) {
                        return query.matches(vertex);
                    }
                });
            }
            if (query.getResultType() == ElementType.EDGE && !StandardTitanTx.this.addedRelations.isEmpty()) {
                return StandardTitanTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                    public boolean apply(@Nullable InternalRelation relation) {
                        return relation instanceof TitanEdge && !relation.isHidden() && query.matches(relation);
                    }
                }).iterator();
            }
            return Iterators.emptyIterator();
        }

        @Override
        public boolean hasDeletions(GraphCentricQuery query) {
            return StandardTitanTx.this.hasModifications();
        }

        @Override
        public boolean isDeleted(GraphCentricQuery query, TitanElement result) {
            if (result == null || result.isRemoved()) {
                return true;
            }
            if (query.getResultType() == ElementType.VERTEX) {
                Preconditions.checkArgument((boolean)(result instanceof InternalVertex));
                InternalVertex v = ((InternalVertex)result).it();
                if (v.hasAddedRelations() || v.hasRemovedRelations()) {
                    return !query.matches(result);
                }
                return false;
            }
            if (query.getResultType() == ElementType.EDGE) {
                Preconditions.checkArgument((result.isLoaded() || result.isNew() ? 1 : 0) != 0);
                return false;
            }
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
        }

        @Override
        public Iterator<TitanElement> execute(GraphCentricQuery query, JointIndexQuery indexQuery, Object exeInfo) {
            ArrayList retrievals;
            if (!indexQuery.isEmpty()) {
                retrievals = new ArrayList();
                for (int i = 0; i < indexQuery.size(); ++i) {
                    final String index = indexQuery.getIndex(i);
                    final IndexQuery subquery = indexQuery.getQuery(i);
                    retrievals.add(new QueryUtil.IndexCall<Object>(){

                        @Override
                        public Collection<Object> call(int limit) {
                            final IndexQuery adjustedQuery = subquery.updateLimit(limit);
                            try {
                                return (Collection)StandardTitanTx.this.indexCache.get((Object)adjustedQuery, (Callable)new Callable<List<Object>>(){

                                    @Override
                                    public List<Object> call() throws Exception {
                                        return StandardTitanTx.this.indexSerializer.query(index, adjustedQuery, StandardTitanTx.this.txHandle);
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new TitanException("Could not call index", e.getCause());
                            }
                        }
                    });
                }
            } else {
                log.warn("Query requires iterating over all vertices [{}]. For better performance, use indexes", query.getCondition());
                switch (query.getResultType()) {
                    case VERTEX: {
                        return StandardTitanTx.this.getVertices().iterator();
                    }
                    case EDGE: {
                        return StandardTitanTx.this.getEdges().iterator();
                    }
                }
                throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
            }
            List resultSet = QueryUtil.processIntersectingRetrievals(retrievals, indexQuery.getLimit());
            Iterator iter = Iterators.transform(resultSet.iterator(), StandardTitanTx.this.getConversionFunction(query.getResultType()));
            return iter;
        }
    };
    private final Function<Object, TitanVertex> vertexIDConversionFct = new Function<Object, TitanVertex>(){

        public TitanVertex apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof Long));
            return StandardTitanTx.this.getExistingVertex((Long)id);
        }
    };
    private final Function<Object, TitanEdge> edgeIDConversionFct = new Function<Object, TitanEdge>(){

        public TitanEdge apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
            return StandardTitanTx.this.getEdge(id);
        }
    };

    public StandardTitanTx(StandardTitanGraph graph, TransactionConfiguration config, BackendTransaction txHandle) {
        int concurrencyLevel;
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)graph.isOpen());
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)txHandle);
        this.graph = graph;
        this.config = config;
        this.idInspector = graph.getIDInspector();
        this.attributeHandler = graph.getAttributeHandling();
        this.txHandle = txHandle;
        this.edgeSerializer = graph.getEdgeSerializer();
        this.indexSerializer = graph.getIndexSerializer();
        this.temporaryID = new AtomicLong(-1L);
        if (config.isSingleThreaded()) {
            this.addedRelations = new SimpleBufferAddedRelations();
            concurrencyLevel = 1;
            this.typeCache = new HashMap<String, Long>();
            this.newVertexIndexEntries = new SimpleIndexCache();
        } else {
            this.addedRelations = new ConcurrentBufferAddedRelations();
            concurrencyLevel = 1;
            this.typeCache = new NonBlockingHashMap();
            this.newVertexIndexEntries = new ConcurrentIndexCache();
        }
        this.externalVertexRetriever = new VertexConstructor(config.hasVerifyExternalVertexExistence());
        this.internalVertexRetriever = new VertexConstructor(config.hasVerifyInternalVertexExistence());
        this.vertexCache = new GuavaVertexCache(config.getVertexCacheSize(), concurrencyLevel);
        this.indexCache = CacheBuilder.newBuilder().weigher((Weigher)new Weigher<IndexQuery, List<Object>>(){

            public int weigh(IndexQuery q, List<Object> r) {
                return 2 + r.size();
            }
        }).concurrencyLevel(concurrencyLevel).maximumWeight(config.getIndexCacheWeight()).build();
        this.uniqueLocks = UNINITIALIZED_LOCKS;
        this.deletedRelations = EMPTY_DELETED_RELATIONS;
        this.isOpen = true;
        if (null != config.getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(config.getMetricsPrefix(), "tx", "begin").inc();
            this.elementProcessor = new MetricsQueryExecutor<GraphCentricQuery, TitanElement, JointIndexQuery>(config.getMetricsPrefix(), "graph", this.elementProcessorImpl);
            this.edgeProcessor = new MetricsQueryExecutor<VertexCentricQuery, TitanRelation, SliceQuery>(config.getMetricsPrefix(), "vertex", this.edgeProcessorImpl);
        } else {
            this.elementProcessor = this.elementProcessorImpl;
            this.edgeProcessor = this.edgeProcessorImpl;
        }
    }

    private void verifyWriteAccess(TitanVertex ... vertices) {
        if (this.config.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot create new entities in read-only transaction");
        }
        this.verifyAccess(vertices);
    }

    public final void verifyAccess(TitanVertex ... vertices) {
        this.verifyOpen();
        for (TitanVertex v : vertices) {
            Preconditions.checkArgument((boolean)(v instanceof InternalVertex), (String)"Invalid vertex: %s", (Object[])new Object[]{v});
            if (!(v instanceof SystemType) && this != ((InternalVertex)v).tx()) {
                throw new IllegalArgumentException("The vertex or type is not associated with this transaction [" + v + "]");
            }
            if (!v.isRemoved()) continue;
            throw new IllegalArgumentException("The vertex or type has been removed [" + v + "]");
        }
    }

    private void verifyOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Operation cannot be executed because the enclosing transaction is closed");
        }
    }

    public StandardTitanTx getNextTx() {
        Preconditions.checkArgument((boolean)this.isClosed());
        if (!this.config.isThreadBound()) {
            throw new IllegalStateException("Cannot access element because its enclosing transaction is closed and unbound");
        }
        return (StandardTitanTx)this.graph.getCurrentThreadTx();
    }

    public TransactionConfiguration getConfiguration() {
        return this.config;
    }

    public StandardTitanGraph getGraph() {
        return this.graph;
    }

    public BackendTransaction getTxHandle() {
        return this.txHandle;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    @Override
    public boolean containsVertex(long vertexid) {
        return this.getVertex(vertexid) != null;
    }

    @Override
    public TitanVertex getVertex(long vertexid) {
        InternalVertex v;
        this.verifyOpen();
        if (vertexid <= 0L || !this.idInspector.isTypeID(vertexid) && !this.idInspector.isVertexID(vertexid)) {
            return null;
        }
        if (null != this.config.getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "db", "getVertexByID").inc();
        }
        return (v = this.vertexCache.get(vertexid, this.externalVertexRetriever)).isRemoved() ? null : v;
    }

    public InternalVertex getExistingVertex(long vertexid) {
        return this.vertexCache.get(vertexid, this.internalVertexRetriever);
    }

    @Override
    public TitanVertex addVertex(Long vertexId) {
        this.verifyWriteAccess(new TitanVertex[0]);
        if (vertexId != null && !this.graph.getConfiguration().allowVertexIdSetting()) {
            log.info("Provided vertex id [{}] is ignored because vertex id setting is not enabled", (Object)vertexId);
            vertexId = null;
        }
        Preconditions.checkArgument((vertexId != null || !this.graph.getConfiguration().allowVertexIdSetting() ? 1 : 0) != 0, (Object)"Must provide vertex id");
        Preconditions.checkArgument((vertexId == null || IDManager.isVertexID(vertexId) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexId});
        Preconditions.checkArgument((vertexId == null || !this.config.hasVerifyExternalVertexExistence() || !this.containsVertex(vertexId) ? 1 : 0) != 0, (String)"Vertex with given id already exists: %s", (Object[])new Object[]{vertexId});
        StandardVertex vertex = new StandardVertex(this, this.temporaryID.decrementAndGet(), 1);
        if (vertexId != null) {
            vertex.setID(vertexId);
        } else if (this.config.hasAssignIDsImmediately()) {
            this.graph.assignID(vertex);
        }
        this.addProperty((TitanVertex)vertex, SystemKey.VertexState, (Object)SystemKey.VertexStates.DEFAULT.getValue());
        this.vertexCache.add(vertex, vertex.getID());
        return vertex;
    }

    @Override
    public TitanVertex addVertex() {
        return this.addVertex(null);
    }

    public Iterable<Vertex> getVertices() {
        if (!this.addedRelations.isEmpty()) {
            List<InternalVertex> newVs = this.vertexCache.getAllNew();
            Iterator<InternalVertex> viter = newVs.iterator();
            while (viter.hasNext()) {
                if (!(viter.next() instanceof TitanType)) continue;
                viter.remove();
            }
            return Iterables.concat(newVs, (Iterable)new VertexIterable(this.graph, this));
        }
        return new VertexIterable(this.graph, this);
    }

    public final Object verifyAttribute(TitanKey key, Object attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Property value cannot be null");
        Class<?> datatype = key.getDataType();
        if (datatype.equals(Object.class)) {
            return attribute;
        }
        if (!attribute.getClass().equals(datatype)) {
            Object converted = this.attributeHandler.convert(datatype, attribute);
            Preconditions.checkArgument((converted != null ? 1 : 0) != 0, (String)"Value [%s] is not an instance of the expected data type for property key [%s] and cannot be converted. Expected: %s, found: %s", (Object[])new Object[]{attribute, key.getName(), datatype, attribute.getClass()});
            attribute = converted;
        }
        Preconditions.checkState((boolean)attribute.getClass().equals(datatype));
        this.attributeHandler.verifyAttribute(datatype, attribute);
        return attribute;
    }

    private static final boolean isVertexIndexProperty(InternalRelation relation) {
        if (!(relation instanceof TitanProperty)) {
            return false;
        }
        return StandardTitanTx.isVertexIndexProperty(((TitanProperty)((Object)relation)).getPropertyKey());
    }

    private static final boolean isVertexIndexProperty(TitanKey key) {
        return key.hasIndex("standard", Vertex.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelation(InternalRelation relation) {
        Preconditions.checkArgument((!relation.isRemoved() ? 1 : 0) != 0);
        relation = relation.it();
        for (int i = 0; i < relation.getLen(); ++i) {
            relation.getVertex(i).removeRelation(relation);
        }
        if (relation.isNew()) {
            this.addedRelations.remove(relation);
            if (StandardTitanTx.isVertexIndexProperty(relation)) {
                this.newVertexIndexEntries.remove((TitanProperty)((Object)relation));
            }
        } else {
            Preconditions.checkArgument((boolean)relation.isLoaded());
            if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                if (this.config.isSingleThreaded()) {
                    this.deletedRelations = new HashMap<Long, InternalRelation>();
                } else {
                    StandardTitanTx standardTitanTx = this;
                    synchronized (standardTitanTx) {
                        if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                            this.deletedRelations = new ConcurrentHashMap<Long, InternalRelation>();
                        }
                    }
                }
            }
            this.deletedRelations.put(relation.getID(), relation);
        }
    }

    public boolean isRemovedRelation(Long relationId) {
        return this.deletedRelations.containsKey(relationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getUniquenessLock(TitanVertex start, TitanType type, Object end) {
        ReentrantLock lock;
        UniqueLockApplication la;
        Lock existingLock;
        if (this.config.isSingleThreaded()) {
            return FakeLock.INSTANCE;
        }
        if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
            Preconditions.checkArgument((!this.config.isSingleThreaded() ? 1 : 0) != 0);
            StandardTitanTx standardTitanTx = this;
            synchronized (standardTitanTx) {
                if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
                    this.uniqueLocks = new ConcurrentHashMap<UniqueLockApplication, Lock>();
                }
            }
        }
        if ((existingLock = this.uniqueLocks.putIfAbsent(la = new UniqueLockApplication(start, type, end), lock = new ReentrantLock())) == null) {
            return lock;
        }
        return existingLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TitanEdge addEdge(TitanVertex outVertex, TitanVertex inVertex, TitanLabel label) {
        this.verifyWriteAccess(outVertex, inVertex);
        outVertex = ((InternalVertex)outVertex).it();
        inVertex = ((InternalVertex)inVertex).it();
        Preconditions.checkNotNull((Object)label);
        Lock uniqueLock = FakeLock.INSTANCE;
        if (this.config.hasVerifyUniqueness() && (label.isUnique(Direction.OUT) || label.isUnique(Direction.IN))) {
            uniqueLock = this.getUniquenessLock(outVertex, label, inVertex);
        }
        uniqueLock.lock();
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (label.isUnique(Direction.OUT)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(this.query(outVertex).includeHidden().type(label).direction(Direction.OUT).titanEdges()), (String)"An edge with the given type already exists on the out-vertex and the label [%s] is out-unique", (Object[])new Object[]{label.getName()});
                }
                if (label.isUnique(Direction.IN)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(this.query(inVertex).includeHidden().type(label).direction(Direction.IN).titanEdges()), (String)"An edge with the given type already exists on the in-vertex and the label [%s] is in-unique", (Object[])new Object[]{label.getName()});
                }
            }
            StandardEdge edge = new StandardEdge(this.temporaryID.decrementAndGet(), label, (InternalVertex)outVertex, (InternalVertex)inVertex, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(edge);
            }
            this.connectRelation(edge);
            StandardEdge standardEdge = edge;
            return standardEdge;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    private void connectRelation(InternalRelation r) {
        for (int i = 0; i < r.getLen(); ++i) {
            boolean success = r.getVertex(i).addRelation(r);
            if (!success) {
                throw new AssertionError((Object)("Could not connect relation: " + r));
            }
        }
        this.addedRelations.add(r);
        for (int pos = 0; pos < r.getLen(); ++pos) {
            this.vertexCache.add(r.getVertex(pos), r.getVertex(pos).getID());
        }
        if (StandardTitanTx.isVertexIndexProperty(r)) {
            this.newVertexIndexEntries.add((TitanProperty)((Object)r));
        }
    }

    @Override
    public TitanProperty addProperty(TitanVertex vertex, TitanKey key, Object value) {
        if (key.isUnique(Direction.OUT)) {
            return this.setProperty(vertex, key, value);
        }
        return this.addPropertyInternal(vertex, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanProperty addPropertyInternal(TitanVertex vertex, TitanKey key, Object value) {
        this.verifyWriteAccess(vertex);
        vertex = ((InternalVertex)vertex).it();
        Preconditions.checkNotNull((Object)key);
        value = this.verifyAttribute(key, value);
        Lock uniqueLock = FakeLock.INSTANCE;
        if (this.config.hasVerifyUniqueness() && (key.isUnique(Direction.OUT) || key.isUnique(Direction.IN))) {
            uniqueLock = this.getUniquenessLock(vertex, key, value);
        }
        uniqueLock.lock();
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (key.isUnique(Direction.OUT)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(this.query(vertex).includeHidden().type(key).direction(Direction.OUT).properties()), (String)"A property with the given key [%s] already exists on the vertex [%s] and the property key is defined as single-valued", (Object[])new Object[]{key.getName(), vertex});
                }
                if (key.isUnique(Direction.IN)) {
                    Preconditions.checkArgument((boolean)Iterables.isEmpty(this.getVertices(key, value)), (String)"The given value [%s] is already used as a property and the property key [%s] is defined as graph-unique", (Object[])new Object[]{value, key.getName()});
                }
            }
            StandardProperty prop = new StandardProperty(this.temporaryID.decrementAndGet(), key, (InternalVertex)vertex, value, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(prop);
            }
            this.connectRelation(prop);
            StandardProperty standardProperty = prop;
            return standardProperty;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanProperty setProperty(TitanVertex vertex, final TitanKey key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)key.isUnique(Direction.OUT), (String)"Not an out-unique key: %s", (Object[])new Object[]{key.getName()});
        Lock uniqueLock = FakeLock.INSTANCE;
        try {
            if (this.config.hasVerifyUniqueness()) {
                uniqueLock = this.getUniquenessLock(vertex, key, value);
                uniqueLock.lock();
                vertex.removeProperty(key);
            } else {
                InternalVertex v = (InternalVertex)vertex;
                for (InternalRelation r : v.it().getAddedRelations(new Predicate<InternalRelation>(){

                    public boolean apply(@Nullable InternalRelation p) {
                        return p.getType().equals(key);
                    }
                })) {
                    r.remove();
                }
            }
            TitanProperty titanProperty = this.addPropertyInternal(vertex, key, value);
            return titanProperty;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    public Iterable<Edge> getEdges() {
        return new VertexCentricEdgeIterable(this.getVertices());
    }

    private final TitanType makeTitanType(TitanTypeClass typeClass, String name, TypeAttribute.Map definition) {
        TitanTypeVertex type;
        this.verifyOpen();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        if (typeClass == TitanTypeClass.KEY) {
            TypeAttribute.isValidKeyDefinition(definition);
            type = new TitanKeyVertex(this, this.temporaryID.decrementAndGet(), 1);
        } else {
            Preconditions.checkArgument((typeClass == TitanTypeClass.LABEL ? 1 : 0) != 0);
            TypeAttribute.isValidLabelDefinition(definition);
            type = new TitanLabelVertex(this, this.temporaryID.decrementAndGet(), 1);
        }
        this.graph.assignID(type);
        Preconditions.checkArgument((type.getID() > 0L ? 1 : 0) != 0);
        this.addProperty((TitanVertex)type, SystemKey.TypeName, (Object)name);
        this.addProperty((TitanVertex)type, SystemKey.VertexState, (Object)SystemKey.VertexStates.DEFAULT.getValue());
        this.addProperty((TitanVertex)type, SystemKey.TypeClass, (Object)typeClass);
        for (TypeAttribute attribute : definition.getAttributes()) {
            this.addProperty((TitanVertex)type, SystemKey.TypeDefinition, (Object)attribute);
        }
        this.vertexCache.add(type, type.getID());
        this.typeCache.put(name, type.getID());
        return type;
    }

    public TitanKey makePropertyKey(String name, TypeAttribute.Map definition) {
        return (TitanKey)this.makeTitanType(TitanTypeClass.KEY, name, definition);
    }

    public TitanLabel makeEdgeLabel(String name, TypeAttribute.Map definition) {
        return (TitanLabel)this.makeTitanType(TitanTypeClass.LABEL, name, definition);
    }

    @Override
    public boolean containsType(String name) {
        this.verifyOpen();
        return this.typeCache.containsKey(name) || SystemKey.KEY_MAP.containsKey(name) || !Iterables.isEmpty(this.getVertices(SystemKey.TypeName, (Object)name));
    }

    @Override
    public TitanType getType(String name) {
        InternalVertex typeVertex;
        this.verifyOpen();
        Long typeId = this.typeCache.get(name);
        if (typeId != null && (typeVertex = this.vertexCache.get(typeId, this.existingVertexRetriever)) != null) {
            return (TitanType)((Object)typeVertex);
        }
        TitanType type = SystemKey.KEY_MAP.get(name);
        return type != null ? type : (TitanType)Iterables.getOnlyElement(this.getVertices(SystemKey.TypeName, (Object)name), null);
    }

    public TitanType getExistingType(long typeid) {
        assert (this.idInspector.isTypeID(typeid));
        if (SystemTypeManager.isSystemRelationType(typeid)) {
            return SystemTypeManager.getSystemRelationType(typeid);
        }
        InternalVertex v = this.getExistingVertex(typeid);
        assert (v instanceof TitanType);
        return (TitanType)((Object)v);
    }

    @Override
    public TitanKey getPropertyKey(String name) {
        TitanType et = this.getType(name);
        if (et == null) {
            return this.config.getAutoEdgeTypeMaker().makeKey(this.makeKey(name));
        }
        if (et.isPropertyKey()) {
            return (TitanKey)et;
        }
        throw new IllegalArgumentException("The type of given name is not a key: " + name);
    }

    @Override
    public TitanLabel getEdgeLabel(String name) {
        TitanType et = this.getType(name);
        if (et == null) {
            return this.config.getAutoEdgeTypeMaker().makeLabel(this.makeLabel(name));
        }
        if (et.isEdgeLabel()) {
            return (TitanLabel)et;
        }
        throw new IllegalArgumentException("The type of given name is not a label: " + name);
    }

    @Override
    public KeyMaker makeKey(String name) {
        StandardKeyMaker maker = new StandardKeyMaker(this, this.indexSerializer);
        maker.name(name);
        return maker;
    }

    @Override
    public LabelMaker makeLabel(String name) {
        StandardLabelMaker maker = new StandardLabelMaker(this, this.indexSerializer);
        maker.name(name);
        return maker;
    }

    public VertexCentricQueryBuilder query(TitanVertex vertex) {
        return new VertexCentricQueryBuilder((InternalVertex)vertex, this.edgeSerializer);
    }

    @Override
    public TitanMultiVertexQuery multiQuery(TitanVertex ... vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this, this.edgeSerializer);
        for (TitanVertex v : vertices) {
            builder.addVertex(v);
        }
        return builder;
    }

    @Override
    public TitanMultiVertexQuery multiQuery(Collection<TitanVertex> vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this, this.edgeSerializer);
        builder.addAllVertices(vertices);
        return builder;
    }

    public void executeMultiQuery(Collection<InternalVertex> vertices, SliceQuery sq) {
        LongArrayList vids = new LongArrayList(vertices.size());
        for (InternalVertex v : vertices) {
            if (v.isNew() || !v.hasId() || !(v instanceof CacheVertex) || v.hasLoadedRelations(sq)) continue;
            vids.add(v.getID());
        }
        if (!vids.isEmpty()) {
            List<List<Entry>> results = this.graph.edgeMultiQuery(vids, sq, this.txHandle);
            int pos = 0;
            for (TitanVertex titanVertex : vertices) {
                if (pos >= vids.size() || vids.get(pos) != titanVertex.getID()) continue;
                final List<Entry> vresults = results.get(pos);
                ((CacheVertex)titanVertex).loadRelations(sq, new Retriever<SliceQuery, List<Entry>>(){

                    @Override
                    public List<Entry> get(SliceQuery query) {
                        return vresults;
                    }
                });
                ++pos;
            }
        }
    }

    public Function<Object, ? extends TitanElement> getConversionFunction(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.vertexIDConversionFct;
            }
            case EDGE: {
                return this.edgeIDConversionFct;
            }
        }
        throw new IllegalArgumentException("Unexpected result type: " + (Object)((Object)elementType));
    }

    @Override
    public GraphCentricQueryBuilder query() {
        return new GraphCentricQueryBuilder(this, this.graph.getIndexSerializer());
    }

    @Override
    public TitanIndexQuery indexQuery(String indexName, String query) {
        return new IndexQueryBuilder(this, this.indexSerializer).setIndex(indexName).setQuery(query);
    }

    @Override
    public Iterable<TitanVertex> getVertices(TitanKey key, Object attribute) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)attribute);
        return this.query().has(key, (TitanPredicate)Cmp.EQUAL, attribute).vertices();
    }

    @Override
    public TitanVertex getVertex(TitanKey key, Object attribute) {
        Preconditions.checkArgument((boolean)key.isUnique(Direction.IN), (String)"Key is not uniquely associated to value [%s]", (Object[])new Object[]{key.getName()});
        return (TitanVertex)Iterables.getOnlyElement(this.getVertices(key, attribute), null);
    }

    @Override
    public TitanVertex getVertex(String key, Object attribute) {
        if (!this.containsType(key)) {
            return null;
        }
        return this.getVertex((TitanKey)this.getType(key), attribute);
    }

    @Override
    public Iterable<TitanEdge> getEdges(TitanKey key, Object attribute) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)attribute);
        return this.query().has(key, (TitanPredicate)Cmp.EQUAL, attribute).edges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void commit() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "commit").inc();
        }
        try {
            if (this.hasModifications()) {
                this.graph.commit(this.addedRelations.getAll(), this.deletedRelations.values(), this);
            } else {
                this.txHandle.commit();
            }
            success = true;
            this.close();
            if (null == this.config.getMetricsPrefix() || success) return;
        }
        catch (Exception e) {
            try {
                try {
                    this.txHandle.rollback();
                    throw new TitanException("Could not commit transaction due to exception during persistence", e);
                }
                catch (StorageException e1) {
                    throw new TitanException("Could not rollback after a failed commit", e);
                }
            }
            catch (Throwable throwable) {
                this.close();
                if (null == this.config.getMetricsPrefix() || success) throw throwable;
                MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "commit.exceptions").inc();
                throw throwable;
            }
        }
        MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "commit.exceptions").inc();
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void rollback() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "rollback").inc();
        }
        try {
            this.txHandle.rollback();
            success = true;
            this.close();
            if (null == this.config.getMetricsPrefix() || success) return;
        }
        catch (Exception e) {
            try {
                throw new TitanException("Could not rollback transaction due to exception", e);
            }
            catch (Throwable throwable) {
                this.close();
                if (null == this.config.getMetricsPrefix() || success) throw throwable;
                MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "rollback.exceptions").inc();
                throw throwable;
            }
        }
        MetricManager.INSTANCE.getCounter(this.config.getMetricsPrefix(), "tx", "rollback.exceptions").inc();
        return;
    }

    private void close() {
        this.isOpen = false;
        this.vertexCache.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public boolean hasModifications() {
        return !this.addedRelations.isEmpty() || !this.deletedRelations.isEmpty();
    }

    private class VertexConstructor
    implements Retriever<Long, InternalVertex> {
        private final boolean verifyExistence;

        private VertexConstructor(boolean verifyExistence) {
            this.verifyExistence = verifyExistence;
        }

        @Override
        public InternalVertex get(Long vertexid) {
            Preconditions.checkNotNull((Object)vertexid);
            Preconditions.checkArgument((vertexid > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((StandardTitanTx.this.idInspector.isTypeID(vertexid) || StandardTitanTx.this.idInspector.isVertexID(vertexid) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexid});
            byte lifecycle = 2;
            if (this.verifyExistence && StandardTitanTx.this.graph.edgeQuery(vertexid, ((StandardTitanTx)StandardTitanTx.this).graph.vertexExistenceQuery, StandardTitanTx.this.txHandle).isEmpty()) {
                lifecycle = 6;
            }
            CacheVertex vertex = null;
            if (StandardTitanTx.this.idInspector.isTypeID(vertexid)) {
                if (StandardTitanTx.this.idInspector.isPropertyKeyID(vertexid)) {
                    vertex = new TitanKeyVertex(StandardTitanTx.this, vertexid, lifecycle);
                } else {
                    Preconditions.checkArgument((boolean)StandardTitanTx.this.idInspector.isEdgeLabelID(vertexid));
                    vertex = new TitanLabelVertex(StandardTitanTx.this, vertexid, lifecycle);
                }
                if (lifecycle == 2) {
                    StandardTitanTx.this.typeCache.put(((TitanType)((Object)vertex)).getName(), vertexid);
                }
            } else if (StandardTitanTx.this.idInspector.isVertexID(vertexid)) {
                vertex = new CacheVertex(StandardTitanTx.this, vertexid, lifecycle);
            } else {
                throw new IllegalArgumentException("ID could not be recognized");
            }
            return vertex;
        }
    }
}

