/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.DefaultTypeMaker;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TransactionBuilder;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;

public class StandardTransactionBuilder
implements TransactionConfiguration,
TransactionBuilder {
    private boolean isReadOnly = false;
    private boolean assignIDsImmediately = false;
    private DefaultTypeMaker defaultTypeMaker;
    private boolean verifyExternalVertexExistence = true;
    private boolean verifyInternalVertexExistence = false;
    private boolean verifyUniqueness = true;
    private boolean acquireLocks = true;
    private boolean propertyPrefetching = true;
    private boolean singleThreaded = false;
    private boolean threadBound = false;
    private int vertexCacheSize;
    private long indexCacheWeight;
    private Long timestamp = null;
    private String metricsPrefix;
    private boolean isOpen = true;
    private final StandardTitanGraph graph;

    public StandardTransactionBuilder(GraphDatabaseConfiguration graphConfig, StandardTitanGraph graph) {
        Preconditions.checkNotNull((Object)graphConfig);
        Preconditions.checkNotNull((Object)graph);
        this.graph = graph;
        this.defaultTypeMaker = graphConfig.getDefaultTypeMaker();
        this.assignIDsImmediately = graphConfig.hasFlushIDs();
        this.metricsPrefix = graphConfig.getMetricsPrefix();
        this.propertyPrefetching = graphConfig.hasPropertyPrefetching();
        if (graphConfig.isReadOnly()) {
            this.readOnly();
        }
        this.setCacheSize(graphConfig.getTxCacheSize());
        if (graphConfig.isBatchLoading()) {
            this.enableBatchLoading();
        }
    }

    private void verifyOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"Transaction has been started which renders this configuration immutable");
    }

    public StandardTransactionBuilder threadBound() {
        this.verifyOpen();
        this.threadBound = true;
        this.singleThreaded = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder readOnly() {
        this.verifyOpen();
        this.isReadOnly = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder enableBatchLoading() {
        this.verifyOpen();
        this.verifyUniqueness = false;
        this.verifyExternalVertexExistence = false;
        this.acquireLocks = false;
        return this;
    }

    @Override
    public StandardTransactionBuilder setCacheSize(int size) {
        this.verifyOpen();
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        this.vertexCacheSize = size;
        this.indexCacheWeight = size / 2;
        return this;
    }

    @Override
    public StandardTransactionBuilder checkInternalVertexExistence() {
        this.verifyOpen();
        this.verifyInternalVertexExistence = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder setTimestamp(long timestamp) {
        this.verifyOpen();
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public StandardTransactionBuilder setMetricsPrefix(String p) {
        this.verifyOpen();
        this.metricsPrefix = p;
        return this;
    }

    @Override
    public TitanTransaction start() {
        this.verifyOpen();
        this.isOpen = false;
        return this.graph.newTransaction(this);
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public final boolean hasAssignIDsImmediately() {
        return this.assignIDsImmediately;
    }

    @Override
    public final boolean hasVerifyExternalVertexExistence() {
        return this.verifyExternalVertexExistence;
    }

    @Override
    public final boolean hasVerifyInternalVertexExistence() {
        return this.verifyInternalVertexExistence;
    }

    @Override
    public final boolean hasAcquireLocks() {
        return this.acquireLocks;
    }

    @Override
    public final DefaultTypeMaker getAutoEdgeTypeMaker() {
        return this.defaultTypeMaker;
    }

    @Override
    public final boolean hasVerifyUniqueness() {
        return this.verifyUniqueness;
    }

    @Override
    public boolean hasPropertyPrefetching() {
        return this.propertyPrefetching;
    }

    @Override
    public final boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    @Override
    public final boolean isThreadBound() {
        return this.threadBound;
    }

    @Override
    public final int getVertexCacheSize() {
        return this.vertexCacheSize;
    }

    @Override
    public final long getIndexCacheWeight() {
        return this.indexCacheWeight;
    }

    @Override
    public boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    @Override
    public long getTimestamp() {
        Preconditions.checkState((this.timestamp != null ? 1 : 0) != 0, (Object)"A timestamp has not been configured");
        return this.timestamp;
    }
}

