/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class UniqueLockApplication {
    private final TitanVertex start;
    private final TitanType type;
    private final Object end;
    private final int hashcode;

    public UniqueLockApplication(TitanVertex start, TitanType type, Object end) {
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkArgument((type.isUnique(Direction.OUT) || type.isUnique(Direction.IN) ? 1 : 0) != 0);
        this.type = type;
        this.start = type.isUnique(Direction.OUT) ? start : null;
        this.end = type.isUnique(Direction.IN) ? end : null;
        this.hashcode = new HashCodeBuilder().append((Object)type).append((Object)start).append(end).toHashCode();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        UniqueLockApplication oth = (UniqueLockApplication)other;
        if (!this.type.equals(oth.type)) {
            return false;
        }
        if (this.start == null ? oth.start != null : !this.start.equals(oth.start)) {
            return false;
        }
        return !(this.end == null ? oth.end != null : !this.end.equals(oth.end));
    }

    public String toString() {
        return "(" + this.start + "-" + this.type + "->" + this.end + ")";
    }
}

