/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VertexIterable
implements Iterable<InternalVertex> {
    private final StandardTitanTx tx;
    private final StandardTitanGraph graph;

    public VertexIterable(StandardTitanGraph graph, StandardTitanTx tx) {
        this.graph = graph;
        this.tx = tx;
    }

    @Override
    public Iterator<InternalVertex> iterator() {
        return new Iterator<InternalVertex>(){
            RecordIterator<Long> iterator;
            InternalVertex nextVertex;
            {
                this.iterator = VertexIterable.this.graph.getVertexIDs(VertexIterable.this.tx.getTxHandle());
                this.nextVertex = this.nextVertex();
            }

            private InternalVertex nextVertex() {
                InternalVertex v = null;
                while (v == null && this.iterator.hasNext()) {
                    long nextId = (Long)this.iterator.next();
                    v = VertexIterable.this.tx.getExistingVertex(nextId);
                    if (!v.isRemoved() && !(v instanceof TitanType)) continue;
                    v = null;
                }
                return v;
            }

            @Override
            public boolean hasNext() {
                return this.nextVertex != null;
            }

            @Override
            public InternalVertex next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                InternalVertex returnVertex = this.nextVertex;
                this.nextVertex = this.nextVertex();
                return returnVertex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

