/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction.indexcache;

import com.google.common.collect.HashMultimap;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.IndexCache;
import java.util.ArrayList;

public class ConcurrentIndexCache
implements IndexCache {
    private final HashMultimap<Object, TitanProperty> map = HashMultimap.create();

    @Override
    public synchronized void add(TitanProperty property) {
        this.map.put(property.getValue(), (Object)property);
    }

    @Override
    public synchronized void remove(TitanProperty property) {
        this.map.remove(property.getValue(), (Object)property);
    }

    @Override
    public synchronized Iterable<TitanProperty> get(Object value, TitanKey key) {
        ArrayList<TitanProperty> result = new ArrayList<TitanProperty>(4);
        for (TitanProperty p : this.map.get(value)) {
            if (!p.getPropertyKey().equals(key)) continue;
            result.add(p);
        }
        return result;
    }
}

