/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction.vertexcache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.transaction.vertexcache.VertexCache;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

public class GuavaVertexCache
implements VertexCache {
    private final ConcurrentMap<Long, InternalVertex> volatileVertices = new NonBlockingHashMapLong();
    private final Cache<Long, InternalVertex> cache;

    public GuavaVertexCache(long capacity, int concurrencyLevel) {
        this.cache = CacheBuilder.newBuilder().maximumSize(capacity).concurrencyLevel(concurrencyLevel).removalListener((RemovalListener)new RemovalListener<Long, InternalVertex>(){

            public void onRemoval(RemovalNotification<Long, InternalVertex> notification) {
                if (notification.getCause() == RemovalCause.EXPLICIT) {
                    assert (GuavaVertexCache.this.volatileVertices.isEmpty());
                    return;
                }
                assert (notification.getCause() == RemovalCause.SIZE || notification.getCause() == RemovalCause.REPLACED) : "Cause: " + notification.getCause();
                InternalVertex v = (InternalVertex)notification.getValue();
                if (v.hasAddedRelations()) {
                    GuavaVertexCache.this.volatileVertices.putIfAbsent(notification.getKey(), v);
                }
            }
        }).build();
    }

    @Override
    public boolean contains(long id) {
        Long vertexId = id;
        return this.cache.getIfPresent((Object)vertexId) != null || this.volatileVertices.containsKey(vertexId);
    }

    @Override
    public InternalVertex get(long id, Retriever<Long, InternalVertex> retriever) {
        Long vertexId = id;
        InternalVertex vertex = (InternalVertex)this.cache.getIfPresent((Object)vertexId);
        if (vertex == null) {
            InternalVertex newVertex = (InternalVertex)this.volatileVertices.get(vertexId);
            if (newVertex == null) {
                newVertex = retriever.get(vertexId);
            }
            assert (newVertex != null);
            try {
                vertex = (InternalVertex)this.cache.get((Object)vertexId, (Callable)new NewVertexCallable(newVertex));
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Should not happen: " + e.getMessage()));
            }
            assert (vertex != null);
        }
        return vertex;
    }

    @Override
    public void add(InternalVertex vertex, long id) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0);
        Long vertexId = id;
        this.cache.put((Object)vertexId, (Object)vertex);
        if (vertex.isNew() || vertex.hasAddedRelations()) {
            this.volatileVertices.put(vertexId, vertex);
        }
    }

    @Override
    public List<InternalVertex> getAllNew() {
        ArrayList<InternalVertex> vertices = new ArrayList<InternalVertex>(10);
        for (InternalVertex v : this.volatileVertices.values()) {
            if (!v.isNew()) continue;
            vertices.add(v);
        }
        return vertices;
    }

    @Override
    public synchronized void close() {
        this.volatileVertices.clear();
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class NewVertexCallable
    implements Callable<InternalVertex> {
        private final InternalVertex vertex;

        private NewVertexCallable(InternalVertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public InternalVertex call() {
            return this.vertex;
        }
    }
}

