/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndexType {
    private static final int VERTEX = 0;
    private static final int EDGE = 1;
    private String indexName;
    private int element;

    private static final int fromType(Class<? extends Element> element) {
        if (element == Vertex.class) {
            return 0;
        }
        if (element == Edge.class) {
            return 1;
        }
        throw new IllegalArgumentException("Either vertex or edge expected: " + element);
    }

    private static final Class<? extends Element> toType(int element) {
        if (element == 0) {
            return Vertex.class;
        }
        if (element == 1) {
            return Edge.class;
        }
        throw new IllegalArgumentException("Either vertex or edge expected: " + element);
    }

    public IndexType() {
    }

    public IndexType(String indexName, Class<? extends Element> element) {
        this.indexName = indexName;
        this.element = IndexType.fromType(element);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Class<? extends Element> getElementType() {
        return IndexType.toType(this.element);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        IndexType oth = (IndexType)other;
        return this.element == oth.element && this.indexName.equals(oth.indexName);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.indexName).append(this.element).toHashCode();
    }

    public String toString() {
        return this.indexName + ":" + IndexType.toType(this.element).getSimpleName();
    }
}

