/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.KeyMaker;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TypeMaker;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.IndexDefinition;
import com.thinkaurelius.titan.graphdb.types.IndexParameters;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.StandardTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class StandardKeyMaker
extends StandardTypeMaker
implements KeyMaker {
    private Class<?> dataType = null;
    private Set<IndexDefinition> indexes = new HashSet<IndexDefinition>(4);
    private Parameter[] indexParas;

    public StandardKeyMaker(StandardTitanTx tx, IndexSerializer indexSerializer) {
        super(tx, indexSerializer);
        super.unique(Direction.OUT, TypeMaker.UniquenessConsistency.NO_LOCK);
    }

    @Override
    public StandardKeyMaker dataType(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Need to specify a data type");
        this.dataType = clazz;
        return this;
    }

    @Override
    public KeyMaker list() {
        super.unique(Direction.OUT, null);
        return this;
    }

    @Override
    public KeyMaker single(TypeMaker.UniquenessConsistency consistency) {
        super.unique(Direction.OUT, consistency);
        return this;
    }

    @Override
    public KeyMaker single() {
        this.single(TypeMaker.UniquenessConsistency.LOCK);
        return this;
    }

    @Override
    public KeyMaker unique(TypeMaker.UniquenessConsistency consistency) {
        super.unique(Direction.IN, consistency);
        return this;
    }

    @Override
    public KeyMaker unique() {
        this.unique(TypeMaker.UniquenessConsistency.LOCK);
        return this;
    }

    @Override
    public StandardKeyMaker indexed(Class<? extends Element> clazz) {
        if (clazz == Element.class) {
            this.indexes.add(IndexDefinition.of(Vertex.class));
            this.indexes.add(IndexDefinition.of(Edge.class));
        } else {
            this.indexes.add(IndexDefinition.of(clazz));
        }
        return this;
    }

    @Override
    public StandardKeyMaker indexed(String indexName, Class<? extends Element> clazz, Parameter ... paras) {
        if (clazz == Element.class) {
            this.indexes.add(IndexDefinition.of(indexName, Vertex.class, paras));
            this.indexes.add(IndexDefinition.of(indexName, Edge.class, paras));
        } else {
            this.indexes.add(IndexDefinition.of(indexName, clazz, paras));
        }
        return this;
    }

    @Override
    public StandardKeyMaker hidden() {
        super.hidden();
        return this;
    }

    @Override
    public StandardKeyMaker unModifiable() {
        super.unModifiable();
        return this;
    }

    @Override
    public StandardKeyMaker makeStatic(Direction direction) {
        super.makeStatic(direction);
        return this;
    }

    @Override
    public StandardKeyMaker signature(TitanType ... types) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StandardKeyMaker sortKey(TitanType ... types) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StandardKeyMaker sortOrder(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TitanKey make() {
        Preconditions.checkArgument((this.dataType != null ? 1 : 0) != 0, (Object)"Need to specify a datatype");
        Preconditions.checkArgument((!this.dataType.isPrimitive() ? 1 : 0) != 0, (String)"Primitive types are not supported. Use the corresponding object type, e.g. Integer.class instead of int.class [%s]", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((!this.dataType.isInterface() ? 1 : 0) != 0, (String)"Datatype must be a class and not an interface: %s", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((this.dataType.isArray() || !Modifier.isAbstract(this.dataType.getModifiers()) ? 1 : 0) != 0, (String)"Datatype cannot be an abstract class: %s", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((!this.isUnique(Direction.IN) || this.indexes.contains(IndexDefinition.of(Vertex.class)) ? 1 : 0) != 0, (Object)"A unique key must be indexed for vertices. Add 'indexed(Vertex.class)' to this key definition.");
        IndexType[] indexTypes = new IndexType[this.indexes.size()];
        IndexParameters[] indexParas = new IndexParameters[this.indexes.size()];
        int i = 0;
        for (IndexDefinition it : this.indexes) {
            Preconditions.checkArgument((this.isUnique(Direction.OUT) || it.isStandardIndex() && it.getElementType() == Vertex.class ? 1 : 0) != 0, (Object)"Only standard index is allowed on list property keys");
            Preconditions.checkArgument((boolean)this.indexSerializer.supports(it.getIndexName(), this.dataType, it.getParameters()), (String)"Index [%s] does not support data type [%s] with parameters [%s]", (Object[])new Object[]{it.getIndexName(), this.dataType, it.getParameters()});
            Preconditions.checkArgument((!it.isStandardIndex() || it.getParameters().length == 0 ? 1 : 0) != 0, (Object)"Standard index does not support parameters");
            indexTypes[i] = it.getIndexType();
            indexParas[i] = it.getIndexParamters();
            ++i;
        }
        TypeAttribute.Map definition = this.makeDefinition();
        definition.setValue(TypeAttributeType.DATATYPE, this.dataType).setValue(TypeAttributeType.INDEXES, indexTypes).setValue(TypeAttributeType.INDEX_PARAMETERS, indexParas);
        return this.tx.makePropertyKey(this.getName(), definition);
    }
}

