/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TypeMaker;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

abstract class StandardTypeMaker
implements TypeMaker {
    private static final Set<String> RESERVED_NAMES = ImmutableSet.of((Object)"id", (Object)"label");
    private static final char[] RESERVED_CHARS = new char[]{'{', '}', '\"'};
    protected final StandardTitanTx tx;
    protected final IndexSerializer indexSerializer;
    private String name;
    private boolean[] isUnique;
    private boolean[] hasUniqueLock;
    private boolean[] isStatic;
    private boolean isHidden;
    private boolean isModifiable;
    private List<TitanType> sortKey;
    private Order sortOrder;
    private List<TitanType> signature;

    public StandardTypeMaker(StandardTitanTx tx, IndexSerializer indexSerializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)indexSerializer);
        this.tx = tx;
        this.indexSerializer = indexSerializer;
        this.name = null;
        this.isUnique = new boolean[2];
        this.hasUniqueLock = new boolean[2];
        this.isStatic = new boolean[2];
        this.isHidden = false;
        this.isModifiable = true;
        this.sortKey = new ArrayList<TitanType>(4);
        this.sortOrder = Order.ASC;
        this.signature = new ArrayList<TitanType>(4);
    }

    private void checkGeneralArguments() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"Need to specify name");
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((this.name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name can not contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf(c), this.name});
        }
        Preconditions.checkArgument((!this.name.startsWith("#System#") ? 1 : 0) != 0, (Object)"Name starts with a reserved keyword: #System#");
        Preconditions.checkArgument((!RESERVED_NAMES.contains(this.name.toLowerCase()) ? 1 : 0) != 0, (Object)("Name is reserved: " + this.name));
        for (int i = 0; i < 2; ++i) {
            Preconditions.checkArgument((!this.hasUniqueLock[i] || this.isUnique[i] ? 1 : 0) != 0, (Object)"Must be unique in order to have a lock");
        }
        StandardTypeMaker.checkSortKey(this.sortKey);
        Preconditions.checkArgument((this.sortOrder == Order.ASC || !this.sortKey.isEmpty() ? 1 : 0) != 0, (Object)"Must define a sort key to use ordering");
        StandardTypeMaker.checkSignature(this.signature);
        Preconditions.checkArgument((boolean)Sets.intersection((Set)Sets.newHashSet(this.sortKey), (Set)Sets.newHashSet(this.signature)).isEmpty(), (Object)"Signature and sort key must be disjoined");
        if (this.isUnique[0] && this.isUnique[1] && !this.sortKey.isEmpty()) {
            throw new IllegalArgumentException("Cannot define a sort key on a both-unique type");
        }
    }

    private static long[] checkSortKey(List<TitanType> sig) {
        for (TitanType t : sig) {
            Preconditions.checkArgument((t.isEdgeLabel() || Comparable.class.isAssignableFrom(((TitanKey)t).getDataType()) ? 1 : 0) != 0, (Object)("Key must have comparable data type to be used as sort key: " + t));
        }
        return StandardTypeMaker.checkSignature(sig);
    }

    private static long[] checkSignature(List<TitanType> sig) {
        Preconditions.checkArgument((sig.size() == Sets.newHashSet(sig).size() ? 1 : 0) != 0, (Object)"Signature and sort key cannot contain duplicate types");
        long[] signature = new long[sig.size()];
        for (int i = 0; i < sig.size(); ++i) {
            TitanType et = sig.get(i);
            Preconditions.checkNotNull((Object)et);
            Preconditions.checkArgument((boolean)et.isUnique(Direction.OUT), (String)"Type must be single valued: %s", (Object[])new Object[]{et.getName()});
            Preconditions.checkArgument((!et.isEdgeLabel() || ((TitanLabel)et).isUnidirected() ? 1 : 0) != 0, (String)"Label must be unidirectional: %s", (Object[])new Object[]{et.getName()});
            Preconditions.checkArgument((!et.isPropertyKey() || !((TitanKey)et).getDataType().equals(Object.class) ? 1 : 0) != 0, (String)"Signature and sort keys must have a proper declared datatype: %s", (Object[])new Object[]{et.getName()});
            signature[i] = et.getID();
        }
        return signature;
    }

    protected final TypeAttribute.Map makeDefinition() {
        this.checkGeneralArguments();
        TypeAttribute.Map def = new TypeAttribute.Map();
        def.setValue(TypeAttributeType.UNIQUENESS, new boolean[]{this.isUnique[0], this.isUnique[1]});
        def.setValue(TypeAttributeType.UNIQUENESS_LOCK, this.hasUniqueLock);
        def.setValue(TypeAttributeType.STATIC, this.isStatic);
        def.setValue(TypeAttributeType.HIDDEN, this.isHidden);
        def.setValue(TypeAttributeType.MODIFIABLE, this.isModifiable);
        def.setValue(TypeAttributeType.SORT_KEY, StandardTypeMaker.checkSortKey(this.sortKey));
        def.setValue(TypeAttributeType.SORT_ORDER, (Object)this.sortOrder);
        def.setValue(TypeAttributeType.SIGNATURE, StandardTypeMaker.checkSignature(this.signature));
        return def;
    }

    protected StandardTypeMaker signature(TitanType ... types) {
        this.signature.addAll(Arrays.asList(types));
        return this;
    }

    protected StandardTypeMaker sortKey(TitanType ... types) {
        this.sortKey.addAll(Arrays.asList(types));
        return this;
    }

    protected StandardTypeMaker sortOrder(Order order) {
        Preconditions.checkNotNull((Object)((Object)order));
        this.sortOrder = order;
        return this;
    }

    public StandardTypeMaker name(String name) {
        this.name = name;
        return this;
    }

    protected String getName() {
        return this.name;
    }

    protected boolean isUnique(Direction direction) {
        Preconditions.checkArgument((direction == Direction.IN || direction == Direction.OUT ? 1 : 0) != 0);
        return this.isUnique[EdgeDirection.position(direction)];
    }

    protected StandardTypeMaker unique(Direction direction, TypeMaker.UniquenessConsistency consistency) {
        if (direction == Direction.BOTH) {
            this.unique(Direction.IN, consistency);
            this.unique(Direction.OUT, consistency);
        } else {
            this.isUnique[EdgeDirection.position((Direction)direction)] = consistency != null;
            this.hasUniqueLock[EdgeDirection.position((Direction)direction)] = consistency == TypeMaker.UniquenessConsistency.LOCK;
        }
        return this;
    }

    public StandardTypeMaker hidden() {
        this.isHidden = true;
        return this;
    }

    public StandardTypeMaker unModifiable() {
        this.isModifiable = false;
        return this;
    }

    public StandardTypeMaker makeStatic(Direction direction) {
        if (direction == Direction.BOTH) {
            this.makeStatic(Direction.IN);
            this.makeStatic(Direction.OUT);
        } else {
            this.isStatic[EdgeDirection.position((Direction)direction)] = true;
        }
        return this;
    }

    protected boolean isStatic(Direction direction) {
        Preconditions.checkArgument((direction == Direction.IN || direction == Direction.OUT ? 1 : 0) != 0);
        return this.isStatic[EdgeDirection.position(direction)];
    }
}

