/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.types.system.EmptyVertex;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.lang.StringUtils;

public abstract class SystemType
extends EmptyVertex
implements InternalVertex,
InternalType {
    private final String name;
    private final long id;
    private final boolean[] isUnique;
    private final boolean[] isStatic;
    private final boolean isModifiable;

    SystemType(String name, long id, RelationType type, boolean[] isUnique, boolean[] isStatic, boolean isModifiable) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        Preconditions.checkArgument((isUnique != null && isUnique.length == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((isStatic != null && isStatic.length == 2 ? 1 : 0) != 0);
        this.name = "#System#" + name;
        this.id = SystemType.getSystemTypeId(id, type);
        this.isUnique = isUnique;
        this.isStatic = isStatic;
        this.isModifiable = isModifiable;
    }

    static long getSystemTypeId(long id, RelationType type) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((id <= 8L ? 1 : 0) != 0, (String)"System id [%s] is too large", (Object[])new Object[]{id});
        Preconditions.checkArgument((boolean)type.isProper());
        switch (type) {
            case EDGE: {
                return IDManager.getEdgeLabelID(id);
            }
            case PROPERTY: {
                return IDManager.getPropertyKeyID(id);
            }
        }
        throw new AssertionError((Object)("Illegal condition: " + type));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isUnique(Direction direction) {
        return this.isUnique[EdgeDirection.position(direction)];
    }

    @Override
    public boolean isStatic(Direction dir) {
        return this.isStatic[EdgeDirection.position(dir)];
    }

    @Override
    public boolean uniqueLock(Direction direction) {
        return this.isUnique(direction);
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return this.isModifiable;
    }

    @Override
    public long[] getSortKey() {
        return new long[0];
    }

    @Override
    public Order getSortOrder() {
        return Order.ASC;
    }

    @Override
    public long[] getSignature() {
        return new long[0];
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return true;
    }

    @Override
    public void setID(long id) {
        throw new IllegalStateException("SystemType has already been assigned an id");
    }
}

