/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.vertices;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.IndexDefinition;
import com.thinkaurelius.titan.graphdb.types.IndexParameters;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanTypeVertex;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import javax.annotation.Nullable;

public class TitanKeyVertex
extends TitanTypeVertex
implements TitanKey {
    private volatile transient IndexDefinition[] indexes;
    private volatile transient List<IndexDefinition> vertexIndexes;
    private volatile transient List<IndexDefinition> edgeIndexes;

    public TitanKeyVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public Class<?> getDataType() {
        return this.getDefinition().getValue(TypeAttributeType.DATATYPE, Class.class);
    }

    @Override
    public final boolean isPropertyKey() {
        return true;
    }

    @Override
    public final boolean isEdgeLabel() {
        return false;
    }

    private IndexDefinition[] getIndexes() {
        if (this.indexes == null) {
            IndexType[] indexTypes = this.getDefinition().getValue(TypeAttributeType.INDEXES, IndexType[].class);
            IndexParameters[] indexParas = this.getDefinition().getValue(TypeAttributeType.INDEX_PARAMETERS, IndexParameters[].class);
            Preconditions.checkArgument((indexTypes != null ? 1 : 0) != 0, (Object)"Missing index types!");
            if (indexParas == null) {
                indexParas = new IndexParameters[indexTypes.length];
                for (int i = 0; i < indexTypes.length; ++i) {
                    indexParas[i] = new IndexParameters(indexTypes[i].getIndexName(), new Parameter[0]);
                }
            }
            Preconditions.checkArgument((indexTypes.length == indexParas.length ? 1 : 0) != 0, (String)"Lengths don't agree: %s vs %s", (Object[])new Object[]{indexTypes.length, indexParas.length});
            IndexDefinition[] tmp = new IndexDefinition[indexTypes.length];
            for (int i = 0; i < indexTypes.length; ++i) {
                tmp[i] = IndexDefinition.of(indexTypes[i], indexParas[i]);
            }
            this.indexes = tmp;
        }
        Preconditions.checkNotNull((Object)this.indexes);
        return this.indexes;
    }

    @Override
    public Iterable<String> getIndexes(Class<? extends Element> clazz) {
        if (clazz == Vertex.class || clazz == Edge.class) {
            if (this.getIndexList(clazz).isEmpty()) {
                return ImmutableList.of();
            }
            return Iterables.transform(this.getIndexList(clazz), (Function)new Function<IndexDefinition, String>(){

                @Nullable
                public String apply(@Nullable IndexDefinition indexType) {
                    return indexType.getIndexName();
                }
            });
        }
        if (clazz == Element.class) {
            return Iterables.concat(this.getIndexes(Vertex.class), this.getIndexes(Edge.class));
        }
        throw new IllegalArgumentException("Unexpected element type: " + clazz);
    }

    @Override
    public boolean hasIndex(String name, Class<? extends Element> elementType) {
        return this.getIndex(name, elementType) != null;
    }

    public IndexDefinition getIndex(String name, Class<? extends Element> elementType) {
        Preconditions.checkArgument((elementType == Vertex.class || elementType == Edge.class ? 1 : 0) != 0, (Object)"Expected Vertex or Edge class as argument");
        for (int i = 0; i < this.getIndexes().length; ++i) {
            IndexDefinition def = this.getIndexes()[i];
            if (def.getElementType() != elementType || !def.getIndexName().equals(name)) continue;
            return def;
        }
        return null;
    }

    private List<IndexDefinition> getIndexList(Class<? extends Element> type) {
        ImmutableList result;
        Preconditions.checkArgument((type == Vertex.class || type == Edge.class ? 1 : 0) != 0, (Object)"Expected Vertex or Edge class as argument");
        Object object = result = type == Vertex.class ? this.vertexIndexes : this.edgeIndexes;
        if (result == null) {
            ImmutableList.Builder b = new ImmutableList.Builder();
            for (IndexDefinition it : this.getIndexes()) {
                if (!type.isAssignableFrom(it.getElementType())) continue;
                b.add((Object)it);
            }
            result = b.build();
            if (type == Vertex.class) {
                this.vertexIndexes = result;
            } else if (type == Edge.class) {
                this.edgeIndexes = result;
            }
        }
        return result;
    }
}

