/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.vertices;

import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheVertex
extends StandardVertex {
    private final Map<SliceQuery, List<Entry>> queryCache = new HashMap<SliceQuery, List<Entry>>(4);

    public CacheVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entry> loadRelations(SliceQuery query, Retriever<SliceQuery, List<Entry>> lookup) {
        List<Entry> result;
        if (this.isNew()) {
            return Collections.EMPTY_SET;
        }
        Map<SliceQuery, List<Entry>> map = this.queryCache;
        synchronized (map) {
            result = this.queryCache.get(query);
        }
        if (result == null) {
            Map.Entry<SliceQuery, List<Entry>> superset = this.getSuperResultSet(query);
            result = superset == null ? lookup.get(query) : query.getSubset(superset.getKey(), superset.getValue());
            Map<SliceQuery, List<Entry>> map2 = this.queryCache;
            synchronized (map2) {
                this.queryCache.put(query, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        Map<SliceQuery, List<Entry>> map = this.queryCache;
        synchronized (map) {
            return this.queryCache.get(query) != null || this.getSuperResultSet(query) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<SliceQuery, List<Entry>> getSuperResultSet(SliceQuery query) {
        if (this.queryCache.size() > 0) {
            Map<SliceQuery, List<Entry>> map = this.queryCache;
            synchronized (map) {
                for (Map.Entry<SliceQuery, List<Entry>> entry : this.queryCache.entrySet()) {
                    if (!entry.getKey().subsumes(query)) continue;
                    return entry;
                }
            }
        }
        return null;
    }
}

