/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.AddedRelationsContainer;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.ConcurrentAddedRelations;
import com.thinkaurelius.titan.graphdb.transaction.addedrelations.SimpleAddedRelations;
import com.thinkaurelius.titan.graphdb.vertices.AbstractVertex;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StandardVertex
extends AbstractVertex {
    private byte lifecycle;
    private volatile AddedRelationsContainer addedRelations = AddedRelationsContainer.EMPTY;

    public StandardVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id);
        this.lifecycle = lifecycle;
    }

    private final synchronized void updateLifeCycle(ElementLifeCycle.Event event) {
        this.lifecycle = ElementLifeCycle.update(this.lifecycle, event);
    }

    @Override
    public void removeRelation(InternalRelation r) {
        if (r.isNew()) {
            this.addedRelations.remove(r);
        } else if (r.isLoaded()) {
            this.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
        } else {
            throw new IllegalArgumentException("Unexpected relation status: " + r.isRemoved());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRelation(InternalRelation r) {
        Preconditions.checkArgument((boolean)r.isNew());
        if (this.addedRelations == AddedRelationsContainer.EMPTY) {
            if (this.tx().getConfiguration().isSingleThreaded()) {
                this.addedRelations = new SimpleAddedRelations();
            } else {
                StandardVertex standardVertex = this;
                synchronized (standardVertex) {
                    if (this.addedRelations == AddedRelationsContainer.EMPTY) {
                        this.addedRelations = new ConcurrentAddedRelations();
                    }
                }
            }
        }
        if (this.addedRelations.add(r)) {
            this.updateLifeCycle(ElementLifeCycle.Event.ADDED_RELATION);
            return true;
        }
        return false;
    }

    @Override
    public List<InternalRelation> getAddedRelations(Predicate<InternalRelation> query) {
        return this.addedRelations.getView(query);
    }

    @Override
    public Collection<Entry> loadRelations(SliceQuery query, Retriever<SliceQuery, List<Entry>> lookup) {
        return this.isNew() ? Collections.EMPTY_LIST : lookup.get(query);
    }

    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        return false;
    }

    @Override
    public boolean hasRemovedRelations() {
        return ElementLifeCycle.hasRemovedRelations(this.lifecycle);
    }

    @Override
    public boolean hasAddedRelations() {
        return ElementLifeCycle.hasAddedRelations(this.lifecycle);
    }

    @Override
    public synchronized void remove() {
        super.remove();
        this.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
    }

    @Override
    public byte getLifeCycle() {
        return this.lifecycle;
    }
}

