/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.tinkerpop.gremlin;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.tinkerpop.gremlin.Imports;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;

public class ConsoleSetup {
    private static final ImmutableList<String> imports;
    private static final ImmutableList<String> staticImports;
    private static final ImmutableList<String> allImportsGremlin;

    public static List<String> getNonStaticImports() {
        return imports;
    }

    public static List<String> getStaticImports() {
        return staticImports;
    }

    public static List<String> getAllImportStatements() {
        return allImportsGremlin;
    }

    public static void main(String[] args) throws FileNotFoundException {
        PrintStream s = System.out;
        if (0 < args.length) {
            File f = new File(args[0]);
            File parent = f.getParentFile();
            if (null != parent && !parent.exists()) {
                parent.mkdirs();
            }
            s = new PrintStream(f);
        }
        Joiner commas = Joiner.on((char)',');
        s.print("imports = ");
        s.println(commas.join(ConsoleSetup.getNonStaticImports()));
        s.print("staticimports = ");
        s.println(commas.join(ConsoleSetup.getStaticImports()));
        s.close();
    }

    static {
        ImmutableList.Builder b;
        ImmutableList.Builder si = ImmutableList.builder();
        ImmutableList.Builder i = ImmutableList.builder();
        for (String s : com.tinkerpop.gremlin.Imports.getImports()) {
            if (s.startsWith("static ")) {
                s = s.substring(7);
                b = si;
            } else {
                b = i;
            }
            b.add((Object)s);
        }
        for (String s : Imports.getImports()) {
            if (s.startsWith("static ")) {
                s = s.substring(7);
                b = si;
            } else {
                b = i;
            }
            b.add((Object)s);
        }
        i.add((Object)"com.tinkerpop.gremlin.Tokens.T");
        i.add((Object)"com.tinkerpop.gremlin.groovy.*");
        imports = i.build();
        staticImports = si.build();
        ImmutableList.Builder allBuilder = ImmutableList.builder();
        for (String s : imports) {
            allBuilder.add((Object)("import " + s + ";"));
        }
        for (String s : staticImports) {
            allBuilder.add((Object)("import static " + s + ";"));
        }
        allImportsGremlin = allBuilder.build();
    }
}

