/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import cern.colt.list.AbstractIntList;
import cern.colt.list.AbstractLongList;
import cern.colt.list.LongArrayList;

public class AbstractLongListUtil {
    public static boolean isSorted(AbstractLongList l, boolean unique) {
        long[] values = l.elements();
        for (int i = 1; i < l.size(); ++i) {
            if (values[i] >= values[i - 1] && (!unique || values[i] != values[i - 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(AbstractLongList l) {
        return AbstractLongListUtil.isSorted(l, false);
    }

    public static boolean isSorted(AbstractIntList l, boolean unique) {
        int[] values = l.elements();
        for (int i = 1; i < l.size(); ++i) {
            if (values[i] >= values[i - 1] && (!unique || values[i] != values[i - 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(AbstractIntList l) {
        return AbstractLongListUtil.isSorted(l, false);
    }

    public static LongArrayList mergeJoin(AbstractLongList a, AbstractLongList b, boolean unique) {
        assert (AbstractLongListUtil.isSorted(a)) : a.toString();
        assert (AbstractLongListUtil.isSorted(b)) : b.toString();
        int counterA = 0;
        int counterB = 0;
        int sizeA = a.size();
        int sizeB = b.size();
        long[] valuesA = a.elements();
        long[] valuesB = b.elements();
        LongArrayList merge = new LongArrayList(Math.min(sizeA, sizeB));
        int resultSize = 0;
        while (counterA < sizeA && counterB < sizeB) {
            if (valuesA[counterA] == valuesB[counterB]) {
                long value = valuesA[counterA];
                if (!unique) {
                    merge.add(value);
                    ++resultSize;
                } else if (resultSize <= 0 || merge.get(resultSize - 1) != value) {
                    merge.add(value);
                    ++resultSize;
                }
                ++counterA;
                ++counterB;
                continue;
            }
            if (valuesA[counterA] < valuesB[counterB]) {
                ++counterA;
                continue;
            }
            assert (valuesA[counterA] > valuesB[counterB]);
            ++counterB;
        }
        return merge;
    }

    public static LongArrayList singleton(long el) {
        LongArrayList l = new LongArrayList(1);
        l.add(el);
        return l;
    }
}

