/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CompactMap
implements Map<String, Object> {
    private final String[] keys;
    private final Object[] values;
    private static final Map<KeyContainer, KeyContainer> KEY_CACHE = new HashMap<KeyContainer, KeyContainer>(100);
    private static final KeyContainer KEY_HULL = new KeyContainer();

    private CompactMap(String[] keys, Object[] values) {
        CompactMap.checkKeys(keys);
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Invalid values");
        }
        if (values.length != keys.length) {
            throw new IllegalArgumentException("Keys and values do not match in length");
        }
        this.keys = CompactMap.deduplicateKeys(keys);
        this.values = values;
    }

    public static final CompactMap of(String[] keys, Object[] values) {
        return new CompactMap(keys, values);
    }

    private static final void checkKeys(String[] keys) {
        if (keys == null || keys.length < 1) {
            throw new IllegalArgumentException("Invalid keys");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != null) continue;
            throw new IllegalArgumentException("Key cannot be null at position " + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] deduplicateKeys(String[] keys) {
        Map<KeyContainer, KeyContainer> map = KEY_CACHE;
        synchronized (map) {
            KEY_HULL.setKeys(keys);
            KeyContainer retrieved = KEY_CACHE.get(KEY_HULL);
            if (retrieved == null) {
                retrieved = new KeyContainer(keys);
                KEY_CACHE.put(retrieved, retrieved);
            }
            return retrieved.getKeys();
        }
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object o) {
        return CompactMap.indexOf(this.keys, o) >= 0;
    }

    @Override
    public boolean containsValue(Object o) {
        return CompactMap.indexOf(this.values, o) >= 0;
    }

    private static int indexOf(Object[] arr, Object o) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object get(Object o) {
        int pos = CompactMap.indexOf(this.keys, o);
        if (pos >= 0) {
            return this.values[pos];
        }
        return null;
    }

    @Override
    public Object put(String s, Object o) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public Object remove(Object o) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public Set<String> keySet() {
        return new Set<String>(){

            @Override
            public int size() {
                return CompactMap.this.keys.length;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                return CompactMap.indexOf(CompactMap.this.keys, o) >= 0;
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int currentPos = -1;

                    @Override
                    public boolean hasNext() {
                        return this.currentPos < CompactMap.this.keys.length - 1;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.currentPos;
                        return CompactMap.this.keys[this.currentPos];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This map is immutable");
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] ts) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(String s) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean containsAll(Collection<?> objects) {
                for (Object o : objects) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> strings) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean retainAll(Collection<?> objects) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean removeAll(Collection<?> objects) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("This map is immutable");
            }
        };
    }

    @Override
    public Collection<Object> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new Set<Map.Entry<String, Object>>(){

            @Override
            public int size() {
                return CompactMap.this.keys.length;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    int currentPos = -1;

                    @Override
                    public boolean hasNext() {
                        return this.currentPos < CompactMap.this.keys.length - 1;
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.currentPos;
                        return new Map.Entry<String, Object>(){
                            private final int position;
                            {
                                this.position = currentPos;
                            }

                            @Override
                            public String getKey() {
                                return CompactMap.this.keys[this.position];
                            }

                            @Override
                            public Object getValue() {
                                return CompactMap.this.values[this.position];
                            }

                            @Override
                            public Object setValue(Object o) {
                                throw new UnsupportedOperationException("This map is immutable");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This map is immutable");
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] ts) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<String, Object> stringObjectEntry) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean containsAll(Collection<?> objects) {
                for (Object o : objects) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, Object>> entries) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean retainAll(Collection<?> objects) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public boolean removeAll(Collection<?> objects) {
                throw new UnsupportedOperationException("This map is immutable");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("This map is immutable");
            }
        };
    }

    private static class KeyContainer {
        private String[] keys;
        private int hashcode;

        KeyContainer(String[] keys) {
            this.setKeys(keys);
        }

        KeyContainer() {
        }

        void setKeys(String[] keys) {
            CompactMap.checkKeys(keys);
            this.keys = keys;
            this.hashcode = Arrays.hashCode(keys);
        }

        public String[] getKeys() {
            return this.keys;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyContainer)) {
                return false;
            }
            return Arrays.deepEquals(this.keys, ((KeyContainer)other).keys);
        }

        public static final KeyContainer of(String[] header) {
            return new KeyContainer(header);
        }
    }
}

