/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public class IterablesUtil {
    public static final <O> Iterable<O> emptyIterable() {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return Iterators.emptyIterator();
            }
        };
    }

    public static final <O> Iterable<O> limitedIterable(Iterable<O> iterable, final int limit) {
        return Iterables.filter(iterable, (Predicate)new Predicate<O>(){
            int count = 0;

            public boolean apply(@Nullable O o) {
                ++this.count;
                return this.count <= limit;
            }
        });
    }

    public static final int size(Iterable i) {
        if (i instanceof Collection) {
            return ((Collection)i).size();
        }
        return Iterables.size((Iterable)i);
    }

    public static final boolean sizeLargerOrEqualThan(Iterable i, int limit) {
        if (i instanceof Collection) {
            return ((Collection)i).size() >= limit;
        }
        Iterator iter = i.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            if (++count < limit) continue;
            return true;
        }
        return false;
    }
}

