/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import com.thinkaurelius.titan.util.datastructures.Interval;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ProperInterval<T extends Comparable<T>>
implements Interval<T> {
    private boolean startInclusive = true;
    private boolean endInclusive = true;
    private T start = null;
    private T end = null;

    public ProperInterval() {
    }

    public ProperInterval(T start, T end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setStart(T start) {
        this.start = start;
    }

    public void setEnd(T end) {
        this.end = end;
    }

    public void setStartInclusive(boolean inclusive) {
        this.startInclusive = inclusive;
    }

    public void setEndInclusive(boolean inclusive) {
        this.endInclusive = inclusive;
    }

    @Override
    public T getStart() {
        return this.start;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public boolean startInclusive() {
        return this.startInclusive;
    }

    @Override
    public boolean endInclusive() {
        return this.endInclusive;
    }

    @Override
    public boolean isPoint() {
        return this.start != null && this.end != null && this.start.equals(this.end) && this.startInclusive && this.endInclusive;
    }

    @Override
    public boolean isEmpty() {
        if (this.start == null || this.end == null) {
            return false;
        }
        int cmp = this.start.compareTo(this.end);
        return cmp > 0 || cmp == 0 && (!this.startInclusive || !this.endInclusive);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.start).append(this.end).append(this.startInclusive).append(this.endInclusive).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        ProperInterval oth = (ProperInterval)other;
        if (this.start == null ^ oth.start == null || this.end == null ^ oth.end == null) {
            return false;
        }
        return this.start.equals(oth.start) && this.end.equals(oth.end) && this.endInclusive == oth.endInclusive && this.startInclusive == oth.startInclusive;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.startInclusive) {
            b.append("[");
        } else {
            b.append("(");
        }
        b.append(this.start).append(",").append(this.end);
        if (this.endInclusive) {
            b.append("]");
        } else {
            b.append(")");
        }
        return b.toString();
    }
}

