/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.system;

import java.io.Closeable;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static boolean deleteFromDirectory(File path) {
        return IOUtils.deleteDirectory(path, false);
    }

    public static boolean deleteDirectory(File path, boolean includeDir) {
        boolean success = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                success = files[i].isDirectory() ? IOUtils.deleteDirectory(files[i], true) && success : files[i].delete() && success;
            }
        }
        if (includeDir) {
            success = path.delete() && success;
        }
        return success;
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger.warn("Failed closing " + c, (Throwable)e);
        }
    }
}

