/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.maven;

import java.io.File;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;

@Mojo(name="build-info", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class BuildInfoMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/build-info.properties")
    private File outputFile;
    @Parameter
    private String time;
    @Parameter
    private Map<String, String> additionalProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            BuildPropertiesWriter.ProjectDetails details = new BuildPropertiesWriter.ProjectDetails(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getName(), this.getBuildTime(), this.additionalProperties);
            new BuildPropertiesWriter(this.outputFile).writeBuildProperties(details);
            this.buildContext.refresh(this.outputFile);
        }
        catch (BuildPropertiesWriter.NullAdditionalPropertyValueException ex) {
            throw new MojoFailureException("Failed to generate build-info.properties. " + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private Instant getBuildTime() {
        if (this.time == null || this.time.isEmpty()) {
            Date startTime = this.session.getRequest().getStartTime();
            return startTime != null ? startTime.toInstant() : Instant.now();
        }
        if ("off".equalsIgnoreCase(this.time)) {
            return null;
        }
        return Instant.parse(this.time);
    }
}

