/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.audit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class AuditLog {
    private static final Logger log = Logger.getLogger(AuditLog.class.getName());
    private String name = "audit.log";
    private Boolean enable = Boolean.TRUE;
    private String path;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private File targetDir;

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnable(Boolean enable) {
        void var1_1;
        this.enable = var1_1;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    public void setPath(String path) {
        void var1_1;
        File file = new File(path);
        if (!file.exists()) {
            void var2_2;
            var2_2.mkdirs();
        }
        this.path = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTargetDir(File basedir) {
        if (this.path == null || this.path.length() == 0) {
            void var1_1;
            this.targetDir = new File((File)var1_1, this.name);
            return;
        }
        this.targetDir = new File(this.path + File.separator + this.name);
    }

    public void start() {
        this.recordOperator("start");
    }

    public void stop() {
        this.recordOperator("stop");
    }

    /*
     * WARNING - void declaration
     */
    public void recordOperator(String op) {
        void var1_1;
        void var3_3;
        void var2_2;
        Date now = new Date();
        String nowTime = this.sdf.format(now);
        String userName = System.getProperty("user.name");
        String message = (String)var2_2 + " " + (String)var3_3 + " " + op;
        this.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void write(String message) {
        if (message != null && this.enable.booleanValue()) {
            if (!message.endsWith(System.getProperty("line.separator"))) {
                message = message + System.getProperty("line.separator");
            }
            try {
                Throwable throwable;
                BufferedOutputStream stream2 = new BufferedOutputStream(new FileOutputStream(this.targetDir, true));
                Throwable throwable2 = null;
                try {
                    stream2.write(((String)((Object)throwable)).getBytes());
                    stream2.flush();
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throwable2 = throwable3;
                        throw throwable;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 != null) {
                            try {
                                stream2.close();
                            }
                            catch (Throwable stream2) {
                                throwable2.addSuppressed(stream2);
                            }
                        } else {
                            stream2.close();
                        }
                        throw throwable4;
                    }
                }
                stream2.close();
            }
            catch (IOException e) {
                void var2_5;
                log.warning("write audit log to path:[" + this.targetDir.getAbsolutePath() + "] failed by " + var2_5.getMessage());
            }
        }
    }
}

