/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.properties;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PropertyMapper {
    private static final Predicate<?> ALWAYS = t -> true;
    private static final PropertyMapper INSTANCE = new PropertyMapper(null, null);
    private final PropertyMapper parent = null;
    private final SourceOperator sourceOperator = null;

    private PropertyMapper(PropertyMapper parent, SourceOperator sourceOperator) {
    }

    /*
     * WARNING - void declaration
     */
    private <T> Source<T> from(Supplier<T> supplier) {
        void var1_1;
        Source<Supplier<Supplier<T>>> source;
        Assert.notNull(supplier, (String)"Supplier must not be null");
        Supplier<T> supplier2 = supplier;
        supplier = this;
        Source<Supplier<Supplier<T>>> source2 = source = ((PropertyMapper)supplier).parent != null ? ((PropertyMapper)supplier).parent.from((T)supplier2) : new Source<Supplier<Supplier<T>>>(new CachingSupplier<T>(supplier2), ALWAYS, 0);
        if (this.sourceOperator != null) {
            source = this.sourceOperator.apply$3dad56e3();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Source<T> from(T value) {
        void var1_1;
        return this.from((T)((Supplier<Object>)() -> var1_1));
    }

    public static PropertyMapper get() {
        return INSTANCE;
    }

    static final class NullPointerExceptionSafeSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;

        /*
         * WARNING - void declaration
         */
        NullPointerExceptionSafeSupplier(Supplier<T> supplier) {
            void var1_1;
            this.supplier = var1_1;
        }

        @Override
        public final T get() {
            try {
                return this.supplier.get();
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
    }

    public static final class Source<T> {
        private final Supplier<T> supplier;
        private final Predicate<T> predicate;

        /*
         * WARNING - void declaration
         */
        private Source(Supplier<T> supplier, Predicate<T> predicate) {
            void var2_2;
            void var1_1;
            Assert.notNull(predicate, (String)"Predicate must not be null");
            this.supplier = var1_1;
            this.predicate = var2_2;
        }

        public final Source<T> whenNonNull() {
            return new Source<Object>(new NullPointerExceptionSafeSupplier<T>(this.supplier), Objects::nonNull);
        }

        public final Source<T> whenHasText() {
            return this.when(value -> StringUtils.hasText((String)Objects.toString(value, null)));
        }

        /*
         * WARNING - void declaration
         */
        public final Source<T> whenNot(Predicate<T> predicate) {
            void var1_1;
            Assert.notNull(predicate, (String)"Predicate must not be null");
            return this.when(var1_1.negate());
        }

        /*
         * WARNING - void declaration
         */
        private Source<T> when(Predicate<T> predicate) {
            void var1_1;
            Assert.notNull(predicate, (String)"Predicate must not be null");
            return new Source<T>(this.supplier, this.predicate != null ? this.predicate.and(predicate) : var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void to(Consumer<T> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null");
            T value = this.supplier.get();
            if (this.predicate.test(value)) {
                void var2_2;
                void var1_1;
                var1_1.accept(var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Source(Supplier x0, Predicate x1, byte by) {
            this((Supplier<T>)var1_1, (Predicate<T>)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    @FunctionalInterface
    public static interface SourceOperator {
        public <T> Source<T> apply$3dad56e3();
    }

    static final class CachingSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private boolean hasResult;
        private T result;

        /*
         * WARNING - void declaration
         */
        CachingSupplier(Supplier<T> supplier) {
            void var1_1;
            this.supplier = var1_1;
        }

        @Override
        public final T get() {
            if (!this.hasResult) {
                this.result = this.supplier.get();
                this.hasResult = true;
            }
            return this.result;
        }
    }
}

