/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.config;

import com.tongweb.springboot.v1.x.config.LanguageConfiguration;
import com.tongweb.springboot.v1.x.config.ManageWebProperties;
import com.tongweb.springboot.v1.x.config.TongWebServerProperties;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedServletContainerFactory;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizerBeanPostProcessor;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.web.servlet.ErrorPageRegistrarBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ObjectUtils;

@ConditionalOnWebApplication
@Import(value={BeanPostProcessorsRegistrar.class, LanguageConfiguration.class})
public class LiteTongWebConfig
implements InitializingBean {
    @Autowired
    private Locale locale;

    @Bean
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public TongWebEmbedServletContainerFactory tongwebEmbeddedServletContainerFactory() {
        return new TongWebEmbedServletContainerFactory();
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public TongWebServerProperties tongWebServerProperties() {
        return new TongWebServerProperties();
    }

    @Bean
    public ManageWebProperties manageWebProperties() {
        return new ManageWebProperties();
    }

    public void afterPropertiesSet() {
        Locale.setDefault(this.locale);
    }

    public static class BeanPostProcessorsRegistrar
    implements BeanFactoryAware,
    ImportBeanDefinitionRegistrar {
        private ConfigurableListableBeanFactory beanFactory;

        /*
         * WARNING - void declaration
         */
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                void var1_1;
                this.beanFactory = (ConfigurableListableBeanFactory)var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            if (ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForType(EmbeddedServletContainerCustomizerBeanPostProcessor.class, true, false))) {
                registry.registerBeanDefinition("embeddedServletContainerCustomizerBeanPostProcessor", (BeanDefinition)new RootBeanDefinition(EmbeddedServletContainerCustomizerBeanPostProcessor.class));
            }
            if (ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForType(ErrorPageRegistrarBeanPostProcessor.class, true, false))) {
                void var2_2;
                var2_2.registerBeanDefinition("errorPageRegistrarBeanPostProcessor", (BeanDefinition)new RootBeanDefinition(ErrorPageRegistrarBeanPostProcessor.class));
            }
        }
    }
}

