/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.config;

import com.tongweb.container.Valve;
import com.tongweb.container.valves.StuckThreadDetectionValve;
import com.tongweb.springboot.v1.x.config.Http2;
import com.tongweb.springboot.v1.x.config.Ssl;
import com.tongweb.springboot.v1.x.config.TongwebConfig;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedServletContainerFactory;
import com.tongweb.springboot.v1.x.embed.TongWebJspConf;
import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.InitParameterConfiguringServletContextInitializer;
import org.springframework.boot.context.embedded.JspServlet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class TongWebServerProperties
implements EmbeddedServletContainerCustomizer,
EnvironmentAware,
Ordered {
    private Integer port = 8088;
    private String licenseAddress;
    private InetAddress address;
    private String contextPath;
    private String applicationName = "application";
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    private String servletPath = "/";
    private final Map<String, String> contextParameters = new HashMap<String, String>();
    private Boolean useForwardHeaders;
    private String serverHeader;
    private String maxHttpHeaderSize = "8KB";
    private String maxHttpPostSize = "2MB";
    private Integer connectionTimeout;
    private Boolean enableLookups = Boolean.FALSE;
    private Session session = new Session();
    @NestedConfigurationProperty
    private Http2 http2 = new Http2();
    @NestedConfigurationProperty
    private Ssl ssl;
    @NestedConfigurationProperty
    private final Compression compression = new Compression();
    @NestedConfigurationProperty
    private JspServlet jspServlet = new TongWebJspConf();
    @NestedConfigurationProperty
    private TongwebConfig tongweb = new TongwebConfig();
    private Environment environment;

    public Boolean getEnableLookups() {
        return this.enableLookups;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableLookups(Boolean enableLookups) {
        void var1_1;
        this.enableLookups = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTongweb(TongwebConfig tongweb) {
        void var1_1;
        this.tongweb = var1_1;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnvironment(Environment environment) {
        void var1_1;
        this.environment = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void customize(ConfigurableEmbeddedServletContainer container) {
        TongwebConfig.StuckThreadDetectionConf stuckThreadDetection;
        if (this.getHttp2() != null && container instanceof TongWebEmbedServletContainerFactory) {
            ((TongWebEmbedServletContainerFactory)container).setHttp2(this.getHttp2());
        }
        if (this.getPort() != null) {
            container.setPort(this.getPort().intValue());
        }
        if (this.getAddress() != null) {
            container.setAddress(this.getAddress());
        }
        if (this.getContextPath() != null) {
            container.setContextPath(this.getContextPath());
        }
        if (this.getApplicationName() != null) {
            container.setDisplayName(this.getApplicationName());
        }
        if (this.getSession().getTimeout() != null) {
            container.setSessionTimeout(this.getSession().getTimeout().intValue());
        }
        container.setPersistSession(this.getSession().isPersistent());
        container.setSessionStoreDir(this.getSession().getStoreDir());
        if (this.getSsl() != null) {
            container.setSsl((org.springframework.boot.context.embedded.Ssl)this.getSsl());
        }
        if (this.getJspServlet() != null) {
            container.setJspServlet(this.getJspServlet());
        }
        if (this.getCompression() != null) {
            container.setCompression(this.getCompression());
        }
        container.setServerHeader(this.getServerHeader());
        if (container instanceof TongWebEmbedServletContainerFactory) {
            this.getTongweb().initTongWeb(this, (TongWebEmbedServletContainerFactory)container);
        }
        container.addInitializers(new ServletContextInitializer[]{new SessionConfiguringInitializer(this.session)});
        container.addInitializers(new ServletContextInitializer[]{new InitParameterConfiguringServletContextInitializer(this.getContextParameters())});
        if (this.getTongweb() != null && this.getTongweb().getStuckThreadDetection() != null && container instanceof TongWebEmbedServletContainerFactory && (stuckThreadDetection = this.getTongweb().getStuckThreadDetection()).getThreshold() != 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            StuckThreadDetectionValve value = new StuckThreadDetectionValve();
            value.setThreshold(stuckThreadDetection.getThreshold());
            value.setInterruptThreadThreshold(var2_2.getInterruptThreadThreshold());
            ((TongWebEmbedServletContainerFactory)var1_1).addEngineValves(new Valve[]{var3_3});
        }
    }

    public String getServletMapping() {
        if (this.servletPath.equals("") || this.servletPath.equals("/")) {
            return "/";
        }
        if (this.servletPath.contains("*")) {
            return this.servletPath;
        }
        if (this.servletPath.endsWith("/")) {
            return this.servletPath + "*";
        }
        return this.servletPath + "/*";
    }

    /*
     * WARNING - void declaration
     */
    public String getPath(String path) {
        void var1_1;
        void var2_2;
        String prefix = this.getServletPrefix();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return (String)var2_2 + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getServletPrefix() {
        void var1_1;
        String result = this.servletPath;
        if (result.contains("*")) {
            result = result.substring(0, result.indexOf("*"));
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getPathsArray(Collection<String> paths) {
        void var2_2;
        Iterator iterator;
        String[] result = new String[paths.size()];
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            result[i++] = this.getPath(path);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getPathsArray(String[] paths) {
        void var2_2;
        void var1_1;
        String[] result = new String[paths.length];
        int i = 0;
        for (void path : var1_1) {
            result[i++] = this.getPath((String)path);
        }
        return var2_2;
    }

    public void setLoader(String value) {
    }

    public Integer getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(Integer port) {
        void var1_1;
        this.port = var1_1;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - void declaration
     */
    public void setAddress(InetAddress address) {
        void var1_1;
        this.address = var1_1;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextPath(String contextPath) {
        void var1_1;
        this.contextPath = this.cleanContextPath((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String cleanContextPath(String contextPath) {
        void var1_1;
        if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return var1_1;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    /*
     * WARNING - void declaration
     */
    public void setApplicationName(String applicationName) {
        void var1_1;
        this.applicationName = var1_1;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setServletPath(String servletPath) {
        void var1_1;
        this.servletPath = var1_1;
    }

    public Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public Boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        void var1_1;
        this.useForwardHeaders = var1_1;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setServerHeader(String serverHeader) {
        void var1_1;
        this.serverHeader = var1_1;
    }

    public String getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxHttpHeaderSize(String maxHttpHeaderSize) {
        void var1_1;
        this.maxHttpHeaderSize = var1_1;
    }

    public String getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxHttpPostSize(String maxHttpPostSize) {
        void var1_1;
        this.maxHttpPostSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean getOrDeduceUseForwardHeaders() {
        void var1_1;
        if (this.useForwardHeaders != null) {
            return this.useForwardHeaders;
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
        return platform != null && var1_1.isUsingForwardHeaders();
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionTimeout(Integer connectionTimeout) {
        void var1_1;
        this.connectionTimeout = var1_1;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - void declaration
     */
    public void setSession(Session session) {
        void var1_1;
        this.session = var1_1;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    /*
     * WARNING - void declaration
     */
    public void setSsl(Ssl ssl) {
        void var1_1;
        this.ssl = var1_1;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public JspServlet getJspServlet() {
        return this.jspServlet;
    }

    /*
     * WARNING - void declaration
     */
    public void setJspServlet(JspServlet jspServlet) {
        void var1_1;
        this.jspServlet = var1_1;
    }

    public TongwebConfig getTongweb() {
        return this.tongweb;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttp2(Http2 http2) {
        void var1_1;
        this.http2 = var1_1;
    }

    public String getLicenseAddress() {
        return this.licenseAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void setLicenseAddress(String licenseAddress) {
        void var1_1;
        this.licenseAddress = var1_1;
    }

    private static class SessionConfiguringInitializer
    implements ServletContextInitializer {
        private final Session session;

        /*
         * WARNING - void declaration
         */
        SessionConfiguringInitializer(Session session) {
            void var1_1;
            this.session = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onStartup(ServletContext servletContext) throws ServletException {
            void var1_1;
            if (this.session.getTrackingModes() != null) {
                servletContext.setSessionTrackingModes(this.session.getTrackingModes());
            }
            this.configureSessionCookie(var1_1.getSessionCookieConfig());
        }

        /*
         * WARNING - void declaration
         */
        private void configureSessionCookie(SessionCookieConfig config) {
            Session.Cookie cookie = this.session.getCookie();
            if (cookie.getName() != null) {
                config.setName(cookie.getName());
            }
            if (cookie.getDomain() != null) {
                config.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                config.setPath(cookie.getPath());
            }
            if (cookie.getComment() != null) {
                config.setComment(cookie.getComment());
            }
            if (cookie.getHttpOnly() != null) {
                config.setHttpOnly(cookie.getHttpOnly().booleanValue());
            }
            if (cookie.getSecure() != null) {
                config.setSecure(cookie.getSecure().booleanValue());
            }
            if (cookie.getMaxAge() != null) {
                void var2_2;
                void var1_1;
                var1_1.setMaxAge(var2_2.getMaxAge().intValue());
            }
        }
    }

    public static class Session {
        private Integer timeout;
        private Set<SessionTrackingMode> trackingModes;
        private boolean persistent;
        private File storeDir;
        private final Cookie cookie = new Cookie();

        public Cookie getCookie() {
            return this.cookie;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public void setTimeout(Integer sessionTimeout) {
            void var1_1;
            this.timeout = var1_1;
        }

        public Set<SessionTrackingMode> getTrackingModes() {
            return this.trackingModes;
        }

        /*
         * WARNING - void declaration
         */
        public void setTrackingModes(Set<SessionTrackingMode> trackingModes) {
            void var1_1;
            this.trackingModes = var1_1;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        /*
         * WARNING - void declaration
         */
        public void setPersistent(boolean persistent) {
            void var1_1;
            this.persistent = var1_1;
        }

        public File getStoreDir() {
            return this.storeDir;
        }

        /*
         * WARNING - void declaration
         */
        public void setStoreDir(File storeDir) {
            void var1_1;
            this.storeDir = var1_1;
        }

        public static class Cookie {
            private String name;
            private String domain;
            private String path;
            private String comment;
            private Boolean httpOnly;
            private Boolean secure;
            private Integer maxAge;

            public String getName() {
                return this.name;
            }

            /*
             * WARNING - void declaration
             */
            public void setName(String name) {
                void var1_1;
                this.name = var1_1;
            }

            public String getDomain() {
                return this.domain;
            }

            /*
             * WARNING - void declaration
             */
            public void setDomain(String domain) {
                void var1_1;
                this.domain = var1_1;
            }

            public String getPath() {
                return this.path;
            }

            /*
             * WARNING - void declaration
             */
            public void setPath(String path) {
                void var1_1;
                this.path = var1_1;
            }

            public String getComment() {
                return this.comment;
            }

            /*
             * WARNING - void declaration
             */
            public void setComment(String comment) {
                void var1_1;
                this.comment = var1_1;
            }

            public Boolean getHttpOnly() {
                return this.httpOnly;
            }

            /*
             * WARNING - void declaration
             */
            public void setHttpOnly(Boolean httpOnly) {
                void var1_1;
                this.httpOnly = var1_1;
            }

            public Boolean getSecure() {
                return this.secure;
            }

            /*
             * WARNING - void declaration
             */
            public void setSecure(Boolean secure) {
                void var1_1;
                this.secure = var1_1;
            }

            public Integer getMaxAge() {
                return this.maxAge;
            }

            /*
             * WARNING - void declaration
             */
            public void setMaxAge(Integer maxAge) {
                void var1_1;
                this.maxAge = var1_1;
            }
        }
    }
}

