/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.config;

import com.tongweb.commons.license.DynamicLoadingListener;
import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http11.Http11Nio2Protocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Context;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.Valve;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.audit.AuditLog;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.StandardHost;
import com.tongweb.container.valves.AbstractAccessLogValve;
import com.tongweb.container.valves.AccessLogValve;
import com.tongweb.container.valves.ExtendedAccessLogValve;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.container.valves.RemoteIpValve;
import com.tongweb.container.valves.SemaphoreValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.properties.PropertyMapper;
import com.tongweb.springboot.v1.x.config.CorsFilter;
import com.tongweb.springboot.v1.x.config.Filter;
import com.tongweb.springboot.v1.x.config.IoMode;
import com.tongweb.springboot.v1.x.config.RemoteFilter;
import com.tongweb.springboot.v1.x.config.SocketConfigBean;
import com.tongweb.springboot.v1.x.config.Ssl;
import com.tongweb.springboot.v1.x.config.TongWebServerProperties;
import com.tongweb.springboot.v1.x.embed.TongWebConnectorInitializer;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedServletContainerFactory;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedStandardRoot;
import com.tongweb.springboot.v1.x.spring.DataSize;
import com.tongweb.web.util.http.CookieProcessor;
import com.tongweb.web.util.http.LegacyCookieProcessor;
import com.tongweb.web.util.net.DOSFilter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TongwebConfig {
    private static final Log logger = LogFactory.getLog(TongwebConfig.class);
    private Boolean jarJspEnabled = Boolean.TRUE;
    private List<String> notAllowHttpMethods = new ArrayList<String>();
    private IoMode ioMode = IoMode.NIO;
    private License license = new License();
    private String resourceCacheList;
    @NestedConfigurationProperty
    private final Accesslog accesslog = new Accesslog();
    @NestedConfigurationProperty
    private final SocketConfigBean socket = new SocketConfigBean();
    @NestedConfigurationProperty
    private final SemaphoreConf semaphore = new SemaphoreConf();
    @NestedConfigurationProperty
    private final StuckThreadDetectionConf stuckThreadDetection = new StuckThreadDetectionConf();
    @NestedConfigurationProperty
    @Deprecated
    private final RemoteFilterConfigBean remoteFilter = new RemoteFilterConfigBean();
    @NestedConfigurationProperty
    private final AuditLog auditLog = new AuditLog();
    private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}";
    @NestedConfigurationProperty
    private ErrorReportValveConfig errorReportValve = new ErrorReportValveConfig();
    @NestedConfigurationProperty
    private JsonErrorReportValveConfig jsonErrorReportValve = new JsonErrorReportValveConfig();
    @NestedConfigurationProperty
    private CustomizedErrorReportValveConfig customizedErrorReportValve = new CustomizedErrorReportValveConfig();
    @NestedConfigurationProperty
    private ActuatorMonitorConfig actuatorMonitor = new ActuatorMonitorConfig();
    @NestedConfigurationProperty
    private Filter filter = new Filter();
    private Map<String, String> webApp = new HashMap<String, String>();
    private String war;
    private Boolean allowTrace = Boolean.FALSE;
    private Long asyncTimeout = 30000L;
    private Boolean discardFacades = Boolean.TRUE;
    private String encodedSolidusHandling;
    private Integer maxCookieCount;
    private String parseBodyMethods;
    private Long selectorTimeout = null;
    private Boolean useSendFile = Boolean.TRUE;
    private Integer connectionUploadTimeout;
    private Boolean disableUploadTimeout = Boolean.TRUE;
    private Integer maxExtensionSize = 8192;
    private Integer maxHeaderCount = 100;
    private String protocolHeader;
    private String protocolHeaderHttpsValue = "https";
    private String portHeader = "X-Forwarded-Port";
    private String remoteIpHeader;
    private String hostHeader = "X-Forwarded-Host";
    private File basedir;
    private int backgroundProcessorDelay = 10;
    private int maxThreads = 200;
    private int minSpareThreads = 10;
    private String maxHttpPostSize = "2MB";
    private String maxHttpHeaderSize = "8KB";
    private String maxSavePostSize = "4KB";
    private String maxSwallowSize = "2MB";
    private Boolean redirectContextRoot = Boolean.TRUE;
    private Boolean useRelativeRedirects;
    private Charset uriEncoding = StandardCharsets.UTF_8;
    private Integer keepAliveTimeout;
    private String language;
    private String country;
    private Boolean useLegacyCookieProcessor = Boolean.FALSE;
    private final SecurityListenerProperties securityListener = new SecurityListenerProperties();
    private String docBasePath = "";
    private int maxKeepAliveRequests = 100;
    private int maxTrailerSize = 8192;
    private Boolean rejectIllegalHeader = Boolean.TRUE;
    private String restrictedUserAgents;
    private Boolean tcpNoDelay = Boolean.TRUE;
    private Boolean throwOnFailure = Boolean.FALSE;
    private Boolean useKeepAliveResponseHeader = Boolean.TRUE;
    private int messageTimeout = 0;
    private int maxAttackTimes = 3;
    private int blacklistExpiredHours = 12;
    private boolean interruptCurrentConnect = true;
    private int maxConnections = 10000;
    private Boolean enableLookups = Boolean.FALSE;
    protected int maxParameterCount;
    private int acceptCount = 100;
    private int processorCache = 200;
    private List<String> additionalTldSkipPatterns = new ArrayList<String>();
    private List<Character> relaxedPathChars = new ArrayList<Character>();
    private List<Character> relaxedQueryChars = new ArrayList<Character>();
    private int connectionTimeout = 60000;
    private int connectionLinger = -1;
    private final Resource resource = new Resource();
    private final Mbeanregistry mbeanregistry = new Mbeanregistry();
    private String optimize;

    public String getDocBasePath() {
        return this.docBasePath;
    }

    /*
     * WARNING - void declaration
     */
    public void setDocBasePath(String docBasePath) {
        void var1_1;
        this.docBasePath = var1_1;
    }

    public SecurityListenerProperties getSecurityListener() {
        return this.securityListener;
    }

    public Boolean getUseLegacyCookieProcessor() {
        return this.useLegacyCookieProcessor;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseLegacyCookieProcessor(Boolean useLegacyCookieProcessor) {
        void var1_1;
        this.useLegacyCookieProcessor = var1_1;
    }

    public Boolean getAllowTrace() {
        return this.allowTrace;
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowTrace(Boolean allowTrace) {
        void var1_1;
        this.allowTrace = var1_1;
    }

    public Long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setAsyncTimeout(Long asyncTimeout) {
        void var1_1;
        this.asyncTimeout = var1_1;
    }

    public Boolean getDiscardFacades() {
        return this.discardFacades;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscardFacades(Boolean discardFacades) {
        void var1_1;
        this.discardFacades = var1_1;
    }

    public String getEncodedSolidusHandling() {
        return this.encodedSolidusHandling;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncodedSolidusHandling(String encodedSolidusHandling) {
        void var1_1;
        this.encodedSolidusHandling = var1_1;
    }

    public Integer getMaxCookieCount() {
        return this.maxCookieCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCookieCount(Integer maxCookieCount) {
        void var1_1;
        this.maxCookieCount = var1_1;
    }

    public String getParseBodyMethods() {
        return this.parseBodyMethods;
    }

    /*
     * WARNING - void declaration
     */
    public void setParseBodyMethods(String parseBodyMethods) {
        void var1_1;
        this.parseBodyMethods = var1_1;
    }

    public String getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxSavePostSize(String maxSavePostSize) {
        void var1_1;
        this.maxSavePostSize = var1_1;
    }

    public Integer getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionUploadTimeout(Integer connectionUploadTimeout) {
        void var1_1;
        this.connectionUploadTimeout = var1_1;
    }

    public Boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setDisableUploadTimeout(Boolean disableUploadTimeout) {
        void var1_1;
        this.disableUploadTimeout = var1_1;
    }

    public Integer getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxExtensionSize(Integer maxExtensionSize) {
        void var1_1;
        this.maxExtensionSize = var1_1;
    }

    public Integer getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxHeaderCount(Integer maxHeaderCount) {
        void var1_1;
        this.maxHeaderCount = var1_1;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTrailerSize(int maxTrailerSize) {
        void var1_1;
        this.maxTrailerSize = var1_1;
    }

    public Boolean getRejectIllegalHeader() {
        return this.rejectIllegalHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setRejectIllegalHeader(Boolean rejectIllegalHeader) {
        void var1_1;
        this.rejectIllegalHeader = var1_1;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    /*
     * WARNING - void declaration
     */
    public void setRestrictedUserAgents(String restrictedUserAgents) {
        void var1_1;
        this.restrictedUserAgents = var1_1;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setTcpNoDelay(Boolean tcpNoDelay) {
        void var1_1;
        this.tcpNoDelay = var1_1;
    }

    public Boolean getThrowOnFailure() {
        return this.throwOnFailure;
    }

    /*
     * WARNING - void declaration
     */
    public void setThrowOnFailure(Boolean throwOnFailure) {
        void var1_1;
        this.throwOnFailure = var1_1;
    }

    public Boolean getUseKeepAliveResponseHeader() {
        return this.useKeepAliveResponseHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseKeepAliveResponseHeader(Boolean useKeepAliveResponseHeader) {
        void var1_1;
        this.useKeepAliveResponseHeader = var1_1;
    }

    public Long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectorTimeout(Long selectorTimeout) {
        void var1_1;
        this.selectorTimeout = var1_1;
    }

    public Boolean getUseSendFile() {
        return this.useSendFile;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseSendFile(Boolean useSendFile) {
        void var1_1;
        this.useSendFile = var1_1;
    }

    public String getLanguage() {
        return this.language;
    }

    /*
     * WARNING - void declaration
     */
    public void setLanguage(String language) {
        void var1_1;
        this.language = var1_1;
    }

    public String getCountry() {
        return this.country;
    }

    /*
     * WARNING - void declaration
     */
    public void setCountry(String country) {
        void var1_1;
        this.country = var1_1;
    }

    public int getMessageTimeout() {
        return this.messageTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessageTimeout(int messageTimeout) {
        void var1_1;
        this.messageTimeout = var1_1;
    }

    public int getMaxAttackTimes() {
        return this.maxAttackTimes;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxAttackTimes(int maxAttackTimes) {
        void var1_1;
        this.maxAttackTimes = var1_1;
    }

    public int getBlacklistExpiredHours() {
        return this.blacklistExpiredHours;
    }

    /*
     * WARNING - void declaration
     */
    public void setBlacklistExpiredHours(int blacklistExpiredHours) {
        void var1_1;
        this.blacklistExpiredHours = var1_1;
    }

    public boolean isInterruptCurrentConnect() {
        return this.interruptCurrentConnect;
    }

    /*
     * WARNING - void declaration
     */
    public void setInterruptCurrentConnect(boolean interruptCurrentConnect) {
        void var1_1;
        this.interruptCurrentConnect = var1_1;
    }

    public Boolean getEnableLookups() {
        return this.enableLookups;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableLookups(Boolean enableLookups) {
        void var1_1;
        this.enableLookups = var1_1;
    }

    public String getWar() {
        return this.war;
    }

    /*
     * WARNING - void declaration
     */
    public void setWar(String war) {
        void var1_1;
        this.war = var1_1;
    }

    public Boolean getJarJspEnabled() {
        return this.jarJspEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setJarJspEnabled(Boolean jarJspEnabled) {
        void var1_1;
        this.jarJspEnabled = var1_1;
    }

    public List<String> getNotAllowHttpMethods() {
        return this.notAllowHttpMethods;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotAllowHttpMethods(List<String> notAllowHttpMethods) {
        void var1_1;
        this.notAllowHttpMethods = var1_1;
    }

    public IoMode getIoMode() {
        return this.ioMode;
    }

    public String getOptimize() {
        return this.optimize;
    }

    /*
     * WARNING - void declaration
     */
    public void setOptimize(String optimize) {
        void var1_1;
        this.optimize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setIoMode(IoMode ioMode) {
        void var1_1;
        this.ioMode = var1_1;
    }

    public License getLicense() {
        return this.license;
    }

    /*
     * WARNING - void declaration
     */
    public void setLicense(License license) {
        void var1_1;
        this.license = var1_1;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxThreads(int maxThreads) {
        void var1_1;
        this.maxThreads = var1_1;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinSpareThreads(int minSpareThreads) {
        void var1_1;
        this.minSpareThreads = var1_1;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="server.max-http-header-size")
    public String getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setMaxHttpHeaderSize(String maxHttpHeaderSize) {
        void var1_1;
        this.maxHttpHeaderSize = var1_1;
    }

    public String getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxHttpPostSize(String maxHttpPostSize) {
        void var1_1;
        this.maxHttpPostSize = var1_1;
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxParameterCount(int maxParameterCount) {
        void var1_1;
        this.maxParameterCount = var1_1;
    }

    public Accesslog getAccesslog() {
        return this.accesslog;
    }

    public SocketConfigBean getSocket() {
        return this.socket;
    }

    public SemaphoreConf getSemaphore() {
        return this.semaphore;
    }

    public StuckThreadDetectionConf getStuckThreadDetection() {
        return this.stuckThreadDetection;
    }

    public RemoteFilterConfigBean getRemoteFilter() {
        return this.remoteFilter;
    }

    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
        void var1_1;
        this.backgroundProcessorDelay = var1_1;
    }

    public File getBasedir() {
        return this.basedir;
    }

    /*
     * WARNING - void declaration
     */
    public void setBasedir(File basedir) {
        void var1_1;
        this.basedir = var1_1;
    }

    public String getInternalProxies() {
        return this.internalProxies;
    }

    /*
     * WARNING - void declaration
     */
    public void setInternalProxies(String internalProxies) {
        void var1_1;
        this.internalProxies = var1_1;
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocolHeader(String protocolHeader) {
        void var1_1;
        this.protocolHeader = var1_1;
    }

    public String getProtocolHeaderHttpsValue() {
        return this.protocolHeaderHttpsValue;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
        void var1_1;
        this.protocolHeaderHttpsValue = var1_1;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setPortHeader(String portHeader) {
        void var1_1;
        this.portHeader = var1_1;
    }

    public Boolean getRedirectContextRoot() {
        return this.redirectContextRoot;
    }

    /*
     * WARNING - void declaration
     */
    public void setRedirectContextRoot(Boolean redirectContextRoot) {
        void var1_1;
        this.redirectContextRoot = var1_1;
    }

    public Boolean getUseRelativeRedirects() {
        return this.useRelativeRedirects;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseRelativeRedirects(Boolean useRelativeRedirects) {
        void var1_1;
        this.useRelativeRedirects = var1_1;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteIpHeader(String remoteIpHeader) {
        void var1_1;
        this.remoteIpHeader = var1_1;
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setHostHeader(String hostHeader) {
        void var1_1;
        this.hostHeader = var1_1;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void setUriEncoding(Charset uriEncoding) {
        void var1_1;
        this.uriEncoding = var1_1;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxConnections(int maxConnections) {
        void var1_1;
        this.maxConnections = var1_1;
    }

    public String getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxSwallowSize(String maxSwallowSize) {
        void var1_1;
        this.maxSwallowSize = var1_1;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptCount(int acceptCount) {
        void var1_1;
        this.acceptCount = var1_1;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    /*
     * WARNING - void declaration
     */
    public void setProcessorCache(int processorCache) {
        void var1_1;
        this.processorCache = var1_1;
    }

    public List<String> getAdditionalTldSkipPatterns() {
        return this.additionalTldSkipPatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdditionalTldSkipPatterns(List<String> additionalTldSkipPatterns) {
        void var1_1;
        this.additionalTldSkipPatterns = var1_1;
    }

    public List<Character> getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    /*
     * WARNING - void declaration
     */
    public void setRelaxedPathChars(List<Character> relaxedPathChars) {
        void var1_1;
        this.relaxedPathChars = var1_1;
    }

    public List<Character> getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    /*
     * WARNING - void declaration
     */
    public void setRelaxedQueryChars(List<Character> relaxedQueryChars) {
        void var1_1;
        this.relaxedQueryChars = var1_1;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionTimeout(int connectionTimeout) {
        void var1_1;
        this.connectionTimeout = var1_1;
    }

    public int getConnectionLinger() {
        return this.connectionLinger;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionLinger(int connectionLinger) {
        void var1_1;
        this.connectionLinger = var1_1;
    }

    public Mbeanregistry getMbeanregistry() {
        return this.mbeanregistry;
    }

    public Integer getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeepAliveTimeout(Integer keepAliveTimeout) {
        void var1_1;
        this.keepAliveTimeout = var1_1;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        void var1_1;
        this.maxKeepAliveRequests = var1_1;
    }

    public ErrorReportValveConfig getErrorReportValve() {
        return this.errorReportValve;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorReportValve(ErrorReportValveConfig errorReportValve) {
        void var1_1;
        this.errorReportValve = var1_1;
    }

    public JsonErrorReportValveConfig getJsonErrorReportValve() {
        return this.jsonErrorReportValve;
    }

    /*
     * WARNING - void declaration
     */
    public void setJsonErrorReportValve(JsonErrorReportValveConfig jsonErrorReportValve) {
        void var1_1;
        this.jsonErrorReportValve = var1_1;
    }

    public CustomizedErrorReportValveConfig getCustomizedErrorReportValve() {
        return this.customizedErrorReportValve;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomizedErrorReportValve(CustomizedErrorReportValveConfig customizedErrorReportValve) {
        void var1_1;
        this.customizedErrorReportValve = var1_1;
    }

    public ActuatorMonitorConfig getActuatorMonitor() {
        return this.actuatorMonitor;
    }

    /*
     * WARNING - void declaration
     */
    public void setActuatorMonitor(ActuatorMonitorConfig actuatorMonitor) {
        void var1_1;
        this.actuatorMonitor = var1_1;
    }

    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilter(Filter filter) {
        void var1_1;
        this.filter = var1_1;
    }

    public Map<String, String> getWebApp() {
        return this.webApp;
    }

    /*
     * WARNING - void declaration
     */
    public void setWebApp(Map<String, String> webApp) {
        void var1_1;
        this.webApp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void initTongWeb(TongWebServerProperties tongWebServerProperties, TongWebEmbedServletContainerFactory factory) {
        void var3_3;
        int maxParameterCount;
        String maxHttpPostSize;
        String maxSwallowSize;
        String maxSavePostSize;
        String maxHttpHeaderSize;
        PropertyMapper propertyMapper = PropertyMapper.get();
        factory.setNotAllowHttpMethods(this.getNotAllowHttpMethods());
        factory.setProtocol(this.getIoMode().getClassName());
        this.customizeLog(factory);
        this.customizeSlowHTTPParameter();
        this.customizeOptimize();
        if (!ObjectUtils.isEmpty(this.getAdditionalTldSkipPatterns())) {
            factory.getTldSkipPatterns().addAll(this.getAdditionalTldSkipPatterns());
        }
        if (this.getUseRelativeRedirects() != null) {
            this.customizeUseRelativeRedirects(factory, this.getUseRelativeRedirects());
        }
        if (this.getBasedir() != null) {
            factory.setBaseDirectory(this.getBasedir());
        }
        factory.setBackgroundProcessorDelay(this.getBackgroundProcessorDelay());
        this.customizeBackgroundProcessorDelay(factory);
        this.customizeRemoteIpValve(tongWebServerProperties, factory);
        TongwebConfig tongwebConfig = this;
        if (tongwebConfig.isPositive(tongwebConfig.maxThreads)) {
            this.customizeMaxThreads(factory);
        }
        TongwebConfig tongwebConfig2 = this;
        if (tongwebConfig2.isPositive(tongwebConfig2.minSpareThreads)) {
            this.customizeMinThreads(factory);
        }
        if (!StringUtils.isEmpty((Object)(maxHttpHeaderSize = StringUtils.isEmpty((Object)tongWebServerProperties.getMaxHttpHeaderSize()) ? this.getMaxHttpHeaderSize() : tongWebServerProperties.getMaxHttpHeaderSize()))) {
            this.customizeMaxHttpHeaderSize(factory, (int)DataSize.parse(maxHttpHeaderSize).toBytes());
        }
        if (!StringUtils.isEmpty((Object)(maxSavePostSize = tongWebServerProperties.getTongweb().getMaxSavePostSize()))) {
            this.customizeMaxSavePostSize(factory, (int)DataSize.parse(maxSavePostSize).toBytes());
        }
        if (!StringUtils.isEmpty((Object)(maxSwallowSize = this.getMaxSwallowSize()))) {
            this.customizeMaxSwallowSize(factory, (int)DataSize.parse(maxSwallowSize).toBytes());
        }
        if (!StringUtils.isEmpty((Object)(maxHttpPostSize = this.getMaxHttpPostSize()))) {
            this.customizeMaxHttpPostSize(factory, (int)DataSize.parse(maxHttpPostSize).toBytes());
        }
        if (this.isPositive(maxParameterCount = this.getMaxParameterCount())) {
            this.customizeMaxParameterCount(factory, this.getMaxParameterCount());
        }
        if (this.accesslog.enabled) {
            this.customizeAccessLog(factory, this.accesslog);
        }
        if (this.semaphore.enabled) {
            this.customizeSemaphore(factory);
        }
        if (this.auditLog.getEnable().booleanValue()) {
            this.customizeAuditLog(factory, this.auditLog);
        }
        if (this.remoteFilter.isEnabled()) {
            this.customizeRemoteFilter(factory, this.remoteFilter);
        }
        if (this.filter.getRemote().isEnabled()) {
            this.customizeRemoteFilter(factory, this.filter.getRemote());
        }
        if (!StringUtils.isEmpty((Object)this.getDocBasePath())) {
            factory.setDocumentRoot(new File(this.getDocBasePath()));
            factory.addContextCustomizers(context -> context.setDocBase(this.getDocBasePath()));
        }
        propertyMapper.from(this.webApp).whenNonNull().whenNot(Map::isEmpty).to(webApp -> {
            void var2_2;
            void var1_1;
            this.customizeWebApps((TongWebEmbedServletContainerFactory)var1_1, (Map<String, String>)var2_2);
        });
        if (this.getUriEncoding() != null) {
            factory.setUriEncoding(this.getUriEncoding());
        }
        if (tongWebServerProperties.getTongweb() != null) {
            this.customizeConnectionTimeout(factory, tongWebServerProperties.getTongweb().getConnectionTimeout());
        }
        if (tongWebServerProperties.getTongweb() != null) {
            void var1_1;
            this.customizeConnectionLinger(factory, var1_1.getTongweb().getConnectionLinger());
        }
        TongwebConfig tongwebConfig3 = this;
        if (tongwebConfig3.isPositive(tongwebConfig3.maxConnections)) {
            this.customizeMaxConnections(factory, this.getMaxConnections());
        }
        this.customizeMaxHeaderCount(factory, this.getMaxHeaderCount());
        this.customizeEnableLookups(factory, this.getEnableLookups());
        TongwebConfig tongwebConfig4 = this;
        if (tongwebConfig4.isPositive(tongwebConfig4.acceptCount)) {
            this.customizeAcceptCount(factory, this.getAcceptCount());
        }
        TongwebConfig tongwebConfig5 = this;
        if (tongwebConfig5.isPositive(tongwebConfig5.processorCache)) {
            this.customizeProcessorCache(factory, this.getProcessorCache());
        }
        if (this.war != null && this.war.length() != 0) {
            this.customizeWar(factory, this.getWar());
        }
        propertyMapper.from(this.getKeepAliveTimeout()).whenNonNull().to(keepAliveTimeout -> {
            void var2_2;
            void var1_1;
            this.customizeKeepAliveTimeout((TongWebEmbedServletContainerFactory)var1_1, var2_2.intValue());
        });
        var3_3.from(this.getMaxKeepAliveRequests()).whenNonNull().to(maxKeepAliveRequests -> {
            void var2_2;
            void var1_1;
            this.customizeMaxKeepAliveRequests((TongWebEmbedServletContainerFactory)var1_1, var2_2.intValue());
        });
        this.customizeAsyncTimeout(factory, this.getAsyncTimeout());
        this.customizeDiscardFacades(factory, this.getDiscardFacades());
        this.customizeEncodedSolidusHandling(factory, this.getEncodedSolidusHandling());
        this.customizeMaxCookieCount(factory, this.getMaxCookieCount());
        this.customizeMaxTrailerSize(factory, this.getMaxTrailerSize());
        this.customizeRejectIllegalHeader(factory, this.getRejectIllegalHeader());
        this.customizeRestrictedUserAgents(factory, this.getRestrictedUserAgents());
        this.customizeTcpNoDelay(factory, this.getTcpNoDelay());
        this.customizeThrowOnFailure(factory, this.getThrowOnFailure());
        this.customizeUseKeepAliveResponseHeader(factory, this.getUseKeepAliveResponseHeader());
        this.customizeSelectorTimeout(factory, this.getSelectorTimeout());
        this.customizeUseSendFile(factory, this.getUseSendFile());
        this.customizeSocket(factory, this.getSocket());
        if (!this.getDisableUploadTimeout().booleanValue() && this.getConnectionUploadTimeout() != null) {
            this.customizeConnectionUploadTimeout(factory, this.getConnectionUploadTimeout());
        }
        this.customizeDisableUploadTimeout(factory, this.getDisableUploadTimeout());
        this.customizeMaxExtensionSize(factory, this.getMaxExtensionSize());
        TongwebConfig tongwebConfig6 = this;
        this.customizeRelaxedPathChars(factory, tongwebConfig6.joinCharacters(tongwebConfig6.getRelaxedPathChars()));
        TongwebConfig tongwebConfig7 = this;
        this.customizeRelaxedQueryChars(factory, tongwebConfig7.joinCharacters(tongwebConfig7.getRelaxedQueryChars()));
        if (this.redirectContextRoot != null) {
            this.customizeRedirectContextRoot(factory, this.redirectContextRoot);
        }
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(factory);
        if (this.getUseLegacyCookieProcessor().booleanValue()) {
            void var2_2;
            this.customizeCookieProcessor((TongWebEmbedServletContainerFactory)var2_2);
        }
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    /*
     * WARNING - void declaration
     */
    private void customizeAcceptCount(TongWebEmbedServletContainerFactory factory, int acceptCount) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeAcceptCount$4((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeProcessorCache(TongWebEmbedServletContainerFactory factory, int processorCache) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeProcessorCache$5((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeWar(TongWebEmbedServletContainerFactory factory, String war) {
        void var2_2;
        factory.setWar((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void customizeKeepAliveTimeout(TongWebEmbedServletContainerFactory factory, int keepAliveTimeout) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeKeepAliveTimeout$6((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxKeepAliveRequests(TongWebEmbedServletContainerFactory factory, int maxKeepAliveRequests) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxKeepAliveRequests$7((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeAsyncTimeout(TongWebEmbedServletContainerFactory factory, Long asyncTimeout) {
        if (asyncTimeout != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeAsyncTimeout$8((Long)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeDiscardFacades(TongWebEmbedServletContainerFactory factory, Boolean discardFacades) {
        if (discardFacades != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeDiscardFacades$9((Boolean)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeEncodedSolidusHandling(TongWebEmbedServletContainerFactory factory, String encodedSolidusHandling) {
        if (encodedSolidusHandling != null && encodedSolidusHandling.length() != 0) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeEncodedSolidusHandling$10((String)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxCookieCount(TongWebEmbedServletContainerFactory factory, Integer maxCookieCount) {
        if (maxCookieCount != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxCookieCount$11((Integer)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxTrailerSize(TongWebEmbedServletContainerFactory factory, Integer maxTrailerSize) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxTrailerSize$12((Integer)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRejectIllegalHeader(TongWebEmbedServletContainerFactory factory, Boolean rejectIllegalHeader) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeRejectIllegalHeader$13((Boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRestrictedUserAgents(TongWebEmbedServletContainerFactory factory, String restrictedUserAgents) {
        if (restrictedUserAgents != null && restrictedUserAgents.length() != 0) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeRestrictedUserAgents$14((String)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeTcpNoDelay(TongWebEmbedServletContainerFactory factory, Boolean tcpNoDelay) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeTcpNoDelay$15((Boolean)var2_2, arg_0));
    }

    private void customizeCookieProcessor(TongWebEmbedServletContainerFactory factory) {
        factory.addContextCustomizers(context -> context.setCookieProcessor((CookieProcessor)new LegacyCookieProcessor()));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeThrowOnFailure(TongWebEmbedServletContainerFactory factory, Boolean throwOnFailure) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeThrowOnFailure$17((Boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeUseKeepAliveResponseHeader(TongWebEmbedServletContainerFactory factory, Boolean useKeepAliveResponseHeader) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeUseKeepAliveResponseHeader$18((Boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeParseBodyMethods(TongWebEmbedServletContainerFactory factory, String parseBodyMethods) {
        if (parseBodyMethods != null && parseBodyMethods.length() != 0) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeParseBodyMethods$19((String)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeAcceptorThreadPriority(TongWebEmbedServletContainerFactory factory, Integer acceptorThreadPriority) {
        if (acceptorThreadPriority != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeAcceptorThreadPriority$20((Integer)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizePollerThreadPriority(TongWebEmbedServletContainerFactory factory, Integer pollerThreadPriority) {
        if (pollerThreadPriority != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizePollerThreadPriority$21((Integer)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeSelectorTimeout(TongWebEmbedServletContainerFactory factory, Long selectorTimeout) {
        if (selectorTimeout != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeSelectorTimeout$22((Long)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeUseSendFile(TongWebEmbedServletContainerFactory factory, Boolean useSendFile) {
        if (useSendFile != null) {
            void var2_2;
            void var1_1;
            var1_1.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeUseSendFile$23((Boolean)var2_2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeSocket(TongWebEmbedServletContainerFactory factory, SocketConfigBean socket) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeSocket$24((SocketConfigBean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeConnectionUploadTimeout(TongWebEmbedServletContainerFactory factory, Integer connectionUploadTimeout) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeConnectionUploadTimeout$25((Integer)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeDisableUploadTimeout(TongWebEmbedServletContainerFactory factory, Boolean disableUploadTimeout) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeDisableUploadTimeout$26((Boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxExtensionSize(TongWebEmbedServletContainerFactory factory, int maxExtensionSize) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxExtensionSize$27((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeEnableLookups(TongWebEmbedServletContainerFactory factory, boolean enableLookups) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeEnableLookups$28((boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxConnections(TongWebEmbedServletContainerFactory factory, int maxConnections) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxConnections$29((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxHeaderCount(TongWebEmbedServletContainerFactory factory, int maxHeaderCount) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxHeaderCount$30((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeConnectionTimeout(TongWebEmbedServletContainerFactory factory, int connectionTimeout) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeConnectionTimeout$31((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeConnectionLinger(TongWebEmbedServletContainerFactory factory, int connectionLinger) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeConnectionLinger$32((int)var2_2, arg_0));
    }

    private void customizeBackgroundProcessorDelay(TongWebEmbedServletContainerFactory factory) {
        factory.addContextCustomizers(context -> context.setBackgroundProcessorDelay(this.backgroundProcessorDelay));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRelaxedPathChars(TongWebEmbedServletContainerFactory factory, String relaxedChars) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeRelaxedPathChars$34((String)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRelaxedQueryChars(TongWebEmbedServletContainerFactory factory, String relaxedChars) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeRelaxedQueryChars$35((String)var2_2, arg_0));
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRemoteIpValve(TongWebServerProperties properties, TongWebEmbedServletContainerFactory factory) {
        String protocolHeader = this.getProtocolHeader();
        String remoteIpHeader = this.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || properties.getOrDeduceUseForwardHeaders()) {
            void var1_1;
            void var2_2;
            void var3_3;
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader((String)(StringUtils.hasLength((String)protocolHeader) ? var3_3 : "X-Forwarded-Proto"));
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(this.getInternalProxies());
            valve.setHostHeader(this.getHostHeader());
            valve.setPortHeader(this.getPortHeader());
            valve.setProtocolHeaderHttpsValue(this.getProtocolHeaderHttpsValue());
            var2_2.addEngineValves(new Valve[]{var1_1});
        }
    }

    private void customizeMaxThreads(TongWebEmbedServletContainerFactory factory) {
        factory.addConnectorCustomizers(new TongWebConnectorInitializer(this){
            final /* synthetic */ TongwebConfig this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void init(Connector connector) {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    void var1_1;
                    void var2_2;
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)this.this$0.maxThreads);
                    protocol.setMaxThreads((int)var2_2);
                    LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(this, (AbstractProtocol)var1_1){
                        final /* synthetic */ AbstractProtocol val$protocol;
                        final /* synthetic */ 1 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$protocol = abstractProtocol;
                        }

                        public String getListenerKey() {
                            return "MaxThreads";
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void exec() {
                            void var1_1;
                            if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                                this.val$protocol.setMaxThreads(5);
                                return;
                            }
                            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)this.this$1.this$0.maxThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of maxThreads turning. current : " + this.val$protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            this.val$protocol.setMaxThreads((int)var1_1);
                        }
                    });
                }
            }
        });
    }

    private void customizeMinThreads(TongWebEmbedServletContainerFactory factory) {
        factory.addConnectorCustomizers(new TongWebConnectorInitializer(this){
            final /* synthetic */ TongwebConfig this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void init(Connector connector) {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    void var1_1;
                    void var2_2;
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)this.this$0.minSpareThreads);
                    protocol.setMinSpareThreads((int)var2_2);
                    LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(this, (AbstractProtocol)var1_1){
                        final /* synthetic */ AbstractProtocol val$protocol;
                        final /* synthetic */ 2 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$protocol = abstractProtocol;
                        }

                        public String getListenerKey() {
                            return "MinSpareThreads";
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void exec() {
                            void var1_1;
                            if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                                this.val$protocol.setMinSpareThreads(5);
                                return;
                            }
                            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)this.this$1.this$0.minSpareThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of minSpareThreads turning. current : " + this.val$protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            this.val$protocol.setMinSpareThreads((int)var1_1);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxHttpHeaderSize(TongWebEmbedServletContainerFactory factory, int maxHttpHeaderSize) {
        void var2_2;
        factory.addConnectorCustomizers(new TongWebConnectorInitializer(this, (int)var2_2){
            final /* synthetic */ int val$maxHttpHeaderSize;
            final /* synthetic */ TongwebConfig this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$maxHttpHeaderSize = n;
            }

            @Override
            public void init(Connector connector) {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractHttp11Protocol) {
                    AbstractHttp11Protocol abstractHttp11Protocol;
                    abstractHttp11Protocol = abstractHttp11Protocol;
                    abstractHttp11Protocol.setMaxHttpHeaderSize(this.val$maxHttpHeaderSize);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxSavePostSize(TongWebEmbedServletContainerFactory factory, int maxSavePostSize) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxSavePostSize$36((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxSwallowSize(TongWebEmbedServletContainerFactory factory, int maxSwallowSize) {
        void var2_2;
        factory.addConnectorCustomizers(new TongWebConnectorInitializer(this, (int)var2_2){
            final /* synthetic */ int val$maxSwallowSize;
            final /* synthetic */ TongwebConfig this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$maxSwallowSize = n;
            }

            @Override
            public void init(Connector connector) {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractHttp11Protocol) {
                    AbstractHttp11Protocol abstractHttp11Protocol;
                    abstractHttp11Protocol = abstractHttp11Protocol;
                    abstractHttp11Protocol.setMaxSwallowSize(this.val$maxSwallowSize);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxHttpPostSize(TongWebEmbedServletContainerFactory factory, int maxHttpPostSize) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxHttpPostSize$37((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMaxParameterCount(TongWebEmbedServletContainerFactory factory, int maxParameterCount) {
        void var2_2;
        factory.addConnectorCustomizers(arg_0 -> TongwebConfig.lambda$customizeMaxParameterCount$38((int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeSemaphore(TongWebEmbedServletContainerFactory factory) {
        void var2_2;
        void var1_1;
        SemaphoreValve valve = new SemaphoreValve();
        valve.setConcurrency(this.semaphore.getConcurrency());
        valve.setFairness(this.semaphore.isFairness());
        valve.setBlock(this.semaphore.isBlock());
        valve.setInterruptible(this.semaphore.isInterruptible());
        var1_1.setSemaphore((Valve)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void customizeAccessLog(TongWebEmbedServletContainerFactory factory, Accesslog accessLogConfig) {
        void var3_3;
        void var1_1;
        void var2_2;
        ExtendedAccessLogValve valve;
        if (accessLogConfig.isLogExtend()) {
            valve = new ExtendedAccessLogValve();
            if (accessLogConfig.getPattern().contains("%") || accessLogConfig.getPattern().equalsIgnoreCase("common")) {
                logger.warn((Object)"If setting server.tongweb.accesslog.log-extend=true, need change pattern to extended mode pattern.");
                logger.warn((Object)"for example:");
                logger.warn((Object)"\tserver.tongweb.accesslog.pattern=date time time-taken cs-method cs-uri sc-status");
            }
        } else {
            valve = new AccessLogValve();
        }
        AbstractAccessLogValve.setAsciiToNative((boolean)accessLogConfig.isAsciiToNative());
        valve.setConditionIf(accessLogConfig.getConditionIf());
        valve.setConditionUnless(accessLogConfig.getConditionUnless());
        valve.setDirectory(accessLogConfig.getDirectory());
        valve.setEncoding(accessLogConfig.getEncoding());
        valve.setPattern(accessLogConfig.getPattern());
        valve.setPrefix(accessLogConfig.getPrefix());
        valve.setSuffix(accessLogConfig.getSuffix());
        valve.setLocale(accessLogConfig.getLocale());
        valve.setCheckExists(accessLogConfig.isCheckExists());
        valve.setRotatable(accessLogConfig.isRotate());
        valve.setRenameOnRotate(accessLogConfig.isRenameOnRotate());
        valve.setMaxDays(accessLogConfig.getMaxDays());
        valve.setFileDateFormat(accessLogConfig.getFileDateFormat());
        valve.setIpv6Canonical(accessLogConfig.isIpv6Canonical());
        valve.setRequestAttributesEnabled(accessLogConfig.isRequestAttributesEnabled());
        valve.setBuffered(accessLogConfig.isBuffered());
        valve.setMaxLogMessageBufferSize(var2_2.getMaxLogMessageBufferSize());
        var1_1.setAccessLog((Valve)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void customizeAuditLog(TongWebEmbedServletContainerFactory factory, AuditLog log) {
        void var2_2;
        void var1_1;
        log.setTargetDir(this.getBasedir());
        var1_1.addContextLifecycleListeners(arg_0 -> TongwebConfig.lambda$customizeAuditLog$39((AuditLog)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRemoteFilter(TongWebEmbedServletContainerFactory factory, RemoteFilter remoteFilter) {
        void var1_1;
        void var2_2;
        void var3_3;
        PropertyMapper map = PropertyMapper.get();
        com.tongweb.springboot.v1.x.config.RemoteFilterConfigBean rf = new com.tongweb.springboot.v1.x.config.RemoteFilterConfigBean();
        map.from(remoteFilter.getAllowAddr()).whenNonNull().to(rf::setAllowAddr);
        map.from(remoteFilter.getAllowHost()).whenNonNull().to(rf::setAllowHost);
        map.from(remoteFilter.getDenyAddr()).whenNonNull().to(rf::setDenyAddr);
        map.from(remoteFilter.getDenyStatus()).whenNonNull().to(rf::setDenyStatus);
        var3_3.from(var2_2.getDenyHost()).whenNonNull().to(rf::setDenyHost);
        var1_1.setRemoteFilter(rf);
    }

    /*
     * WARNING - void declaration
     */
    private void customizeWebApps(TongWebEmbedServletContainerFactory factory, Map<String, String> webApps) {
        void var2_2;
        factory.setWebApps((Map<String, String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void customizeSlowHTTPParameter() {
        void var1_1;
        int messageTimeOut;
        DOSFilter.completeMessageTimeout = messageTimeOut = this.getMessageTimeout();
        if (var1_1 > 0) {
            DOSFilter.attackCheck = true;
            DOSFilter.maxAttackTimes = this.getMaxAttackTimes();
            DOSFilter.blackListExpired = this.getBlacklistExpiredHours();
            DOSFilter.interruptCurrentConnect = this.isInterruptCurrentConnect();
            return;
        }
        DOSFilter.attackCheck = false;
    }

    /*
     * WARNING - void declaration
     */
    private void customizeStaticResources(TongWebEmbedServletContainerFactory factory) {
        void var2_2;
        void var1_1;
        Resource resource = this.resource;
        var1_1.addContextCustomizers(arg_0 -> TongwebConfig.lambda$customizeStaticResources$40((Resource)var2_2, arg_0));
    }

    private void customizeErrorReportValve(TongWebEmbedServletContainerFactory factory) {
        factory.addContextCustomizers(context -> {
            void var1_1;
            Context context2;
            Context host = (StandardHost)context.getParent();
            host.setErrorReportValveClass("com.tongweb.container.valves.JsonErrorReportValve");
            JsonErrorReportValve valve = new JsonErrorReportValve();
            valve.setShowServerInfo(false);
            context2.getPipeline().addValve((Valve)var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void customizeMbeanRegistry(TongWebEmbedServletContainerFactory factory) {
        void var2_2;
        void var1_1;
        boolean mbeanRegistryEnabled = this.getMbeanregistry().isEnabled();
        var1_1.setDisableMBeanRegistry(var2_2 == false);
    }

    private void customizeLog(TongWebEmbedServletContainerFactory factory) {
    }

    /*
     * WARNING - void declaration
     */
    private void customizeRedirectContextRoot(TongWebEmbedServletContainerFactory factory, boolean redirectContextRoot) {
        void var2_2;
        factory.addContextCustomizers(arg_0 -> TongwebConfig.lambda$customizeRedirectContextRoot$42((boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void customizeUseRelativeRedirects(TongWebEmbedServletContainerFactory factory, boolean useRelativeRedirects) {
        void var2_2;
        factory.addContextCustomizers(arg_0 -> TongwebConfig.lambda$customizeUseRelativeRedirects$43((boolean)var2_2, arg_0));
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getResourceCacheList() {
        return this.resourceCacheList;
    }

    /*
     * WARNING - void declaration
     */
    public void setResourceCacheList(String resourceCacheList) {
        void var1_1;
        this.resourceCacheList = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void customizeOptimize() {
        void var1_1;
        String optimize = StringUtils.hasLength((String)this.getOptimize()) ? this.getOptimize() : "false";
        System.setProperty("optimize", optimize);
        System.setProperty("optimize-static", (String)var1_1);
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    private static /* synthetic */ void lambda$customizeUseRelativeRedirects$43(boolean useRelativeRedirects, Context context) {
        boolean bl;
        context.setUseRelativeRedirects(bl);
    }

    private static /* synthetic */ void lambda$customizeRedirectContextRoot$42(boolean redirectContextRoot, Context context) {
        boolean bl;
        context.setMapperContextRootRedirectEnabled(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$customizeStaticResources$40(Resource resource, Context context) {
        if (resource != null) {
            void var2_2;
            void var1_1;
            Resource resource2;
            Object resourceRoot = context.getResources();
            if (Objects.isNull(resourceRoot)) {
                resourceRoot = new TongWebEmbedStandardRoot(context);
            }
            resourceRoot.setCachingAllowed(resource.isAllowCaching());
            resourceRoot.setCacheObjectMaxSize(resource.getCacheObjectMaxSize().intValue());
            resourceRoot.setCacheMaxSize(resource.getCacheMaxSize().longValue());
            resourceRoot.setCacheTtl(resource2.getCacheTtl());
            var1_1.setResources((WebResourceRoot)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$customizeAuditLog$39(AuditLog log, LifecycleEvent event) {
        void var1_1;
        if (event.getType().equalsIgnoreCase("after_start")) {
            log.start();
        }
        if (var1_1.getType().equalsIgnoreCase("before_destroy")) {
            AuditLog auditLog;
            auditLog.stop();
        }
    }

    private static /* synthetic */ void lambda$customizeMaxParameterCount$38(int maxParameterCount, Connector connector) {
        int n;
        connector.setMaxParameterCount(n);
    }

    private static /* synthetic */ void lambda$customizeMaxHttpPostSize$37(int maxHttpPostSize, Connector connector) {
        int n;
        connector.setMaxPostSize(n);
    }

    private static /* synthetic */ void lambda$customizeMaxSavePostSize$36(int maxSavePostSize, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            int n;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setMaxSavePostSize(n);
        }
    }

    private static /* synthetic */ void lambda$customizeRelaxedQueryChars$35(String relaxedChars, Connector connector) {
        String string;
        connector.setAttribute("relaxedQueryChars", (Object)string);
    }

    private static /* synthetic */ void lambda$customizeRelaxedPathChars$34(String relaxedChars, Connector connector) {
        String string;
        connector.setAttribute("relaxedPathChars", (Object)string);
    }

    private static /* synthetic */ void lambda$customizeConnectionLinger$32(int connectionLinger, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setConnectionLinger(n);
        }
    }

    private static /* synthetic */ void lambda$customizeConnectionTimeout$31(int connectionTimeout, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setConnectionTimeout(n);
        }
    }

    private static /* synthetic */ void lambda$customizeMaxHeaderCount$30(int maxHeaderCount, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setMaxHeaderCount(n);
        }
    }

    private static /* synthetic */ void lambda$customizeMaxConnections$29(int maxConnections, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setMaxConnections(n);
        }
    }

    private static /* synthetic */ void lambda$customizeEnableLookups$28(boolean enableLookups, Connector connector) {
        boolean bl;
        connector.setEnableLookups(bl);
    }

    private static /* synthetic */ void lambda$customizeMaxExtensionSize$27(int maxExtensionSize, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            int n;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setMaxExtensionSize(n);
        }
    }

    private static /* synthetic */ void lambda$customizeDisableUploadTimeout$26(Boolean disableUploadTimeout, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            Boolean bl;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setDisableUploadTimeout(bl.booleanValue());
        }
    }

    private static /* synthetic */ void lambda$customizeConnectionUploadTimeout$25(Integer connectionUploadTimeout, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            Integer n;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setConnectionUploadTimeout(n.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$customizeSocket$24(SocketConfigBean socket, Connector connector) {
        if (socket.getDirectBuffer() != null) {
            connector.setProperty("socket.directBuffer", socket.getDirectBuffer().toString());
        } else {
            connector.setProperty("socket.directBuffer", "true");
        }
        if (socket.getDirectSslBuffer() != null) {
            connector.setProperty("socket.directSslBuffer", socket.getDirectSslBuffer().toString());
        }
        if (socket.getRxBufSize() != null) {
            connector.setProperty("socket.rxBufSize", socket.getRxBufSize().toString());
        }
        if (socket.getTxBufSize() != null) {
            connector.setProperty("socket.txBufSize", socket.getTxBufSize().toString());
        }
        if (socket.getAppReadBufSize() != null) {
            connector.setProperty("socket.appReadBufSize", socket.getAppReadBufSize().toString());
        }
        if (socket.getAppWriteBufSize() != null) {
            connector.setProperty("socket.appWriteBufSize", socket.getAppWriteBufSize().toString());
        }
        if (socket.getBufferPool() != null) {
            connector.setProperty("socket.bufferPool", socket.getBufferPool().toString());
        }
        if (socket.getBufferPoolSize() != null) {
            connector.setProperty("socket.bufferPoolSize", socket.getBufferPoolSize().toString());
        }
        if (socket.getProcessorCache() != null) {
            connector.setProperty("socket.processorCache", socket.getProcessorCache().toString());
        } else {
            connector.setProperty("socket.processorCache", "10000");
        }
        if (socket.getKeyCache() != null) {
            connector.setProperty("socket.keyCache", socket.getKeyCache().toString());
        } else {
            connector.setProperty("socket.keyCache", "10000");
        }
        if (socket.getEventCache() != null) {
            connector.setProperty("socket.eventCache", socket.getEventCache().toString());
        } else {
            connector.setProperty("socket.eventCache", "10000");
        }
        if (socket.getTcpNoDelay() != null) {
            connector.setProperty("socket.tcpNoDelay", socket.getTcpNoDelay().toString());
        }
        if (socket.getSoKeepAlive() != null) {
            connector.setProperty("socket.soKeepAlive", socket.getSoKeepAlive().toString());
        }
        if (socket.getOoBInline() != null) {
            connector.setProperty("socket.ooBInline", socket.getOoBInline().toString());
        }
        if (socket.getSoReuseAddress() != null) {
            connector.setProperty("socket.soReuseAddress", socket.getSoReuseAddress().toString());
        }
        if (socket.getSoLingerOn() != null) {
            connector.setProperty("socket.soLingerOn", socket.getSoLingerOn().toString());
        }
        if (socket.getSoLingerTime() != null) {
            connector.setProperty("socket.soLingerTime", socket.getSoLingerTime().toString());
        }
        if (socket.getSoTimeout() != null) {
            connector.setProperty("socket.soTimeout", socket.getSoTimeout().toString());
        }
        if (socket.getPerformanceConnectionTime() != null) {
            connector.setProperty("socket.performanceConnectionTime", socket.getPerformanceConnectionTime().toString());
        } else {
            connector.setProperty("socket.performanceConnectionTime", "0");
        }
        if (socket.getPerformanceLatency() != null) {
            connector.setProperty("socket.performanceLatency", socket.getPerformanceLatency().toString());
        } else {
            connector.setProperty("socket.performanceLatency", "1");
        }
        if (socket.getPerformanceBandwidth() != null) {
            connector.setProperty("socket.performanceBandwidth", socket.getPerformanceBandwidth().toString());
        } else {
            connector.setProperty("socket.performanceBandwidth", "2");
        }
        if (socket.getUnlockTimeout() != null) {
            SocketConfigBean socketConfigBean;
            void var1_1;
            var1_1.setProperty("socket.unlockTimeout", socketConfigBean.getUnlockTimeout().toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$customizeUseSendFile$23(Boolean useSendFile, Connector connector) {
        Http11NioProtocol http11NioProtocol;
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof Http11NioProtocol) {
            http11NioProtocol = (Http11NioProtocol)handler;
            http11NioProtocol.setUseSendfile(useSendFile.booleanValue());
        }
        if (handler instanceof Http2Protocol) {
            http11NioProtocol = (Http2Protocol)handler;
            http11NioProtocol.setUseSendfile(useSendFile.booleanValue());
        }
        if (handler instanceof Http11Nio2Protocol) {
            Boolean bl;
            void var1_1;
            http11NioProtocol = (Http11Nio2Protocol)var1_1;
            http11NioProtocol.setUseSendfile(bl.booleanValue());
        }
    }

    private static /* synthetic */ void lambda$customizeSelectorTimeout$22(Long selectorTimeout, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof Http11NioProtocol) {
            Long l;
            Http11NioProtocol http11NioProtocol;
            http11NioProtocol = http11NioProtocol;
            http11NioProtocol.setSelectorTimeout(l.longValue());
        }
    }

    private static /* synthetic */ void lambda$customizePollerThreadPriority$21(Integer pollerThreadPriority, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof Http11NioProtocol) {
            Integer n;
            Http11NioProtocol http11NioProtocol;
            http11NioProtocol = http11NioProtocol;
            http11NioProtocol.setPollerThreadPriority(n.intValue());
        }
    }

    private static /* synthetic */ void lambda$customizeAcceptorThreadPriority$20(Integer acceptorThreadPriority, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            Integer n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setAcceptorThreadPriority(n.intValue());
        }
    }

    private static /* synthetic */ void lambda$customizeParseBodyMethods$19(String parseBodyMethods, Connector connector) {
        String string;
        connector.setParseBodyMethods(string);
    }

    private static /* synthetic */ void lambda$customizeUseKeepAliveResponseHeader$18(Boolean useKeepAliveResponseHeader, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            Boolean bl;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setUseKeepAliveResponseHeader(bl.booleanValue());
        }
    }

    private static /* synthetic */ void lambda$customizeThrowOnFailure$17(Boolean throwOnFailure, Connector connector) {
        Boolean bl;
        connector.setThrowOnFailure(bl.booleanValue());
    }

    private static /* synthetic */ void lambda$customizeTcpNoDelay$15(Boolean tcpNoDelay, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            Boolean bl;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setTcpNoDelay(bl.booleanValue());
        }
    }

    private static /* synthetic */ void lambda$customizeRestrictedUserAgents$14(String restrictedUserAgents, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            String string;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setRestrictedUserAgents(string);
        }
    }

    private static /* synthetic */ void lambda$customizeRejectIllegalHeader$13(Boolean rejectIllegalHeader, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            Boolean bl;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setRejectIllegalHeader(bl.booleanValue());
        }
    }

    private static /* synthetic */ void lambda$customizeMaxTrailerSize$12(Integer maxTrailerSize, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            Integer n;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setMaxTrailerSize(n.intValue());
        }
    }

    private static /* synthetic */ void lambda$customizeMaxCookieCount$11(Integer maxCookieCount, Connector connector) {
        Integer n;
        connector.setMaxCookieCount(n.intValue());
    }

    private static /* synthetic */ void lambda$customizeEncodedSolidusHandling$10(String encodedSolidusHandling, Connector connector) {
        String string;
        connector.setEncodedSolidusHandling(string);
    }

    private static /* synthetic */ void lambda$customizeDiscardFacades$9(Boolean discardFacades, Connector connector) {
        Boolean bl;
        connector.setDiscardFacades(bl.booleanValue());
    }

    private static /* synthetic */ void lambda$customizeAsyncTimeout$8(Long asyncTimeout, Connector connector) {
        Long l;
        connector.setAsyncTimeout(l.longValue());
    }

    private static /* synthetic */ void lambda$customizeMaxKeepAliveRequests$7(int maxKeepAliveRequests, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            int n;
            AbstractHttp11Protocol abstractHttp11Protocol;
            abstractHttp11Protocol = abstractHttp11Protocol;
            abstractHttp11Protocol.setMaxKeepAliveRequests(n);
        }
    }

    private static /* synthetic */ void lambda$customizeKeepAliveTimeout$6(int keepAliveTimeout, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setKeepAliveTimeout(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$customizeProcessorCache$5(int processorCache, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            void var1_1;
            ((AbstractProtocol)var1_1).setProcessorCache(n);
        }
    }

    private static /* synthetic */ void lambda$customizeAcceptCount$4(int acceptCount, Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            int n;
            AbstractProtocol abstractProtocol;
            abstractProtocol = abstractProtocol;
            abstractProtocol.setAcceptCount(n);
        }
    }

    public static class SecurityListenerProperties {
        private boolean enabled = false;
        private String checkedOsUsers;
        private String minimumUmask;
        private boolean removeRootUser = false;

        public boolean isRemoveRootUser() {
            return this.removeRootUser;
        }

        /*
         * WARNING - void declaration
         */
        public void setRemoveRootUser(boolean removeRootUser) {
            void var1_1;
            this.removeRootUser = var1_1;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        public String getCheckedOsUsers() {
            return this.checkedOsUsers;
        }

        /*
         * WARNING - void declaration
         */
        public void setCheckedOsUsers(String checkedOsUsers) {
            void var1_1;
            this.checkedOsUsers = var1_1;
        }

        public String getMinimumUmask() {
            return this.minimumUmask;
        }

        /*
         * WARNING - void declaration
         */
        public void setMinimumUmask(String minimumUmask) {
            void var1_1;
            this.minimumUmask = var1_1;
        }
    }

    public static class Mbeanregistry {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }
    }

    public static class Resource {
        private boolean allowCaching = true;
        private long cacheTtl = 5000L;
        private long cacheMaxSize = 10240L;
        private Integer cacheObjectMaxSize = 512;

        public Long getCacheMaxSize() {
            return this.cacheMaxSize;
        }

        /*
         * WARNING - void declaration
         */
        public void setCacheMaxSize(Long cacheMaxSize) {
            void var1_1;
            this.cacheMaxSize = var1_1.longValue();
        }

        public Integer getCacheObjectMaxSize() {
            return this.cacheObjectMaxSize;
        }

        /*
         * WARNING - void declaration
         */
        public void setCacheObjectMaxSize(Integer cacheObjectMaxSize) {
            void var1_1;
            this.cacheObjectMaxSize = var1_1;
        }

        public boolean isAllowCaching() {
            return this.allowCaching;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowCaching(boolean allowCaching) {
            void var1_1;
            this.allowCaching = var1_1;
        }

        public long getCacheTtl() {
            return this.cacheTtl;
        }

        /*
         * WARNING - void declaration
         */
        public void setCacheTtl(long cacheTtl) {
            void var1_1;
            this.cacheTtl = var1_1;
        }
    }

    public static class Accesslog {
        private boolean enabled = false;
        private boolean asciiToNative = false;
        private String conditionIf;
        private String conditionUnless;
        private String pattern = "common";
        private String directory = "logs";
        protected String prefix = "access_";
        private String suffix = ".log";
        private String encoding;
        private String locale;
        private boolean checkExists = false;
        private boolean rotate = true;
        private boolean renameOnRotate = false;
        private int maxDays = -1;
        private String fileDateFormat = "yyyy-MM-dd";
        private boolean ipv6Canonical = false;
        private boolean requestAttributesEnabled = false;
        private boolean buffered = true;
        private int maxLogMessageBufferSize = 256;
        private boolean logExtend = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        public boolean isAsciiToNative() {
            return this.asciiToNative;
        }

        /*
         * WARNING - void declaration
         */
        public void setAsciiToNative(boolean asciiToNative) {
            void var1_1;
            this.asciiToNative = var1_1;
        }

        public String getConditionIf() {
            return this.conditionIf;
        }

        /*
         * WARNING - void declaration
         */
        public void setConditionIf(String conditionIf) {
            void var1_1;
            this.conditionIf = var1_1;
        }

        public String getConditionUnless() {
            return this.conditionUnless;
        }

        /*
         * WARNING - void declaration
         */
        public void setConditionUnless(String conditionUnless) {
            void var1_1;
            this.conditionUnless = var1_1;
        }

        public String getPattern() {
            return this.pattern;
        }

        /*
         * WARNING - void declaration
         */
        public void setPattern(String pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        public String getDirectory() {
            return this.directory;
        }

        /*
         * WARNING - void declaration
         */
        public void setDirectory(String directory) {
            void var1_1;
            this.directory = var1_1;
        }

        public String getPrefix() {
            return this.prefix;
        }

        /*
         * WARNING - void declaration
         */
        public void setPrefix(String prefix) {
            void var1_1;
            this.prefix = var1_1;
        }

        public String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        public void setSuffix(String suffix) {
            void var1_1;
            this.suffix = var1_1;
        }

        public String getEncoding() {
            return this.encoding;
        }

        /*
         * WARNING - void declaration
         */
        public void setEncoding(String encoding) {
            void var1_1;
            this.encoding = var1_1;
        }

        public String getLocale() {
            return this.locale;
        }

        /*
         * WARNING - void declaration
         */
        public void setLocale(String locale) {
            void var1_1;
            this.locale = var1_1;
        }

        public boolean isCheckExists() {
            return this.checkExists;
        }

        /*
         * WARNING - void declaration
         */
        public void setCheckExists(boolean checkExists) {
            void var1_1;
            this.checkExists = var1_1;
        }

        public boolean isRotate() {
            return this.rotate;
        }

        /*
         * WARNING - void declaration
         */
        public void setRotate(boolean rotate) {
            void var1_1;
            this.rotate = var1_1;
        }

        public boolean isRenameOnRotate() {
            return this.renameOnRotate;
        }

        /*
         * WARNING - void declaration
         */
        public void setRenameOnRotate(boolean renameOnRotate) {
            void var1_1;
            this.renameOnRotate = var1_1;
        }

        public int getMaxDays() {
            return this.maxDays;
        }

        /*
         * WARNING - void declaration
         */
        public void setMaxDays(int maxDays) {
            void var1_1;
            this.maxDays = var1_1;
        }

        public String getFileDateFormat() {
            return this.fileDateFormat;
        }

        /*
         * WARNING - void declaration
         */
        public void setFileDateFormat(String fileDateFormat) {
            void var1_1;
            this.fileDateFormat = var1_1;
        }

        public boolean isIpv6Canonical() {
            return this.ipv6Canonical;
        }

        /*
         * WARNING - void declaration
         */
        public void setIpv6Canonical(boolean ipv6Canonical) {
            void var1_1;
            this.ipv6Canonical = var1_1;
        }

        public boolean isRequestAttributesEnabled() {
            return this.requestAttributesEnabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
            void var1_1;
            this.requestAttributesEnabled = var1_1;
        }

        public boolean isBuffered() {
            return this.buffered;
        }

        /*
         * WARNING - void declaration
         */
        public void setBuffered(boolean buffered) {
            void var1_1;
            this.buffered = var1_1;
        }

        public int getMaxLogMessageBufferSize() {
            return this.maxLogMessageBufferSize;
        }

        /*
         * WARNING - void declaration
         */
        public void setMaxLogMessageBufferSize(int maxLogMessageBufferSize) {
            void var1_1;
            this.maxLogMessageBufferSize = var1_1;
        }

        public boolean isLogExtend() {
            return this.logExtend;
        }

        /*
         * WARNING - void declaration
         */
        public void setLogExtend(boolean logExtend) {
            void var1_1;
            this.logExtend = var1_1;
        }
    }

    public static class StuckThreadDetectionConf {
        private int threshold = 0;
        private int interruptThreadThreshold = -1;

        public int getThreshold() {
            return this.threshold;
        }

        /*
         * WARNING - void declaration
         */
        public void setThreshold(int threshold) {
            void var1_1;
            this.threshold = var1_1;
        }

        public int getInterruptThreadThreshold() {
            return this.interruptThreadThreshold;
        }

        /*
         * WARNING - void declaration
         */
        public void setInterruptThreadThreshold(int interruptThreadThreshold) {
            void var1_1;
            this.interruptThreadThreshold = var1_1;
        }
    }

    public static class SemaphoreConf {
        private boolean enabled = false;
        public int concurrency = 10;
        public boolean fairness = false;
        public boolean block = true;
        public boolean interruptible = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        public int getConcurrency() {
            return this.concurrency;
        }

        /*
         * WARNING - void declaration
         */
        public void setConcurrency(int concurrency) {
            void var1_1;
            this.concurrency = var1_1;
        }

        public boolean isFairness() {
            return this.fairness;
        }

        /*
         * WARNING - void declaration
         */
        public void setFairness(boolean fairness) {
            void var1_1;
            this.fairness = var1_1;
        }

        public boolean isBlock() {
            return this.block;
        }

        /*
         * WARNING - void declaration
         */
        public void setBlock(boolean block) {
            void var1_1;
            this.block = var1_1;
        }

        public boolean isInterruptible() {
            return this.interruptible;
        }

        /*
         * WARNING - void declaration
         */
        public void setInterruptible(boolean interruptible) {
            void var1_1;
            this.interruptible = var1_1;
        }
    }

    public static class License {
        private boolean sslEnabled = false;
        private String type = "file";
        private String path;
        private String address = "";
        private String licenseIps = "";
        @NestedConfigurationProperty
        private Ssl ssl;
        private String licensePublicKey;

        public boolean isSslEnabled() {
            return this.sslEnabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setSslEnabled(boolean sslEnabled) {
            void var1_1;
            this.sslEnabled = var1_1;
        }

        public String getLicensePublicKey() {
            return this.licensePublicKey;
        }

        /*
         * WARNING - void declaration
         */
        public void setLicensePublicKey(String licensePublicKey) {
            void var1_1;
            this.licensePublicKey = var1_1;
        }

        public String getLicenseIps() {
            return this.licenseIps;
        }

        /*
         * WARNING - void declaration
         */
        public void setLicenseIps(String licenseIps) {
            void var1_1;
            this.licenseIps = var1_1;
        }

        public String getType() {
            return this.type;
        }

        /*
         * WARNING - void declaration
         */
        public void setType(String type) {
            void var1_1;
            this.type = var1_1;
        }

        public String getPath() {
            return this.path;
        }

        /*
         * WARNING - void declaration
         */
        public void setPath(String path) {
            void var1_1;
            this.path = var1_1;
        }

        public String getAddress() {
            return this.address;
        }

        /*
         * WARNING - void declaration
         */
        public void setAddress(String address) {
            void var1_1;
            this.address = var1_1;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        /*
         * WARNING - void declaration
         */
        public void setSsl(Ssl ssl) {
            void var1_1;
            this.ssl = var1_1;
        }
    }

    @Deprecated
    public static class RemoteFilterConfigBean
    implements RemoteFilter {
        private boolean enabled = false;
        protected String allowAddr;
        protected String denyAddr;
        protected String allowHost;
        protected String denyHost;
        private Integer denyStatus = 403;
        protected String filterHostType;
        protected String filterAddrType;

        public RemoteFilterConfigBean() {
        }

        /*
         * WARNING - void declaration
         */
        public RemoteFilterConfigBean(String allowAddr, String denyAddr, String allowHost, String denyHost, Integer denyStatus, String filterHostType, String filterAddrType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.allowAddr = var1_1;
            this.denyAddr = var2_2;
            this.allowHost = var3_3;
            this.denyHost = denyHost;
            this.denyStatus = denyStatus;
            this.filterHostType = filterHostType;
            this.filterAddrType = filterAddrType;
        }

        @Override
        @DeprecatedConfigurationProperty
        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getAllowAddr() {
            return this.allowAddr;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowAddr(String allowAddr) {
            void var1_1;
            this.allowAddr = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getDenyAddr() {
            return this.denyAddr;
        }

        /*
         * WARNING - void declaration
         */
        public void setDenyAddr(String denyAddr) {
            void var1_1;
            this.denyAddr = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getAllowHost() {
            return this.allowHost;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowHost(String allowHost) {
            void var1_1;
            this.allowHost = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getDenyHost() {
            return this.denyHost;
        }

        /*
         * WARNING - void declaration
         */
        public void setDenyHost(String denyHost) {
            void var1_1;
            this.denyHost = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public Integer getDenyStatus() {
            return this.denyStatus;
        }

        /*
         * WARNING - void declaration
         */
        public void setDenyStatus(Integer denyStatus) {
            void var1_1;
            this.denyStatus = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getFilterHostType() {
            return this.filterHostType;
        }

        /*
         * WARNING - void declaration
         */
        public void setFilterHostType(String filterHostType) {
            void var1_1;
            this.filterHostType = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getFilterAddrType() {
            return this.filterAddrType;
        }

        /*
         * WARNING - void declaration
         */
        public void setFilterAddrType(String filterAddrType) {
            void var1_1;
            this.filterAddrType = var1_1;
        }
    }

    @Deprecated
    public static class CorsFilterConfig
    implements CorsFilter {
        private boolean enabled = false;
        private boolean supportCredentials = false;
        private String allowedOrigins;
        private String allowedMethods = "GET,POST,HEAD,OPTIONS";
        private String allowedHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        private String exposedHeaders;
        private String preflightMaxAge = "1800";
        private String urlPatterns = "/*";

        @Override
        @DeprecatedConfigurationProperty
        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public boolean isSupportCredentials() {
            return this.supportCredentials;
        }

        /*
         * WARNING - void declaration
         */
        public void setSupportCredentials(boolean supportCredentials) {
            void var1_1;
            this.supportCredentials = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getAllowedOrigins() {
            return this.allowedOrigins;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowedOrigins(String allowedOrigins) {
            void var1_1;
            this.allowedOrigins = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getAllowedMethods() {
            return this.allowedMethods;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowedMethods(String allowedMethods) {
            void var1_1;
            this.allowedMethods = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getAllowedHeaders() {
            return this.allowedHeaders;
        }

        /*
         * WARNING - void declaration
         */
        public void setAllowedHeaders(String allowedHeaders) {
            void var1_1;
            this.allowedHeaders = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getExposedHeaders() {
            return this.exposedHeaders;
        }

        /*
         * WARNING - void declaration
         */
        public void setExposedHeaders(String exposedHeaders) {
            void var1_1;
            this.exposedHeaders = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getPreflightMaxAge() {
            return this.preflightMaxAge;
        }

        /*
         * WARNING - void declaration
         */
        public void setPreflightMaxAge(String preflightMaxAge) {
            void var1_1;
            this.preflightMaxAge = var1_1;
        }

        @Override
        @DeprecatedConfigurationProperty
        public String getUrlPatterns() {
            return this.urlPatterns;
        }

        /*
         * WARNING - void declaration
         */
        public void setUrlPatterns(String urlPatterns) {
            void var1_1;
            this.urlPatterns = var1_1;
        }
    }

    public static class ActuatorMonitorConfig {
        private boolean showServerInfo = false;

        public boolean isShowServerInfo() {
            return this.showServerInfo;
        }

        /*
         * WARNING - void declaration
         */
        public void setShowServerInfo(boolean showServerInfo) {
            void var1_1;
            this.showServerInfo = var1_1;
        }
    }

    public static class CustomizedErrorReportValveConfig {
        private String type;

        public String getType() {
            return this.type;
        }

        /*
         * WARNING - void declaration
         */
        public void setType(String type) {
            void var1_1;
            this.type = var1_1;
        }
    }

    public static class JsonErrorReportValveConfig {
        private boolean enabled = false;
        private boolean showReport = false;
        private boolean showServerInfo = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }
    }

    public static class ErrorReportValveConfig {
        private boolean enabled = false;
        private boolean showReport = false;
        private boolean showServerInfo = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - void declaration
         */
        public void setEnabled(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        public boolean isShowReport() {
            return this.showReport;
        }

        /*
         * WARNING - void declaration
         */
        public void setShowReport(boolean showReport) {
            void var1_1;
            this.showReport = var1_1;
        }

        public boolean isShowServerInfo() {
            return this.showServerInfo;
        }

        /*
         * WARNING - void declaration
         */
        public void setShowServerInfo(boolean showServerInfo) {
            void var1_1;
            this.showServerInfo = var1_1;
        }
    }
}

