/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.webresources.Cache;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedCachedResource;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedStandardRoot;
import com.tongweb.web.util.res.StringManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class TongWebEmbedCache
extends Cache {
    private static final Log log = LogFactory.getLog(TongWebEmbedCache.class);
    private static StringManager sm = StringManager.getManager(Cache.class);
    private final TongWebEmbedStandardRoot root;
    private final AtomicLong size = new AtomicLong(0L);
    private long ttl = 5000L;
    private long maxSize = 0xA00000L;
    private int objectMaxSize = (int)this.maxSize / 20;
    private WebResourceRoot.CacheStrategy cacheStrategy;
    private AtomicLong lookupCount = new AtomicLong(0L);
    private AtomicLong hitCount = new AtomicLong(0L);
    private final ConcurrentMap<String, TongWebEmbedCachedResource> resourceCache = new ConcurrentHashMap<String, TongWebEmbedCachedResource>();
    private Map<String, WebResource> webResourceMap = new HashMap<String, WebResource>();

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedCache(TongWebEmbedStandardRoot root) {
        super((StandardRoot)root);
        void var1_1;
        this.root = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected WebResource getResource(String path, boolean useClassLoaderResources) {
        TongWebEmbedCachedResource tongWebEmbedCachedResource;
        Object webResource = this.webResourceMap.get(path);
        if (webResource != null) {
            return webResource;
        }
        webResource = path;
        if (((String)webResource).endsWith(".class") && (((String)webResource).startsWith("/WEB-INF/classes/") || ((String)webResource).startsWith("/WEB-INF/lib/")) || ((String)webResource).startsWith("/WEB-INF/lib/") && ((String)webResource).endsWith(".jar")) {
            return this.root.getTongWebResourceInternal(path, useClassLoaderResources);
        }
        WebResourceRoot.CacheStrategy strategy = this.getCacheStrategy();
        if (strategy != null && strategy.noCache(path)) {
            return this.root.getTongWebResourceInternal(path, useClassLoaderResources);
        }
        this.lookupCount.incrementAndGet();
        TongWebEmbedCachedResource cacheEntry = (TongWebEmbedCachedResource)((Object)this.resourceCache.get(path));
        if (cacheEntry != null && !cacheEntry.validateResource(useClassLoaderResources)) {
            this.removeCacheEntry(path);
            cacheEntry = null;
        }
        if (cacheEntry == null) {
            void var3_4;
            int objectMaxSizeBytes = this.getObjectMaxSizeBytes();
            TongWebEmbedCache tongWebEmbedCache = this;
            TongWebEmbedCachedResource newCacheEntry = new TongWebEmbedCachedResource(tongWebEmbedCache, tongWebEmbedCache.root, path, this.getTtl(), (int)var3_4, useClassLoaderResources);
            tongWebEmbedCachedResource = this.resourceCache.putIfAbsent(path, newCacheEntry);
            if (tongWebEmbedCachedResource == null) {
                long targetSize;
                long l;
                tongWebEmbedCachedResource = newCacheEntry;
                tongWebEmbedCachedResource.validateResource(useClassLoaderResources);
                long delta = tongWebEmbedCachedResource.getSize();
                this.size.addAndGet(delta);
                if (this.size.get() > this.maxSize && (l = this.evict(targetSize = this.maxSize * 95L / 100L, this.resourceCache.values().iterator())) > this.maxSize) {
                    void var1_1;
                    this.removeCacheEntry(path);
                    log.warn((Object)sm.getString("cache.addFail", new Object[]{var1_1, this.root.getContext().getName()}));
                }
            } else {
                void var2_2;
                if (tongWebEmbedCachedResource.usesClassLoaderResources() != useClassLoaderResources) {
                    tongWebEmbedCachedResource = newCacheEntry;
                }
                tongWebEmbedCachedResource.validateResource((boolean)var2_2);
            }
        } else {
            this.hitCount.incrementAndGet();
        }
        return tongWebEmbedCachedResource;
    }

    /*
     * WARNING - void declaration
     */
    protected WebResource[] getResources(String path, boolean useClassLoaderResources) {
        TongWebEmbedCachedResource tongWebEmbedCachedResource;
        this.lookupCount.incrementAndGet();
        TongWebEmbedCachedResource cacheEntry = (TongWebEmbedCachedResource)((Object)this.resourceCache.get(path));
        if (cacheEntry != null && !cacheEntry.validateResources(useClassLoaderResources)) {
            this.removeCacheEntry(path);
            cacheEntry = null;
        }
        if (cacheEntry == null) {
            void var3_4;
            int objectMaxSizeBytes = this.getObjectMaxSizeBytes();
            TongWebEmbedCache tongWebEmbedCache = this;
            TongWebEmbedCachedResource newCacheEntry = new TongWebEmbedCachedResource(tongWebEmbedCache, tongWebEmbedCache.root, path, this.getTtl(), (int)var3_4, useClassLoaderResources);
            tongWebEmbedCachedResource = this.resourceCache.putIfAbsent(path, newCacheEntry);
            if (tongWebEmbedCachedResource == null) {
                long targetSize;
                long l;
                tongWebEmbedCachedResource = newCacheEntry;
                tongWebEmbedCachedResource.validateResources(useClassLoaderResources);
                long delta = tongWebEmbedCachedResource.getSize();
                this.size.addAndGet(delta);
                if (this.size.get() > this.maxSize && (l = this.evict(targetSize = this.maxSize * 95L / 100L, this.resourceCache.values().iterator())) > this.maxSize) {
                    void var1_1;
                    this.removeCacheEntry(path);
                    log.warn((Object)sm.getString("cache.addFail", new Object[]{var1_1}));
                }
            } else {
                void var2_2;
                tongWebEmbedCachedResource.validateResources((boolean)var2_2);
            }
        } else {
            this.hitCount.incrementAndGet();
        }
        return tongWebEmbedCachedResource.getWebResources();
    }

    /*
     * WARNING - void declaration
     */
    protected void backgroundProcess() {
        void var3_2;
        void var1_1;
        TreeSet<TongWebEmbedCachedResource> orderedResources = new TreeSet<TongWebEmbedCachedResource>(new EvictionOrder(0));
        orderedResources.addAll(this.resourceCache.values());
        Iterator<TongWebEmbedCachedResource> iter = orderedResources.iterator();
        long targetSize = this.maxSize * 90L / 100L;
        long newSize = this.evict(targetSize, (Iterator<TongWebEmbedCachedResource>)var1_1);
        if (newSize > var3_2) {
            log.info((Object)sm.getString("cache.backgroundEvictFail", new Object[]{10L, this.root.getContext().getName(), newSize / 1024L}));
        }
    }

    private long evict(long targetSize, Iterator<TongWebEmbedCachedResource> iter) {
        long now = System.currentTimeMillis();
        long newSize = this.size.get();
        while (newSize > targetSize && iter.hasNext()) {
            TongWebEmbedCachedResource resource = iter.next();
            if (resource.getNextCheck() > now) continue;
            this.removeCacheEntry(resource.getWebappPath());
            newSize = this.size.get();
        }
        return newSize;
    }

    /*
     * WARNING - void declaration
     */
    final void removeCacheEntry(String path) {
        TongWebEmbedCachedResource cachedResource = (TongWebEmbedCachedResource)((Object)this.resourceCache.remove(path));
        if (cachedResource != null) {
            void var3_2;
            void var1_1;
            long delta = var1_1.getSize();
            this.size.addAndGet((long)(-var3_2));
        }
    }

    public WebResourceRoot.CacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheStrategy(WebResourceRoot.CacheStrategy cacheStrategy) {
        void var1_1;
        this.cacheStrategy = var1_1;
    }

    public long getTtl() {
        return this.ttl;
    }

    /*
     * WARNING - void declaration
     */
    public void setTtl(long ttl) {
        void var1_1;
        this.ttl = var1_1;
    }

    public long getMaxSize() {
        return this.maxSize / 1024L;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxSize(long maxSize) {
        void var1_1;
        this.maxSize = var1_1 << 10;
    }

    public long getLookupCount() {
        return this.lookupCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    /*
     * WARNING - void declaration
     */
    public void setObjectMaxSize(int objectMaxSize) {
        void var1_1;
        if ((long)objectMaxSize << 10 > Integer.MAX_VALUE) {
            log.warn((Object)sm.getString("cache.objectMaxSizeTooBigBytes", new Object[]{objectMaxSize}));
            this.objectMaxSize = Integer.MAX_VALUE;
        }
        this.objectMaxSize = var1_1 << 10;
    }

    public int getObjectMaxSize() {
        return this.objectMaxSize / 1024;
    }

    public int getObjectMaxSizeBytes() {
        return this.objectMaxSize;
    }

    /*
     * WARNING - void declaration
     */
    final void enforceObjectMaxSizeLimit() {
        long limit = this.maxSize / 20L;
        if (limit > Integer.MAX_VALUE) {
            return;
        }
        if ((long)this.objectMaxSize > limit) {
            void var1_1;
            log.warn((Object)sm.getString("cache.objectMaxSizeTooBig", new Object[]{this.objectMaxSize / 1024, (int)limit / 1024}));
            this.objectMaxSize = (int)var1_1;
        }
    }

    public void clear() {
        this.resourceCache.clear();
        this.size.set(0L);
    }

    public long getSize() {
        return this.size.get() / 1024L;
    }

    static final class EvictionOrder
    implements Comparator<TongWebEmbedCachedResource> {
        private EvictionOrder() {
        }

        /* synthetic */ EvictionOrder(byte by) {
            this();
        }
    }
}

