/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.webresources.Cache;
import com.tongweb.container.webresources.CachedResource;
import com.tongweb.container.webresources.EmptyResource;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedCache;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedStandardRoot;
import com.tongweb.web.util.res.StringManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.security.Permission;
import java.security.cert.Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TongWebEmbedCachedResource
extends CachedResource {
    private static final Log log = LogFactory.getLog(TongWebEmbedCachedResource.class);
    private static final StringManager sm = StringManager.getManager(CachedResource.class);
    private final TongWebEmbedCache cache;
    private final TongWebEmbedStandardRoot root;
    private final String webAppPath;
    private final long ttl;
    private final int objectMaxSizeBytes;
    private final boolean usesClassLoaderResources;
    private volatile WebResource webResource;
    private volatile WebResource[] webResources;
    private volatile long nextCheck;
    private volatile Long cachedLastModified = null;
    private volatile String cachedLastModifiedHttp = null;
    private volatile byte[] cachedContent = null;
    private volatile Boolean cachedIsFile = null;
    private volatile Boolean cachedIsDirectory = null;
    private volatile Boolean cachedExists = null;
    private volatile Boolean cachedIsVirtual = null;
    private volatile Long cachedContentLength = null;

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedCachedResource(TongWebEmbedCache cache, TongWebEmbedStandardRoot root, String path, long ttl, int objectMaxSizeBytes, boolean usesClassLoaderResources) {
        super((Cache)cache, (StandardRoot)root, path, ttl, objectMaxSizeBytes, usesClassLoaderResources);
        void var3_3;
        void var2_2;
        void var1_1;
        this.cache = var1_1;
        this.root = var2_2;
        this.webAppPath = var3_3;
        this.ttl = ttl;
        this.objectMaxSizeBytes = objectMaxSizeBytes;
        this.usesClassLoaderResources = usesClassLoaderResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean validateResource(boolean useClassLoaderResources) {
        void var2_3;
        if (this.usesClassLoaderResources != useClassLoaderResources) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.webResource == null) {
            TongWebEmbedCachedResource tongWebEmbedCachedResource = this;
            synchronized (tongWebEmbedCachedResource) {
                if (this.webResource == null) {
                    this.webResource = this.root.getTongWebResourceInternal(this.webAppPath, useClassLoaderResources);
                    this.getLastModified();
                    this.getContentLength();
                    this.nextCheck = this.ttl + now;
                    this.cachedExists = this.webResource instanceof EmptyResource ? Boolean.FALSE : Boolean.TRUE;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (!this.root.isPackedWarFile()) {
            void var1_1;
            WebResource webResourceInternal = this.root.getTongWebResourceInternal(this.webAppPath, (boolean)var1_1);
            if (!this.webResource.exists() && webResourceInternal.exists()) {
                return false;
            }
            if (this.webResource.getLastModified() != this.getLastModified() || this.webResource.getContentLength() != this.getContentLength()) {
                return false;
            }
            if (this.webResource.getLastModified() != webResourceInternal.getLastModified() || this.webResource.getContentLength() != webResourceInternal.getContentLength()) {
                return false;
            }
        }
        this.nextCheck = this.ttl + var2_3;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean validateResources(boolean useClassLoaderResources) {
        long now = System.currentTimeMillis();
        if (this.webResources == null) {
            TongWebEmbedCachedResource tongWebEmbedCachedResource = this;
            synchronized (tongWebEmbedCachedResource) {
                if (this.webResources == null) {
                    void var1_1;
                    this.webResources = this.root.getResourcesInternal(this.webAppPath, (boolean)var1_1);
                    this.nextCheck = this.ttl + now;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (this.root.isPackedWarFile()) {
            void var2_3;
            this.nextCheck = this.ttl + var2_3;
            return true;
        }
        return false;
    }

    protected long getNextCheck() {
        return this.nextCheck;
    }

    /*
     * WARNING - void declaration
     */
    public long getLastModified() {
        void var1_1;
        Long cachedLastModified = this.cachedLastModified;
        if (cachedLastModified == null) {
            this.cachedLastModified = cachedLastModified = Long.valueOf(this.webResource.getLastModified());
        }
        return var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public String getLastModifiedHttp() {
        void var1_1;
        String cachedLastModifiedHttp = this.cachedLastModifiedHttp;
        if (cachedLastModifiedHttp == null) {
            this.cachedLastModifiedHttp = cachedLastModifiedHttp = this.webResource.getLastModifiedHttp();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists() {
        void var1_1;
        Boolean cachedExists = this.cachedExists;
        if (cachedExists == null) {
            this.cachedExists = cachedExists = Boolean.valueOf(this.webResource.exists());
        }
        return var1_1.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isVirtual() {
        void var1_1;
        Boolean cachedIsVirtual = this.cachedIsVirtual;
        if (cachedIsVirtual == null) {
            this.cachedIsVirtual = cachedIsVirtual = Boolean.valueOf(this.webResource.isVirtual());
        }
        return var1_1.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDirectory() {
        void var1_1;
        Boolean cachedIsDirectory = this.cachedIsDirectory;
        if (cachedIsDirectory == null) {
            this.cachedIsDirectory = cachedIsDirectory = Boolean.valueOf(this.webResource.isDirectory());
        }
        return var1_1.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFile() {
        void var1_1;
        Boolean cachedIsFile = this.cachedIsFile;
        if (cachedIsFile == null) {
            this.cachedIsFile = cachedIsFile = Boolean.valueOf(this.webResource.isFile());
        }
        return var1_1.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean delete() {
        void var1_1;
        boolean deleteResult = this.webResource.delete();
        if (deleteResult) {
            this.cache.removeCacheEntry(this.webAppPath);
        }
        return (boolean)var1_1;
    }

    public String getName() {
        return this.webResource.getName();
    }

    /*
     * WARNING - void declaration
     */
    public long getContentLength() {
        void var1_1;
        Long cachedContentLength = this.cachedContentLength;
        if (cachedContentLength == null) {
            void var2_2;
            long result = 0L;
            if (this.webResource != null) {
                result = this.webResource.getContentLength();
                this.cachedContentLength = cachedContentLength = Long.valueOf(result);
            }
            return (long)var2_2;
        }
        return var1_1.longValue();
    }

    public String getCanonicalPath() {
        return this.webResource.getCanonicalPath();
    }

    public boolean canRead() {
        return this.webResource.canRead();
    }

    public String getWebappPath() {
        return this.webAppPath;
    }

    public String getETag() {
        return this.webResource.getETag();
    }

    /*
     * WARNING - void declaration
     */
    public void setMimeType(String mimeType) {
        void var1_1;
        this.webResource.setMimeType((String)var1_1);
    }

    public String getMimeType() {
        return this.webResource.getMimeType();
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream() {
        void var1_1;
        byte[] content = this.getContent();
        if (content == null) {
            return this.webResource.getInputStream();
        }
        return new ByteArrayInputStream((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getContent() {
        void var1_1;
        byte[] cachedContent = this.cachedContent;
        if (this.cachedContent == null) {
            if (this.getContentLength() > (long)this.objectMaxSizeBytes) {
                return null;
            }
            this.cachedContent = cachedContent = this.webResource.getContent();
        }
        return var1_1;
    }

    public long getCreation() {
        return this.webResource.getCreation();
    }

    /*
     * WARNING - void declaration
     */
    public URL getURL() {
        URL resourceURL = this.webResource.getURL();
        if (resourceURL == null) {
            return null;
        }
        try {
            void var3_4;
            CachedResourceURLStreamHandler handler = new CachedResourceURLStreamHandler(resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            URL result = new URL(null, resourceURL.toExternalForm(), handler);
            handler.setAssociatedURL(result);
            return var3_4;
        }
        catch (MalformedURLException e) {
            void var2_3;
            void var1_1;
            log.error((Object)sm.getString("cachedResource.invalidURL", new Object[]{var1_1.toExternalForm()}), (Throwable)var2_3);
            return null;
        }
    }

    public URL getCodeBase() {
        return this.webResource.getCodeBase();
    }

    public Certificate[] getCertificates() {
        return this.webResource.getCertificates();
    }

    public Manifest getManifest() {
        return this.webResource.getManifest();
    }

    public WebResourceRoot getWebResourceRoot() {
        return this.webResource.getWebResourceRoot();
    }

    final WebResource[] getWebResources() {
        return this.webResources;
    }

    final boolean usesClassLoaderResources() {
        return this.usesClassLoaderResources;
    }

    /*
     * WARNING - void declaration
     */
    final long getSize() {
        void var1_1;
        long result = 500L + (long)(this.getWebappPath().length() << 1);
        if (this.getContentLength() <= (long)this.objectMaxSizeBytes) {
            result += this.getContentLength();
        }
        return (long)var1_1;
    }

    static /* synthetic */ InputStream access$000(String[] x0) {
        String[] stringArray = x0;
        Arrays.sort(x0, Collator.getInstance(Locale.getDefault()));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return new ByteArrayInputStream(stringBuilder.toString().getBytes(Charset.defaultCharset()));
    }

    static final class CachedResourceJarURLConnection
    extends JarURLConnection {
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        /*
         * WARNING - void declaration
         */
        protected CachedResourceJarURLConnection(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) throws IOException {
            super(resourceURL);
            void var1_1;
            void var3_3;
            void var2_2;
            this.root = var2_2;
            this.webAppPath = var3_3;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = var1_1;
        }

        @Override
        public final void connect() throws IOException {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                void var1_1;
                return TongWebEmbedCachedResource.access$000(var1_1.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public final Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public final long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public final long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }

        @Override
        public final JarFile getJarFile() throws IOException {
            return ((JarURLConnection)this.resourceURL.openConnection()).getJarFile();
        }

        @Override
        public final JarEntry getJarEntry() throws IOException {
            if (this.getEntryName() == null) {
                return null;
            }
            return super.getJarEntry();
        }
    }

    static final class CachedResourceURLConnection
    extends URLConnection {
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        /*
         * WARNING - void declaration
         */
        protected CachedResourceURLConnection(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            super(resourceURL);
            void var1_1;
            void var3_3;
            void var2_2;
            this.root = var2_2;
            this.webAppPath = var3_3;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = var1_1;
        }

        @Override
        public final void connect() throws IOException {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                void var1_1;
                return TongWebEmbedCachedResource.access$000(var1_1.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public final Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public final long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public final long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }
    }

    static final class CachedResourceURLStreamHandler
    extends URLStreamHandler {
        private final URL resourceURL;
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private URL associatedURL = null;

        /*
         * WARNING - void declaration
         */
        public CachedResourceURLStreamHandler(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.resourceURL = var1_1;
            this.root = var2_2;
            this.webAppPath = var3_3;
            this.usesClassLoaderResources = usesClassLoaderResources;
        }

        /*
         * WARNING - void declaration
         */
        protected final void setAssociatedURL(URL associatedURL) {
            void var1_1;
            this.associatedURL = var1_1;
        }

        @Override
        protected final URLConnection openConnection(URL u) throws IOException {
            URL uRL;
            if (this.associatedURL != null && u == this.associatedURL) {
                if ("jar".equals(this.associatedURL.getProtocol())) {
                    return new CachedResourceJarURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
                }
                return new CachedResourceURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            }
            uRL = new URL(uRL.toExternalForm());
            return uRL.openConnection();
        }
    }
}

