/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.Service;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.naming.ContextBindings;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedWebappClassLoader;
import com.tongweb.springboot.v1.x.embed.TongwebEmbedStandardContext;
import com.tongweb.springboot.v1.x.exception.TongWebStartFailedException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.Assert;

public class TongWebEmbedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(TongWebEmbedServletContainer.class);
    private static final AtomicInteger CONTAINER_COUNTER = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final ServletContainer servletContainer;
    private final boolean autoStart;
    private volatile boolean started;

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedServletContainer(ServletContainer servletContainer) {
        this((ServletContainer)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedServletContainer(ServletContainer servletContainer, boolean autoStart) {
        void var2_2;
        void var1_1;
        Assert.notNull((Object)servletContainer, (String)"TongWeb Config Server must not be null");
        this.servletContainer = var1_1;
        this.autoStart = var2_2;
        this.initialize();
        this.getServletContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void initialize() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                this.removeServiceConnectors();
                this.servletContainer.start();
                this.rethrowDeferredStartupExceptions();
                Context context = this.findContext();
                try {
                    ContextBindings.bindClassLoader((Object)context, (Object)this.getNamingToken(context), (ClassLoader)this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {}
                this.startDaemonAwaitThread();
            }
            catch (Exception ex) {
                void var2_3;
                throw new EmbeddedServletContainerException("Unable to start TongWeb", (Throwable)var2_3);
            }
            return;
        }
    }

    private Context findContext() {
        for (Container child : this.servletContainer.getHost().findChildren()) {
            if (!(child instanceof Context)) continue;
            return (Context)child;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    /*
     * WARNING - void declaration
     */
    private void addInstanceIdToEngineName() {
        int instanceId = CONTAINER_COUNTER.incrementAndGet();
        if (instanceId > 0) {
            void var1_1;
            void var2_2;
            Engine engine = this.servletContainer.getEngine();
            engine.setName(var2_2.getName() + "-" + (int)var1_1);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.servletContainer.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            Connector[] connectorArray = connectors;
            int n = connectors.length;
            for (int i = 0; i < n; ++i) {
                Connector connector = connectorArray[i];
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] containerArray = this.servletContainer.getHost().findChildren();
        Container[] containerArray2 = containerArray;
        containerArray2 = containerArray;
        int n = containerArray.length;
        for (int i = 0; i < n; ++i) {
            Exception exception;
            Container container = containerArray2[i];
            if (!(container instanceof TongwebEmbedStandardContext) || (exception = ((TongwebEmbedStandardContext)container).getStarter().getStartUpException()) == null) continue;
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startDaemonAwaitThread() {
        void var1_1;
        Thread awaitThread = new Thread(this, "container-" + CONTAINER_COUNTER.get()){
            private /* synthetic */ TongWebEmbedServletContainer this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2);
            }

            @Override
            public final void run() {
                this.this$0.servletContainer.getServer().await();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        var1_1.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void start() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                Connector connector = this.servletContainer.getConnector();
                if (connector != null && this.autoStart) {
                    this.startConnector(connector);
                }
                this.checkThatConnectorsHaveStarted();
                this.started = true;
            }
            catch (TongWebStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                void var2_4;
                throw new EmbeddedServletContainerException("Unable to start TongWeb servlet container", (Throwable)var2_4);
            }
            finally {
                void var3_7;
                Context context = this.findContext();
                ContextBindings.unbindClassLoader((Object)context, (Object)this.getNamingToken((Context)var3_7), (ClassLoader)this.getClass().getClassLoader());
            }
            return;
        }
    }

    private void checkThatConnectorsHaveStarted() {
        for (Connector connector : this.servletContainer.getService().findConnectors()) {
            if (!LifecycleState.FAILED.equals((Object)connector.getState())) continue;
            throw new TongWebStartFailedException(connector.getPort());
        }
    }

    private void stopSilently() {
        try {
            this.stopTongweb();
            return;
        }
        catch (LifecycleException lifecycleException) {
            return;
        }
    }

    private void stopTongweb() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof TongWebEmbedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.servletContainer.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] serviceArray = this.servletContainer.getServer().findServices();
        Service[] serviceArray2 = serviceArray;
        serviceArray2 = serviceArray;
        int n = serviceArray.length;
        for (int i = 0; i < n; ++i) {
            Service service = serviceArray2[i];
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            Connector[] connectorArray = connectors;
            int n2 = connectors.length;
            for (int j = 0; j < n2; ++j) {
                Connector connector = connectorArray[j];
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
            return;
        }
        catch (Exception ex) {
            void var1_2;
            logger.error((Object)"Cannot pause connector: ", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startConnector(Connector connector) {
        try {
            for (Container child : this.servletContainer.getHost().findChildren()) {
                if (!(child instanceof TongwebEmbedStandardContext)) continue;
                ((TongwebEmbedStandardContext)child).deferredLoadOnStartup();
            }
            return;
        }
        catch (Exception ex) {
            void var1_2;
            logger.error((Object)"Cannot start connector: ", (Throwable)ex);
            throw new EmbeddedServletContainerException("Unable to start TongWeb connectors", (Throwable)var1_2);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                this.started = false;
                try {
                    this.stopTongweb();
                    this.servletContainer.destroy();
                }
                catch (LifecycleException lifecycleException) {}
            }
            catch (Exception ex) {
                void var2_2;
                throw new EmbeddedServletContainerException("Unable to stop TongWeb", (Throwable)var2_2);
            }
            finally {
                CONTAINER_COUNTER.decrementAndGet();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getPortsDescription(boolean localPort) {
        void var2_2;
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.servletContainer.getService().findConnectors()) {
            StringBuilder stringBuilder = ports;
            stringBuilder.append(stringBuilder.length() == 0 ? "" : " ");
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public int getPort() {
        if (!this.started) {
            return 0;
        }
        Connector connector = this.servletContainer.getConnector();
        if (connector != null) {
            void var1_1;
            return var1_1.getLocalPort();
        }
        return 0;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    /*
     * WARNING - void declaration
     */
    private Object getNamingToken(Context context) {
        try {
            return context.getNamingToken();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            void var1_1;
            return var1_1;
        }
    }
}

