/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.commons.license.LicenseSDKProvider;
import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import com.tongweb.commons.utils.ClashPreventUtils;
import com.tongweb.commons.utils.SystemExitUtil;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http11.AbstractHttp11JsseProtocol;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Manager;
import com.tongweb.container.Valve;
import com.tongweb.container.Wrapper;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.security.SecurityListener;
import com.tongweb.container.session.StandardManager;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.container.valves.FilterValue;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.container.valves.RemoteAddrValve;
import com.tongweb.container.valves.RemoteHostValve;
import com.tongweb.container.webresources.TongWebURLStreamHandlerFactory;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.properties.PropertyMapper;
import com.tongweb.springboot.v1.x.config.Http2;
import com.tongweb.springboot.v1.x.config.IoMode;
import com.tongweb.springboot.v1.x.config.ManageWebProperties;
import com.tongweb.springboot.v1.x.config.RemoteFilter;
import com.tongweb.springboot.v1.x.config.Ssl;
import com.tongweb.springboot.v1.x.config.TongWebServerProperties;
import com.tongweb.springboot.v1.x.embed.CheckIntegrityUtil;
import com.tongweb.springboot.v1.x.embed.SslStoreProviderUrlStreamHandlerFactory;
import com.tongweb.springboot.v1.x.embed.TldSkipPatterns;
import com.tongweb.springboot.v1.x.embed.TongWebConnectorInitializer;
import com.tongweb.springboot.v1.x.embed.TongWebContextInitializer;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedServletContainer;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedStarter;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedWebappClassLoader;
import com.tongweb.springboot.v1.x.embed.TongwebEmbedStandardContext;
import com.tongweb.springboot.v1.x.exception.TongWebErrorPage;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.descriptor.web.SecurityCollection;
import com.tongweb.web.util.descriptor.web.SecurityConstraint;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContainerInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.SslStoreProvider;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class TongWebEmbedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private static final Log log = LogFactory.getLog(TongWebEmbedServletContainerFactory.class);
    public static final String DEFAULT_PROTOCOL = "com.tongweb.connector.http11.Http11NioProtocol";
    @Autowired
    private TongWebServerProperties tongWebServerProperties;
    @Autowired
    private ManageWebProperties manageWebProperties;
    @Autowired
    private ApplicationContext context;
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private Valve accessLog;
    private Valve semaphore;
    private Valve filterValve;
    private RemoteFilter remoteFilter;
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private List<TongWebContextInitializer> tongWebContextInitializers = new ArrayList<TongWebContextInitializer>();
    private List<TongWebConnectorInitializer> tongWebConnectorInitializers = new ArrayList<TongWebConnectorInitializer>();
    private final List<Connector> additionalTongWebConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "com.tongweb.connector.http11.Http11NioProtocol";
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldSkipPatterns.DEFAULT);
    private Charset uriEncoding = DEFAULT_CHARSET;
    private List<String> notAllowHttpMethods = new ArrayList<String>();
    private Map<String, String> webApps;
    private String war;
    private int backgroundProcessorDelay;
    private Http2 http2;
    private boolean disableMBeanRegistry = true;

    public TongWebEmbedServletContainerFactory() {
    }

    @PostConstruct
    private void init() {
        this.initDisableMBeanRegistry();
        if (!(StringUtils.isEmpty((Object)this.manageWebProperties.getContextPath()) || StringUtils.isEmpty((Object)this.manageWebProperties.getAccess_iplist()) && StringUtils.isEmpty((Object)this.manageWebProperties.getBlocked_iplist()))) {
            this.filterValve = new FilterValue(this.manageWebProperties.convertProp());
        }
    }

    public List<String> getNotAllowHttpMethods() {
        return this.notAllowHttpMethods;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotAllowHttpMethods(List<String> notAllowHttpMethods) {
        void var1_1;
        this.notAllowHttpMethods = var1_1;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttp2(Http2 http2) {
        void var1_1;
        this.http2 = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedServletContainerFactory(int port) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedServletContainerFactory(String contextPath, int port) {
        super((String)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        void var1_1;
        this.disableMBeanRegistry = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        void var2_3;
        void var1_1;
        Iterator<Connector> iterator;
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        this.checkLicense();
        try {
            ClashPreventUtils.check();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        ServletContainer servletContainer = new ServletContainer();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tongweb");
        servletContainer.setBaseDir(baseDir.getAbsolutePath());
        if (this.protocol.equalsIgnoreCase(IoMode.APR.getClassName())) {
            AprLifecycleListener arpLifecycle = new AprLifecycleListener();
            this.addContextLifecycleListeners(new LifecycleListener[]{arpLifecycle});
        }
        this.addSecurityListener();
        Connector connector = new Connector(this.protocol);
        servletContainer.getService().addConnector(connector);
        this.customizeConnector(connector);
        servletContainer.setConnector((Connector)iterator);
        servletContainer.getHost().setAutoDeploy(false);
        this.configureEngine(servletContainer.getEngine());
        this.configureAccessLog(servletContainer.getHost());
        this.configureSemaphore(servletContainer.getHost());
        this.configureFilterValue(servletContainer.getHost());
        this.configureRemoteFilter(servletContainer.getHost());
        for (Connector additionalConnector : this.additionalTongWebConnectors) {
            servletContainer.getService().addConnector(additionalConnector);
        }
        this.prepareContext(servletContainer.getHost(), (ServletContextInitializer[])var1_1);
        this.configureWebApps(servletContainer);
        this.configureWar(servletContainer);
        return this.getTongWebServletContainer((ServletContainer)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setWebApps(Map<String, String> webApps) {
        void var1_1;
        this.webApps = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWar(String war) {
        void var1_1;
        this.war = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void configureWebApps(ServletContainer servletContainer) {
        if (this.webApps != null) {
            void var1_1;
            this.webApps.forEach((arg_0, arg_1) -> this.lambda$configureWebApps$0((ServletContainer)var1_1, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureWar(ServletContainer servletContainer) {
        if (this.war != null && this.war.length() != 0) {
            void var1_1;
            Iterator<Object> iterator;
            new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
            StandardContext context = (StandardContext)servletContainer.addWebapp("", this.war);
            context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
            WebappLoader loader = new WebappLoader();
            loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
            if (StringUtils.hasText((String)this.tongWebServerProperties.getTongweb().getResourceCacheList())) {
                loader.setCacheResourceNames(this.tongWebServerProperties.getTongweb().getResourceCacheList());
            }
            loader.setDelegate(true);
            context.setLoader((Loader)iterator);
            context.setReloadable(false);
            this.resetDefaultLocaleMapping((Context)context);
            this.addLocaleMappings((Context)context);
            try {
                context.setUseRelativeRedirects(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            this.configurePluggSkipPatterns((Context)context);
            this.postProcessContext((Context)context);
            for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
                context.addLifecycleListener(lifecycleListener);
            }
            for (Valve valve : this.contextValves) {
                context.getPipeline().addValve(valve);
            }
            for (ErrorPage errorPage : this.getErrorPages()) {
                new TongWebErrorPage(errorPage).addToContext((Context)context);
            }
            for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
                TongWebContextInitializer tongWebContextInitializer;
                context.addMimeMapping(mapping.getExtension(), tongWebContextInitializer.getMimeType());
            }
            this.configureSession((Context)context);
            for (TongWebContextInitializer tongWebContextInitializer : this.tongWebContextInitializers) {
                tongWebContextInitializer.init((Context)context);
            }
            this.customizeErrorReportValve((Context)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addSecurityListener() {
        boolean securityEnabled = this.tongWebServerProperties.getTongweb().getSecurityListener().isEnabled();
        boolean removeRootUser = this.tongWebServerProperties.getTongweb().getSecurityListener().isRemoveRootUser();
        String minimumUmask = this.tongWebServerProperties.getTongweb().getSecurityListener().getMinimumUmask();
        String checkedOsUsers = this.tongWebServerProperties.getTongweb().getSecurityListener().getCheckedOsUsers();
        if (securityEnabled) {
            void var1_2;
            void var2_3;
            SecurityListener securityListener = new SecurityListener();
            if (!StringUtils.isEmpty((Object)minimumUmask)) {
                void var3_4;
                securityListener.setMinimumUmask((String)var3_4);
            }
            if (var2_3 != false) {
                securityListener.setCheckedOsUsers("");
            }
            if (!StringUtils.isEmpty((Object)checkedOsUsers)) {
                securityListener.setCheckedOsUsers(checkedOsUsers);
            }
            this.addContextLifecycleListeners(new LifecycleListener[]{var1_2});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkLicense() {
        void var3_3;
        LicenseConfig licenseConfig;
        void var2_2;
        SystemExitUtil.setHook(() -> System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0})));
        new CheckIntegrityUtil();
        PropertyMapper propertyMapper = PropertyMapper.get();
        String validType = this.tongWebServerProperties.getTongweb().getLicense().getType();
        String productVersion = "esRTevlz6wm/tpN/Cbl4CfU7xtHDelNBw/kd4O9uSO0=";
        String licensePath = this.tongWebServerProperties.getTongweb().getLicense().getPath();
        String tongwebEdition = "Embed";
        if (var2_2.equals("remote")) {
            propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getLicenseIps()).whenHasText().to(this::putLicenseIps);
            propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getLicensePublicKey()).whenHasText().to(this::putPublicKey);
            this.putProductKey(productVersion);
            this.putTongwebEdition(tongwebEdition);
            if (this.tongWebServerProperties.getTongweb().getLicense().getSsl() != null) {
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().isSslEnabled()).whenNonNull().to(this::pusSslEnabled);
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getKeyStore()).whenHasText().to(this::putKeyStore);
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getKeyStorePassword()).whenHasText().to(this::putKeyStorePassword);
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getKeyStoreType()).whenHasText().to(this::putKeyStoreType);
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getTrustStore()).whenHasText().to(this::putTrustStore);
                propertyMapper.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getTrustStorePassword()).whenHasText().to(this::putTrustStorePassword);
                licenseConfig.from(this.tongWebServerProperties.getTongweb().getLicense().getSsl().getTrustStoreType()).whenHasText().to(this::putTrustStoreType);
            }
            LicenseSDKProvider.validate();
            return;
        }
        licenseConfig = LicenseProviderFacade.genConfig((String)var3_3, (String)licensePath, (String)tongwebEdition, (String)"TongWeb");
        LicenseProviderFacade.config((LicenseConfig)licenseConfig);
        LicenseProviderFacade.validate();
        LicenseProviderFacade.startWorker();
    }

    /*
     * WARNING - void declaration
     */
    private void putLicenseIps(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.license-ips", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putPublicKey(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.publicKey", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putProductKey(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.productKey", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putTongwebEdition(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.tongWebEdition", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void pusSslEnabled(boolean value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.enabled", String.valueOf((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void putKeyStore(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.keyStore", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putKeyStorePassword(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.keyStorePassword", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putKeyStoreType(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.keyStoreType", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putTrustStore(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.trustStore", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putTrustStorePassword(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.trustStorePassword", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putTrustStoreType(String value) {
        void var1_1;
        System.setProperty("server.tongweb.license.ssl.trustStoreType", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void configureEngine(Engine engine) {
        void var1_1;
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            void var3_3;
            engine.getPipeline().addValve((Valve)var3_3);
        }
        var1_1.addLifecycleListener(event -> {
            LifecycleEvent lifecycleEvent;
            if ("before_stop".equals(lifecycleEvent.getType())) {
                LicenseProviderFacade.exit();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void configureAccessLog(Host host) {
        if (this.getAccessLog() != null) {
            void var1_1;
            var1_1.getPipeline().addValve(this.getAccessLog());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureSemaphore(Host host) {
        if (this.getSemaphore() != null) {
            void var1_1;
            var1_1.getPipeline().addValve(this.getSemaphore());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureFilterValue(Host host) {
        if (this.getFilterValve() != null) {
            void var1_1;
            var1_1.getPipeline().addValve(this.getFilterValve());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureRemoteFilter(Host host) {
        RemoteFilter filter = this.getRemoteFilter();
        if (filter == null) {
            return;
        }
        String allowAddr = filter.getAllowAddr();
        String allowHost = filter.getAllowHost();
        String denyAddr = filter.getDenyAddr();
        String denyHost = filter.getDenyHost();
        Integer status = filter.getDenyStatus();
        Valve[] valves = host.getPipeline().getValves();
        for (int i = 0; valves != null && i < valves.length; ++i) {
            if (valves[i] instanceof RemoteAddrValve) {
                host.getPipeline().removeValve(valves[i]);
            }
            if (!(valves[i] instanceof RemoteHostValve)) continue;
            host.getPipeline().removeValve(valves[i]);
        }
        if (allowAddr != null || denyAddr != null) {
            RemoteAddrValve remoteAddrValve = new RemoteAddrValve();
            remoteAddrValve.setDenyStatus(status.intValue());
            if (allowAddr != null) {
                void var3_3;
                if (allowAddr.equals("*")) {
                    allowAddr = ".*";
                }
                remoteAddrValve.setAllow((String)var3_3);
            }
            if (denyAddr != null) {
                if (denyAddr.equals("*")) {
                    denyAddr = ".*";
                }
                remoteAddrValve.setDeny(denyAddr);
            }
            host.getPipeline().addValve((Valve)remoteAddrValve);
        }
        if (!(allowHost == null & denyHost == null)) {
            void var1_1;
            void var2_2;
            RemoteHostValve remoteHostValve = new RemoteHostValve();
            remoteHostValve.setDenyStatus(var2_2.intValue());
            if (allowHost != null) {
                if (allowHost.equals("*")) {
                    allowHost = ".*";
                }
                remoteHostValve.setAllow(allowHost);
            }
            if (denyHost != null) {
                if (denyHost.equals("*")) {
                    denyHost = ".*";
                }
                remoteHostValve.setDeny(denyHost);
            }
            var1_1.getPipeline().addValve((Valve)remoteHostValve);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        void var2_2;
        void var1_1;
        void var3_3;
        File docBase = this.getValidDocumentRoot();
        docBase = docBase != null ? docBase : this.createTempDir("tongweb-docbase");
        TongwebEmbedStandardContext context = new TongwebEmbedStandardContext();
        context.setDenyUncoveredHttpMethods(true);
        context.setName(this.getContextPath());
        context.setDisplayName(this.getDisplayName());
        context.setPath(this.getContextPath());
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        this.resetDefaultLocaleMapping((Context)context);
        this.addLocaleMappings((Context)context);
        try {
            context.setUseRelativeRedirects(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        this.configureTldSkipPatterns((Context)context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
        if (StringUtils.hasText((String)this.tongWebServerProperties.getTongweb().getResourceCacheList())) {
            loader.setCacheResourceNames(this.tongWebServerProperties.getTongweb().getResourceCacheList());
        }
        loader.setDelegate(true);
        context.setLoader((Loader)var3_3);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
            context.addLifecycleListener(new StoreMergedWebXmlListener(0));
        }
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        var1_1.addChild((Container)context);
        this.configureContext((Context)context, (ServletContextInitializer[])var2_2);
        this.postProcessContext((Context)context);
        context.preLoadStaticResources();
    }

    /*
     * WARNING - void declaration
     */
    private void resetDefaultLocaleMapping(Context context) {
        void var1_1;
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        var1_1.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
    }

    /*
     * WARNING - void declaration
     */
    private void addLocaleMappings(Context context) {
        for (Map.Entry entry : this.getLocaleCharsetMappings().entrySet()) {
            void var3_3;
            Locale locale = (Locale)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            context.addLocaleEncodingMappingParameter(locale.toString(), var3_3.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureTldSkipPatterns(Context context) {
        void var2_2;
        void var1_1;
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        var1_1.getJarScanner().setJarScanFilter((JarScanFilter)var2_2);
    }

    private void configurePluggSkipPatterns(Context context) {
    }

    /*
     * WARNING - void declaration
     */
    private void addDefaultServlet(Context context) {
        void var1_1;
        void var2_2;
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.tongweb.container.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)var2_2);
        this.addServletMapping((Context)var1_1, "/", "default");
    }

    /*
     * WARNING - void declaration
     */
    private void addJspServlet(Context context) {
        void var1_1;
        void var2_2;
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJspServlet().getClassName());
        jspServlet.addInitParameter("fork", "false");
        for (Map.Entry initParameter : this.getJspServlet().getInitParameters().entrySet()) {
            jspServlet.addInitParameter((String)initParameter.getKey(), (String)initParameter.getValue());
        }
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)var2_2);
        this.addServletMapping(context, "*.jsp", "jsp");
        this.addServletMapping((Context)var1_1, "*.jspx", "jsp");
    }

    /*
     * WARNING - void declaration
     */
    private void addServletMapping(Context context, String pattern, String name) {
        void var3_3;
        void var2_2;
        context.addServletMappingDecoded((String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void addJasperInitializer(TongwebEmbedStandardContext context) {
        try {
            void var2_2;
            void var1_1;
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.tongweb.jasper.servlet.JasperInitializer", null).newInstance();
            var1_1.addServletContainerInitializer((ServletContainerInitializer)var2_2, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customizeConnector(Connector connector) {
        void var2_2;
        if (this.notAllowHttpMethods.contains("TRACE") || this.notAllowHttpMethods.contains("trace") || !this.tongWebServerProperties.getTongweb().getAllowTrace().booleanValue()) {
            connector.setAllowTrace(false);
        } else {
            connector.setAllowTrace(true);
        }
        int port = Math.max(this.getPort(), 0);
        connector.setPort((int)var2_2);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", (Object)this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            this.customizeCompression(connector);
        }
        for (TongWebConnectorInitializer tongWebConnectorInitializer : this.tongWebConnectorInitializers) {
            tongWebConnectorInitializer.init(connector);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            void var1_1;
            var1_1.setAddress(this.getAddress());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeSsl(Connector connector) {
        void var2_2;
        ProtocolHandler handler = connector.getProtocolHandler();
        Assert.state((boolean)(handler instanceof AbstractHttp11JsseProtocol), (String)"To use SSL, the connector's protocol handler must be an AbstractHttp11JsseProtocol subclass");
        this.configureSsl((AbstractHttp11JsseProtocol)var2_2, this.getSsl());
        connector.setScheme("https");
        connector.setSecure(true);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            void var1_1;
            var1_1.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeCompression(Connector connector) {
        Compression compression;
        AbstractHttp11Protocol protocol;
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            compression = this.getCompression();
            protocol.setCompression("on");
            protocol.setCompressionMinSize(compression.getMinResponseSize());
            protocol.setCompressibleMimeType(StringUtils.arrayToCommaDelimitedString((Object[])compression.getMimeTypes()));
            if (this.getCompression().getExcludedUserAgents() != null) {
                protocol.setNoCompressionUserAgents(StringUtils.arrayToCommaDelimitedString((Object[])this.getCompression().getExcludedUserAgents()));
            }
        }
        if (handler instanceof Http2Protocol) {
            void var3_3;
            void var1_1;
            protocol = (Http2Protocol)var1_1;
            compression = this.getCompression();
            protocol.setCompression("on");
            protocol.setCompressionMinSize(compression.getMinResponseSize());
            protocol.setCompressibleMimeType(StringUtils.arrayToCommaDelimitedString((Object[])var3_3.getMimeTypes()));
            if (this.getCompression().getExcludedUserAgents() != null) {
                void var2_2;
                var2_2.setNoCompressionUserAgents(StringUtils.arrayToCommaDelimitedString((Object[])this.getCompression().getExcludedUserAgents()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void configureSsl(AbstractHttp11JsseProtocol<?> protocol, org.springframework.boot.context.embedded.Ssl ssl) {
        void var2_2;
        void var1_1;
        TongWebURLStreamHandlerFactory tongWebURLStreamHandlerFactory;
        String ciphers;
        protocol.setSSLEnabled(true);
        protocol.setSslProtocol(ssl.getProtocol());
        this.configureSslClientAuth(protocol, ssl);
        protocol.setKeystorePass(ssl.getKeyStorePassword());
        protocol.setKeyPass(ssl.getKeyPassword());
        protocol.setKeyAlias(ssl.getKeyAlias());
        if (ssl instanceof Ssl && StringUtils.startsWithIgnoreCase((String)ssl.getProtocol(), (String)"GMSSL")) {
            protocol.setSslImplementationName(((Ssl)ssl).getSslClassName());
        }
        if (StringUtils.hasText((String)(ciphers = StringUtils.arrayToCommaDelimitedString((Object[])ssl.getCiphers())))) {
            protocol.setCiphers((String)tongWebURLStreamHandlerFactory);
        }
        if (ssl.getEnabledProtocols() != null) {
            try {
                for (TongWebURLStreamHandlerFactory tongWebURLStreamHandlerFactory2 : protocol.findSslHostConfigs()) {
                    tongWebURLStreamHandlerFactory2.setProtocols(StringUtils.arrayToCommaDelimitedString((Object[])ssl.getEnabledProtocols()));
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Assert.isTrue((boolean)protocol.setProperty("sslEnabledProtocols", StringUtils.arrayToCommaDelimitedString((Object[])ssl.getEnabledProtocols())), (String)"Failed to set sslEnabledProtocols");
            }
        }
        if (this.getSslStoreProvider() != null) {
            tongWebURLStreamHandlerFactory = TongWebURLStreamHandlerFactory.getInstance();
            tongWebURLStreamHandlerFactory.addUserFactory((URLStreamHandlerFactory)new SslStoreProviderUrlStreamHandlerFactory(this.getSslStoreProvider()));
            protocol.setKeystoreFile("springbootssl:keyStore");
            protocol.setTruststoreFile("springbootssl:trustStore");
            return;
        }
        this.configureSslKeyStore(protocol, ssl);
        this.configureSslTrustStore((AbstractHttp11JsseProtocol<?>)var1_1, (org.springframework.boot.context.embedded.Ssl)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void configureSslClientAuth(AbstractHttp11JsseProtocol<?> protocol, org.springframework.boot.context.embedded.Ssl ssl) {
        void var2_2;
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            protocol.setClientAuth(Boolean.TRUE.toString());
            return;
        }
        if (var2_2.getClientAuth() == Ssl.ClientAuth.WANT) {
            void var1_1;
            var1_1.setClientAuth("want");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void configureSslStoreProvider(AbstractHttp11JsseProtocol<?> protocol, SslStoreProvider sslStoreProvider) {
        void var1_1;
        Assert.isInstanceOf(Http11NioProtocol.class, (Object)var1_1, (String)"SslStoreProvider can only be used with Http11NioProtocol");
    }

    /*
     * WARNING - void declaration
     */
    private void configureSslKeyStore(AbstractHttp11JsseProtocol<?> protocol, org.springframework.boot.context.embedded.Ssl ssl) {
        void var1_1;
        try {
            if (StringUtils.startsWithIgnoreCase((String)ssl.getProtocol(), (String)"GMSSL")) {
                protocol.setKeystoreFile(ResourceUtils.getURL((String)ssl.getKeyStore()).toString());
            } else {
                protocol.setKeystoreFile(ResourceUtils.getURL((String)ssl.getKeyStore()).toString());
            }
        }
        catch (FileNotFoundException ex) {
            void var1_2;
            throw new EmbeddedServletContainerException("Could not load key store: " + ex.getMessage(), (Throwable)var1_2);
        }
        if (ssl.getKeyStoreType() != null) {
            var1_1.setKeystoreType(ssl.getKeyStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            void var2_3;
            var1_1.setKeystoreProvider(var2_3.getKeyStoreProvider());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureSslTrustStore(AbstractHttp11JsseProtocol<?> protocol, org.springframework.boot.context.embedded.Ssl ssl) {
        void var1_1;
        if (ssl.getTrustStore() != null) {
            try {
                protocol.setTruststoreFile(ResourceUtils.getURL((String)ssl.getTrustStore()).toString());
            }
            catch (FileNotFoundException ex) {
                void var1_2;
                throw new EmbeddedServletContainerException("Could not load trust store: " + ex.getMessage(), (Throwable)var1_2);
            }
        }
        var1_1.setTruststorePass(ssl.getTrustStorePassword());
        if (ssl.getTrustStoreType() != null) {
            var1_1.setTruststoreType(ssl.getTrustStoreType());
        }
        if (ssl.getTrustStoreProvider() != null) {
            void var2_3;
            var1_1.setTruststoreProvider(var2_3.getTrustStoreProvider());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        void var1_1;
        Iterator<Object> iterator;
        TongWebEmbedStarter starter = new TongWebEmbedStarter(initializers);
        if (context instanceof TongwebEmbedStandardContext) {
            ((TongwebEmbedStandardContext)context).setStarter(starter);
        }
        context.addServletContainerInitializer((ServletContainerInitializer)iterator, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new TongWebErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            TongWebContextInitializer tongWebContextInitializer;
            context.addMimeMapping(mapping.getExtension(), tongWebContextInitializer.getMimeType());
        }
        this.configureSession(context);
        for (TongWebContextInitializer tongWebContextInitializer : this.tongWebContextInitializers) {
            tongWebContextInitializer.init(context);
        }
        this.customizeErrorReportValve((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void configureSession(Context context) {
        void var1_1;
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        if (this.isPersistSession()) {
            void var2_3;
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession((Manager)var2_3);
            return;
        }
        var1_1.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener(0));
    }

    /*
     * WARNING - void declaration
     */
    private void configurePersistSession(Manager manager) {
        void var2_2;
        void var1_1;
        Assert.state((boolean)(manager instanceof StandardManager), (String)("Unable to persist HTTP session state using manager type " + manager.getClass().getName()));
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)var1_1).setPathname(var2_2.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    private long getSessionTimeoutInMinutes() {
        void var1_1;
        long sessionTimeout = this.getSessionTimeout();
        if (sessionTimeout > 0L) {
            sessionTimeout = Math.max(TimeUnit.SECONDS.toMinutes(sessionTimeout), 1L);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void customizeErrorReportValve(Context context) {
        block7: {
            void var1_1;
            boolean bl = this.tongWebServerProperties.getTongweb().getJsonErrorReportValve().isEnabled();
            if (bl) {
                JsonErrorReportValve valve = new JsonErrorReportValve();
                context.getPipeline().addValve((Valve)valve);
                return;
            }
            if (this.tongWebServerProperties.getTongweb().getErrorReportValve().isEnabled()) {
                boolean errorReportValveShowReport = this.tongWebServerProperties.getTongweb().getErrorReportValve().isShowReport();
                boolean errorReportValveShowServerInfo = this.tongWebServerProperties.getTongweb().getErrorReportValve().isShowServerInfo();
                this.generateErrorReportValve(context, errorReportValveShowReport, errorReportValveShowServerInfo);
                return;
            }
            if (!StringUtils.isEmpty((Object)this.tongWebServerProperties.getTongweb().getCustomizedErrorReportValve().getType())) {
                block6: {
                    String customizedErrorValveType = this.tongWebServerProperties.getTongweb().getCustomizedErrorReportValve().getType();
                    try {
                        Object customizedErrorValveObj = Class.forName(customizedErrorValveType).getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (customizedErrorValveObj instanceof ErrorReportValve) {
                            ErrorReportValve customizedErrorValve = (ErrorReportValve)customizedErrorValveObj;
                            context.getPipeline().addValve((Valve)customizedErrorValve);
                            break block6;
                        }
                        this.logger.warn((Object)("customize valve class " + customizedErrorValveType + " is invalid , customized errorValve failed."));
                        break block7;
                    }
                    catch (Throwable e) {
                        void var3_7;
                        void var2_3;
                        this.logger.warn((Object)("class " + (String)var2_3 + " not exist. customized errorValve failed."), (Throwable)var3_7);
                    }
                }
                return;
            }
            this.generateErrorReportValve((Context)var1_1, false, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateErrorReportValve(Context context, boolean showReport, boolean showServerInfo) {
        void var1_1;
        void var3_3;
        void var2_2;
        ErrorReportValve valve = new ErrorReportValve();
        valve.setShowReport((boolean)var2_2);
        valve.setShowServerInfo((boolean)var3_3);
        var1_1.getPipeline().addValve((Valve)valve);
    }

    /*
     * WARNING - void declaration
     */
    protected void postProcessContext(Context context) {
        void var1_1;
        this.allowHttpMethods((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void allowHttpMethods(Context context) {
        if (!this.notAllowHttpMethods.isEmpty()) {
            void var1_1;
            void var2_2;
            void var3_3;
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.setUserConstraint("CONFIDENTIAL");
            SecurityCollection securityCollection = new SecurityCollection();
            securityCollection.addPattern("/*");
            for (String httpMethod : this.notAllowHttpMethods) {
                securityCollection.addMethod(httpMethod);
            }
            constraint.setAuthConstraint(true);
            constraint.addCollection((SecurityCollection)var3_3);
            SecurityConstraint constraint2 = new SecurityConstraint();
            constraint2.setUserConstraint("NONE");
            SecurityCollection securityCollection2 = new SecurityCollection();
            securityCollection2.addPattern("/*");
            constraint2.addCollection(securityCollection2);
            context.addConstraint((SecurityConstraint)var2_2);
            var1_1.addConstraint(constraint2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected TongWebEmbedServletContainer getTongWebServletContainer(ServletContainer servletContainer) {
        void var1_1;
        return new TongWebEmbedServletContainer((ServletContainer)var1_1, this.getPort() >= 0);
    }

    /*
     * WARNING - void declaration
     */
    public void setResourceLoader(ResourceLoader resourceLoader) {
        void var1_1;
        this.resourceLoader = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseDirectory(File baseDirectory) {
        void var1_1;
        this.baseDirectory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setTldSkip(String tldSkip) {
        void var1_1;
        Assert.notNull((Object)tldSkip, (String)"TldSkip must not be null");
        this.setTldSkipPatterns(StringUtils.commaDelimitedListToSet((String)var1_1));
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setTldSkipPatterns(Collection<String> patterns) {
        void var1_1;
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>((Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addTldSkipPatterns(String ... patterns) {
        void var1_1;
        Assert.notNull((Object)patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocol(String protocol) {
        void var1_1;
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEngineValves(Collection<? extends Valve> engineValves) {
        void var1_1;
        Assert.notNull(engineValves, (String)"Valves must not be null");
        this.engineValves = new ArrayList<Valve>((Collection<Valve>)var1_1);
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    public Valve getAccessLog() {
        return this.accessLog;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessLog(Valve accessLog) {
        void var1_1;
        this.accessLog = var1_1;
    }

    public RemoteFilter getRemoteFilter() {
        return this.remoteFilter;
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteFilter(RemoteFilter remoteFilter) {
        void var1_1;
        this.remoteFilter = var1_1;
    }

    public Valve getFilterValve() {
        return this.filterValve;
    }

    public void setFilterValve(Valve filterValve) {
    }

    public Valve getSemaphore() {
        return this.semaphore;
    }

    /*
     * WARNING - void declaration
     */
    public void setSemaphore(Valve semaphore) {
        void var1_1;
        this.semaphore = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addEngineValves(Valve ... engineValves) {
        void var1_1;
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setContextValves(Collection<? extends Valve> contextValves) {
        void var1_1;
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>((Collection<Valve>)var1_1);
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    /*
     * WARNING - void declaration
     */
    public void addContextValves(Valve ... contextValves) {
        void var1_1;
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        void var1_1;
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>((Collection<LifecycleListener>)var1_1);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    /*
     * WARNING - void declaration
     */
    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        void var1_1;
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setTongWebContextInitializers(Collection<? extends TongWebContextInitializer> tongWebContextInitializers) {
        void var1_1;
        Assert.notNull(tongWebContextInitializers, (String)"tongWebContextInitializers must not be null");
        this.tongWebContextInitializers = new ArrayList<TongWebContextInitializer>((Collection<TongWebContextInitializer>)var1_1);
    }

    public Collection<TongWebContextInitializer> getTongWebContextInitializers() {
        return this.tongWebContextInitializers;
    }

    /*
     * WARNING - void declaration
     */
    public void addContextCustomizers(TongWebContextInitializer ... tongWebContextInitializers) {
        void var1_1;
        Assert.notNull((Object)tongWebContextInitializers, (String)"tongWebContextInitializers must not be null");
        this.tongWebContextInitializers.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setTongWebConnectorInitializers(Collection<? extends TongWebConnectorInitializer> tongWebConnectorInitializers) {
        void var1_1;
        Assert.notNull(tongWebConnectorInitializers, (String)"tongWebContextInitializers must not be null");
        this.tongWebConnectorInitializers = new ArrayList<TongWebConnectorInitializer>((Collection<TongWebConnectorInitializer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addConnectorCustomizers(TongWebConnectorInitializer ... tongWebConnectorInitializers) {
        void var1_1;
        Assert.notNull((Object)tongWebConnectorInitializers, (String)"tongWebContextInitializers must not be null");
        this.tongWebConnectorInitializers.addAll(Arrays.asList(var1_1));
    }

    public Collection<TongWebConnectorInitializer> getTongWebConnectorInitializers() {
        return this.tongWebConnectorInitializers;
    }

    /*
     * WARNING - void declaration
     */
    public void addAdditionalTongWebConnectors(Connector ... connectors) {
        void var1_1;
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalTongWebConnectors.addAll(Arrays.asList(var1_1));
    }

    public List<Connector> getAdditionalTongWebConnectors() {
        return this.additionalTongWebConnectors;
    }

    /*
     * WARNING - void declaration
     */
    public void setUriEncoding(Charset uriEncoding) {
        void var1_1;
        this.uriEncoding = var1_1;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundProcessorDelay(int delay) {
        void var1_1;
        this.backgroundProcessorDelay = var1_1;
    }

    private File getJarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".jar");
    }

    /*
     * WARNING - void declaration
     */
    private File getArchiveFileDocumentRoot(String extension) {
        void var1_1;
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith((String)var1_1)) {
            void var2_2;
            return var2_2.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        TongWebEmbedServletContainerFactory tongWebEmbedServletContainerFactory = this;
        return tongWebEmbedServletContainerFactory.getCodeSourceArchive(((Object)((Object)tongWebEmbedServletContainerFactory)).getClass().getProtectionDomain().getCodeSource());
    }

    /*
     * WARNING - void declaration
     */
    File getCodeSourceArchive(CodeSource codeSource) {
        try {
            void var1_1;
            String path;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            path = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().getName() : ((URL)((Object)path)).toURI().getPath();
            int index = path.indexOf("!/");
            if (index != -1) {
                void var2_3;
                path = path.substring(0, (int)var2_3);
            }
            return new File((String)var1_1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initDisableMBeanRegistry() {
        this.disableMBeanRegistry = !this.tongWebServerProperties.getTongweb().getMbeanregistry().isEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$configureWebApps$0(ServletContainer servletContainer, String key, String value) {
        void var1_1;
        Iterator<Object> iterator;
        new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
        StandardContext context = (StandardContext)servletContainer.addWebapp(key.startsWith("/") ? key : "/" + key, value);
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        WebappLoader loader = new WebappLoader();
        loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
        if (StringUtils.hasText((String)this.tongWebServerProperties.getTongweb().getResourceCacheList())) {
            loader.setCacheResourceNames(this.tongWebServerProperties.getTongweb().getResourceCacheList());
        }
        loader.setDelegate(true);
        context.setLoader((Loader)iterator);
        context.setReloadable(false);
        this.resetDefaultLocaleMapping((Context)context);
        this.addLocaleMappings((Context)context);
        try {
            context.setUseRelativeRedirects(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        this.configurePluggSkipPatterns((Context)context);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new TongWebErrorPage(errorPage).addToContext((Context)context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            TongWebContextInitializer tongWebContextInitializer;
            context.addMimeMapping(mapping.getExtension(), tongWebContextInitializer.getMimeType());
        }
        this.configureSession((Context)context);
        for (TongWebContextInitializer tongWebContextInitializer : this.tongWebContextInitializers) {
            tongWebContextInitializer.init((Context)context);
        }
        this.customizeErrorReportValve((Context)var1_1);
    }

    static final class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        /*
         * WARNING - void declaration
         */
        public final void lifecycleEvent(LifecycleEvent event) {
            Manager manager;
            if (event.getType().equals("start") && (manager = (event = (Context)event.getLifecycle()).getManager()) != null && manager instanceof StandardManager) {
                void var1_1;
                ((StandardManager)var1_1).setPathname(null);
            }
        }

        /* synthetic */ DisablePersistSessionListener(byte by) {
            this();
        }
    }

    static final class StoreMergedWebXmlListener
    implements LifecycleListener {
        private StoreMergedWebXmlListener() {
        }

        public final void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                StoreMergedWebXmlListener storeMergedWebXmlListener;
                Context context = (Context)storeMergedWebXmlListener.getLifecycle();
                storeMergedWebXmlListener = this;
                storeMergedWebXmlListener = context.getServletContext();
                if (storeMergedWebXmlListener.getAttribute("com.tongweb.web.util.scan.MergedWebXml") == null) {
                    storeMergedWebXmlListener.setAttribute("com.tongweb.web.util.scan.MergedWebXml", StoreMergedWebXmlListener.getEmptyWebXml());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static String getEmptyWebXml() {
            String string;
            InputStream stream = TongWebEmbedServletContainerFactory.class.getClassLoader().getResourceAsStream("empty-web.xml");
            Assert.state((stream != null ? 1 : 0) != 0, (String)"Unable to read empty web.xml");
            try {
                string = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    void var0;
                    var0.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    void var1_3;
                    throw new IllegalStateException((Throwable)var1_3);
                }
            }
            stream.close();
            return string;
        }

        /* synthetic */ StoreMergedWebXmlListener(byte by) {
            this();
        }
    }
}

