/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.container.Context;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.TrackedWebResource;
import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.webresources.DirResourceSet;
import com.tongweb.container.webresources.EmptyResourceSet;
import com.tongweb.container.webresources.FileResourceSet;
import com.tongweb.container.webresources.JarResourceSet;
import com.tongweb.container.webresources.JarWarResourceSet;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.container.webresources.TongWebURLStreamHandlerFactory;
import com.tongweb.container.webresources.WarResourceSet;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedCache;
import com.tongweb.web.util.buf.UriUtil;
import com.tongweb.web.util.compat.JreCompat;
import com.tongweb.web.util.http.RequestUtil;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class TongWebEmbedStandardRoot
extends StandardRoot {
    private static final Log log = LogFactory.getLog(TongWebEmbedStandardRoot.class);
    protected static final StringManager sm = StringManager.getManager(StandardRoot.class);
    private Context context;
    private boolean allowLinking = false;
    private final List<WebResourceSet> preResources = new ArrayList<WebResourceSet>();
    private WebResourceSet main;
    private final List<WebResourceSet> classResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> jarResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> postResources = new ArrayList<WebResourceSet>();
    private final TongWebEmbedCache cache = new TongWebEmbedCache(this);
    private boolean cachingAllowed = true;
    private ObjectName cacheJmxName = null;
    private boolean trackLockedFiles = false;
    private final Set<TrackedWebResource> trackedResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<WebResourceSet> mainResources = new ArrayList<WebResourceSet>();
    private final List<List<WebResourceSet>> allResources = new ArrayList<List<WebResourceSet>>();

    public TongWebEmbedStandardRoot() {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
    }

    /*
     * WARNING - void declaration
     */
    public TongWebEmbedStandardRoot(Context context) {
        void var1_1;
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
        this.context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String[] list(String path) {
        void var1_1;
        return this.list((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private String[] list(String path, boolean validate) {
        void var2_3;
        if (validate) {
            path = this.validate(path);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                String[] entries = webResourceSet.list(path);
                result.addAll(Arrays.asList(entries));
            }
        }
        return var2_3.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> listWebAppPaths(String path) {
        void var2_2;
        path = this.validate(path);
        HashSet result = new HashSet();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                result.addAll(webResourceSet.listWebAppPaths(path));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean mkdir(String path) {
        void var2_2;
        if (this.preResourceExists(path = this.validate(path))) {
            return false;
        }
        boolean mkdirResult = this.main.mkdir(path);
        if (mkdirResult && this.isCachingAllowed()) {
            void var1_1;
            this.cache.removeCacheEntry((String)var1_1);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean write(String path, InputStream is, boolean overwrite) {
        void var2_3;
        void var3_4;
        path = this.validate(path);
        if (!overwrite && this.preResourceExists(path)) {
            return false;
        }
        boolean writeResult = this.main.write(path, is, (boolean)var3_4);
        if (writeResult && this.isCachingAllowed()) {
            void var1_1;
            this.cache.removeCacheEntry((String)var1_1);
        }
        return (boolean)var2_3;
    }

    private boolean preResourceExists(String path) {
        for (WebResourceSet webResourceSet : this.preResources) {
            if (!(webResourceSet = webResourceSet.getResource(path)).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public WebResource getResource(String path) {
        void var1_1;
        return this.getResource((String)var1_1, true, false);
    }

    /*
     * WARNING - void declaration
     */
    protected WebResource getResource(String path, boolean validate, boolean useClassLoaderResources) {
        void var3_3;
        void var1_1;
        if (validate) {
            path = this.validate(path);
        }
        if (this.isCachingAllowed()) {
            return this.cache.getResource(path, useClassLoaderResources);
        }
        return this.getResourceInternal((String)var1_1, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public WebResource getClassLoaderResource(String path) {
        void var1_1;
        return this.getResource("/WEB-INF/classes" + (String)var1_1, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public WebResource[] getClassLoaderResources(String path) {
        void var1_1;
        return this.getResources("/WEB-INF/classes" + (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private String validate(String path) {
        void var2_2;
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardRoot.checkStateNotStarted"));
        }
        if (path == null || path.length() == 0 || !path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPath", new Object[]{path}));
        }
        String result = File.separatorChar == '\\' ? RequestUtil.normalize((String)path, (boolean)true) : RequestUtil.normalize((String)path, (boolean)false);
        if (result == null || result.length() == 0 || !result.startsWith("/")) {
            void var1_1;
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPathNormal", new Object[]{var1_1, result}));
        }
        return var2_2;
    }

    public final WebResource getTongWebResourceInternal(String path, boolean useClassLoaderResources) {
        WebResource virtual = null;
        List<WebResourceSet> mainEmpty = null;
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if ((useClassLoaderResources || webResourceSet.getClassLoaderOnly()) && (!useClassLoaderResources || webResourceSet.getStaticOnly())) continue;
                WebResource result = webResourceSet.getResource(path);
                if (result.exists()) {
                    return result;
                }
                if (virtual != null) continue;
                if (result.isVirtual()) {
                    virtual = result;
                    continue;
                }
                if (!this.main.equals(webResourceSet)) continue;
                mainEmpty = list;
            }
        }
        if (virtual != null) {
            return virtual;
        }
        return mainEmpty;
    }

    /*
     * WARNING - void declaration
     */
    public WebResource[] getResources(String path) {
        void var1_1;
        return this.getResources((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private WebResource[] getResources(String path, boolean useClassLoaderResources) {
        void var2_2;
        void var1_1;
        path = this.validate(path);
        if (this.isCachingAllowed()) {
            return this.cache.getResources(path, useClassLoaderResources);
        }
        return this.getResourcesInternal((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected WebResource[] getResourcesInternal(String path, boolean useClassLoaderResources) {
        void var3_3;
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                WebResource webResource;
                if (!useClassLoaderResources && webResourceSet.getClassLoaderOnly() || !(webResource = webResourceSet.getResource(path)).exists()) continue;
                result.add(webResource);
            }
        }
        if (result.size() == 0) {
            void var1_1;
            result.add(this.main.getResource((String)var1_1));
        }
        return var3_3.toArray(new WebResource[0]);
    }

    /*
     * WARNING - void declaration
     */
    public WebResource[] listResources(String path) {
        void var1_1;
        return this.listResources((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected WebResource[] listResources(String path, boolean validate) {
        void var3_4;
        if (validate) {
            path = this.validate(path);
        }
        String[] resources = this.list(path, false);
        WebResource[] result = new WebResource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            String string = path;
            result[i] = string.charAt(string.length() - 1) == '/' ? this.getResource(path + resources[i], false, false) : this.getResource(path + '/' + resources[i], false, false);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, URL url, String internalPath) {
        void var3_3;
        void var2_2;
        void var1_1;
        BaseLocation baseLocation = new BaseLocation(url);
        this.createWebResourceSet((WebResourceRoot.ResourceSetType)var1_1, (String)var2_2, baseLocation.getBasePath(), var3_3.getArchivePath(), internalPath);
    }

    /*
     * WARNING - void declaration
     */
    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, String base, String archivePath, String internalPath) {
        void var2_2;
        void var1_1;
        Object resourceSet;
        List<WebResourceSet> resourceList;
        switch (type) {
            case PRE: {
                resourceList = this.preResources;
                break;
            }
            case CLASSES_JAR: {
                resourceList = this.classResources;
                break;
            }
            case RESOURCE_JAR: {
                resourceList = this.jarResources;
                break;
            }
            case POST: {
                resourceList = this.postResources;
                break;
            }
            default: {
                throw new IllegalArgumentException(sm.getString("standardRoot.createUnknownType", new Object[]{type}));
            }
        }
        File file = new File(base);
        if (file.isFile()) {
            resourceSet = archivePath != null ? new JarWarResourceSet((WebResourceRoot)this, webAppMount, base, archivePath, internalPath) : (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") ? new JarResourceSet((WebResourceRoot)this, (String)resourceSet, base, internalPath) : new FileResourceSet((WebResourceRoot)this, (String)resourceSet, base, internalPath));
        } else if (file.isDirectory()) {
            void var3_3;
            resourceSet = new DirResourceSet((WebResourceRoot)this, (String)resourceSet, (String)var3_3, internalPath);
        } else {
            throw new IllegalArgumentException(sm.getString("standardRoot.createInvalidFile", new Object[]{file}));
        }
        if (type.equals((Object)WebResourceRoot.ResourceSetType.CLASSES_JAR)) {
            resourceSet.setClassLoaderOnly(true);
        } else if (var1_1.equals((Object)WebResourceRoot.ResourceSetType.RESOURCE_JAR)) {
            resourceSet.setStaticOnly(true);
        }
        resourceList.add((WebResourceSet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addPreResources(WebResourceSet webResourceSet) {
        void var1_1;
        webResourceSet.setRoot((WebResourceRoot)this);
        this.preResources.add((WebResourceSet)var1_1);
    }

    public WebResourceSet[] getPreResources() {
        return this.preResources.toArray(new WebResourceSet[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void addJarResources(WebResourceSet webResourceSet) {
        void var1_1;
        webResourceSet.setRoot((WebResourceRoot)this);
        this.jarResources.add((WebResourceSet)var1_1);
    }

    public WebResourceSet[] getJarResources() {
        return this.jarResources.toArray(new WebResourceSet[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void addPostResources(WebResourceSet webResourceSet) {
        void var1_1;
        webResourceSet.setRoot((WebResourceRoot)this);
        this.postResources.add((WebResourceSet)var1_1);
    }

    public WebResourceSet[] getPostResources() {
        return this.postResources.toArray(new WebResourceSet[0]);
    }

    protected WebResourceSet[] getClassResources() {
        return this.classResources.toArray(new WebResourceSet[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected void addClassResources(WebResourceSet webResourceSet) {
        void var1_1;
        webResourceSet.setRoot((WebResourceRoot)this);
        this.classResources.add((WebResourceSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowLinking(boolean allowLinking) {
        void var1_1;
        if (this.allowLinking != allowLinking && this.cachingAllowed) {
            this.cache.clear();
        }
        this.allowLinking = var1_1;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    /*
     * WARNING - void declaration
     */
    public void setCachingAllowed(boolean cachingAllowed) {
        void var1_1;
        this.cachingAllowed = cachingAllowed;
        if (var1_1 == false) {
            this.cache.clear();
        }
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public WebResourceRoot.CacheStrategy getCacheStrategy() {
        return this.cache.getCacheStrategy();
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheStrategy(WebResourceRoot.CacheStrategy strategy) {
        void var1_1;
        this.cache.setCacheStrategy((WebResourceRoot.CacheStrategy)var1_1);
    }

    public long getCacheTtl() {
        return this.cache.getTtl();
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheTtl(long cacheTtl) {
        void var1_1;
        this.cache.setTtl((long)var1_1);
    }

    public long getCacheMaxSize() {
        return this.cache.getMaxSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheMaxSize(long cacheMaxSize) {
        void var1_1;
        this.cache.setMaxSize((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        void var1_1;
        this.cache.setObjectMaxSize((int)var1_1);
        if (this.getState().isAvailable()) {
            this.cache.enforceObjectMaxSizeLimit();
        }
    }

    public int getCacheObjectMaxSize() {
        return this.cache.getObjectMaxSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setTrackLockedFiles(boolean trackLockedFiles) {
        void var1_1;
        this.trackLockedFiles = trackLockedFiles;
        if (var1_1 == false) {
            this.trackedResources.clear();
        }
    }

    public boolean getTrackLockedFiles() {
        return this.trackLockedFiles;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getTrackedResources() {
        void var1_1;
        ArrayList<String> result = new ArrayList<String>(this.trackedResources.size());
        for (TrackedWebResource resource : this.trackedResources) {
            void var3_3;
            result.add(var3_3.toString());
        }
        return var1_1;
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    protected void processWebInfLib() throws LifecycleException {
        WebResource[] webResourceArray = this.listResources("/WEB-INF/lib", false);
        WebResource[] webResourceArray2 = webResourceArray;
        webResourceArray2 = webResourceArray;
        int n = webResourceArray.length;
        for (int i = 0; i < n; ++i) {
            WebResource possibleJar = webResourceArray2[i];
            if (!possibleJar.isFile() || !possibleJar.getName().endsWith(".jar")) continue;
            this.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", possibleJar.getURL(), "/");
        }
    }

    public void backgroundProcess() {
        this.cache.backgroundProcess();
        this.gc();
    }

    public void gc() {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.gc();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerTrackedResource(TrackedWebResource trackedResource) {
        void var1_1;
        this.trackedResources.add((TrackedWebResource)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void deregisterTrackedResource(TrackedWebResource trackedResource) {
        void var1_1;
        this.trackedResources.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<URL> getBaseUrls() {
        void var1_1;
        ArrayList<URL> result = new ArrayList<URL>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                URL url;
                if (webResourceSet.getClassLoaderOnly() || (url = webResourceSet.getBaseUrl()) == null) continue;
                result.add(url);
            }
        }
        return var1_1;
    }

    protected boolean isPackedWarFile() {
        return this.main instanceof WarResourceSet && this.preResources.isEmpty() && this.postResources.isEmpty();
    }

    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    /*
     * WARNING - void declaration
     */
    protected String getObjectNameKeyProperties() {
        void var1_1;
        StringBuilder keyProperties = new StringBuilder("type=WebResourceRoot");
        keyProperties.append(this.context.getMBeanKeyProperties());
        return var1_1.toString();
    }

    protected void initInternal() throws LifecycleException {
        if (this.context == null) {
            throw new IllegalStateException(sm.getString("standardRoot.noContext"));
        }
        this.cacheJmxName = this.register((Object)this.cache, this.getObjectNameKeyProperties() + ",name=Cache");
        this.registerURLStreamHandlerFactory();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.init();
            }
        }
    }

    protected void registerURLStreamHandlerFactory() {
        if (!JreCompat.isGraalAvailable()) {
            TongWebURLStreamHandlerFactory.register();
        }
    }

    protected void startInternal() throws LifecycleException {
        this.mainResources.clear();
        this.main = this.createMainResourceSet();
        this.mainResources.add(this.main);
        for (List<WebResourceSet> list : this.allResources) {
            WebResourceSet webResourceSet;
            if (list == this.classResources) continue;
            for (WebResourceSet webResourceSet2 : webResourceSet) {
                webResourceSet2.start();
            }
        }
        this.processWebInfLib();
        for (WebResourceSet webResourceSet : this.classResources) {
            webResourceSet.start();
        }
        this.cache.enforceObjectMaxSizeLimit();
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - void declaration
     */
    protected WebResourceSet createMainResourceSet() {
        void var1_1;
        EmptyResourceSet mainResourceSet;
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            mainResourceSet = new EmptyResourceSet((WebResourceRoot)this);
        } else {
            File f = new File((String)mainResourceSet);
            if (!f.isAbsolute()) {
                f = new File(((Host)this.context.getParent()).getAppBaseFile(), f.getPath());
            }
            if (f.isDirectory()) {
                mainResourceSet = new DirResourceSet((WebResourceRoot)this, "/", f.getAbsolutePath(), "/");
            } else if (f.isFile() && mainResourceSet.endsWith(".war")) {
                mainResourceSet = new WarResourceSet((WebResourceRoot)this, "/", f.getAbsolutePath());
            } else {
                void var2_2;
                throw new IllegalArgumentException(sm.getString("standardRoot.startInvalidMain", new Object[]{var2_2.getAbsolutePath()}));
            }
        }
        return var1_1;
    }

    protected void stopInternal() throws LifecycleException {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.stop();
            }
        }
        if (this.main != null) {
            this.main.destroy();
        }
        this.mainResources.clear();
        for (WebResourceSet webResourceSet : this.jarResources) {
            webResourceSet.destroy();
        }
        this.jarResources.clear();
        for (WebResourceSet webResourceSet : this.classResources) {
            webResourceSet.destroy();
        }
        this.classResources.clear();
        for (TrackedWebResource trackedWebResource : this.trackedResources) {
            log.error((Object)sm.getString("standardRoot.lockedFile", new Object[]{this.context.getName(), trackedWebResource.getName()}), (Throwable)trackedWebResource.getCreatedBy());
            try {
                trackedWebResource.close();
            }
            catch (IOException iOException) {}
        }
        this.cache.clear();
        this.setState(LifecycleState.STOPPING);
    }

    protected void destroyInternal() throws LifecycleException {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.destroy();
            }
        }
        TongWebEmbedStandardRoot tongWebEmbedStandardRoot = this;
        tongWebEmbedStandardRoot.unregister(tongWebEmbedStandardRoot.cacheJmxName);
    }

    static final class BaseLocation {
        private final String basePath;
        private final String archivePath;

        /*
         * WARNING - void declaration
         */
        BaseLocation(URL url) {
            void var1_1;
            File f;
            if ("jar".equals(url.getProtocol()) || "war".equals(url.getProtocol())) {
                void var3_4;
                String jarUrl = url.toString();
                int endOfFileUrl = "jar".equals(url.getProtocol()) ? jarUrl.indexOf("!/") : jarUrl.indexOf(UriUtil.getWarSeparator());
                String fileUrl = jarUrl.substring(4, endOfFileUrl);
                try {
                    f = new File(new URL(fileUrl).toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                void startOfArchivePath = e + 2;
                this.archivePath = jarUrl.length() > startOfArchivePath ? jarUrl.substring((int)var3_4) : null;
            } else if ("file".equals(((URL)((Object)f)).getProtocol())) {
                try {
                    f = new File(((URL)((Object)f)).toURI());
                }
                catch (URISyntaxException e) {
                    void var2_3;
                    throw new IllegalArgumentException((Throwable)var2_3);
                }
                this.archivePath = null;
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.unsupportedProtocol", new Object[]{((URL)((Object)f)).getProtocol()}));
            }
            this.basePath = var1_1.getAbsolutePath();
        }

        final String getBasePath() {
            return this.basePath;
        }

        final String getArchivePath() {
            return this.archivePath;
        }
    }
}

