/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.embed;

import com.tongweb.container.Container;
import com.tongweb.container.Manager;
import com.tongweb.container.SessionIdGenerator;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.session.ManagerBase;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.v1.x.embed.LazySessionIdGenerator;
import com.tongweb.springboot.v1.x.embed.TongWebEmbedStarter;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TongwebEmbedStandardContext
extends StandardContext {
    private static final Log log = LogFactory.getLog(TongwebEmbedStandardContext.class);
    private TongWebEmbedStarter starter;
    private final boolean overrideLoadOnStart = ReflectionUtils.findMethod(StandardContext.class, (String)"loadOnStartup", (Class[])new Class[]{Container[].class}).getReturnType() == Boolean.TYPE;

    TongwebEmbedStandardContext() {
    }

    /*
     * WARNING - void declaration
     */
    public boolean loadOnStartup(Container[] children) {
        void var1_1;
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup((Container[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setManager(Manager manager) {
        void var1_1;
        if (manager instanceof ManagerBase) {
            manager.setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager((Manager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            void var1_1;
            existingLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)var1_1);
        }
        if (this.overrideLoadOnStart) {
            TongwebEmbedStandardContext tongwebEmbedStandardContext = this;
            super.loadOnStartup(tongwebEmbedStandardContext.findChildren());
        }
        if (existingLoader != null) {
            void var2_2;
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setStarter(TongWebEmbedStarter starter) {
        void var1_1;
        this.starter = var1_1;
    }

    public final TongWebEmbedStarter getStarter() {
        return this.starter;
    }

    public final void preLoadStaticResources() {
        File dir;
        TongwebEmbedStandardContext tongwebEmbedStandardContext = this;
        Object object = ((Object)((Object)tongwebEmbedStandardContext)).getClass().getClassLoader();
        Object object2 = new ArrayList<URL>();
        if (object instanceof URLClassLoader) {
            for (URL uRL : ((URLClassLoader)object).getURLs()) {
                if (!tongwebEmbedStandardContext.isStaticResourceJar(uRL)) continue;
                log.info((Object)("load static resource " + uRL.toString()));
                object2.add(uRL);
            }
        }
        tongwebEmbedStandardContext.addResourceJars((List<URL>)object2);
        tongwebEmbedStandardContext = this;
        object2 = ".jar";
        object = tongwebEmbedStandardContext;
        TongwebEmbedStandardContext tongwebEmbedStandardContext2 = tongwebEmbedStandardContext;
        object = TongwebEmbedStandardContext.getCodeSourceArchive(((Object)((Object)tongwebEmbedStandardContext)).getClass().getProtectionDomain().getCodeSource());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Code archive: " + object));
        }
        if ((dir = object != null && ((File)object).exists() && !((File)object).isDirectory() && ((File)object).getName().toLowerCase(Locale.ENGLISH).endsWith((String)object2) ? ((File)object).getAbsoluteFile() : null) != null && this.getResources() != null) {
            this.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", ((File)((Object)tongwebEmbedStandardContext)).getAbsolutePath(), null, "/META-INF/resources");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStaticResourceJar(URL url) {
        try {
            File file;
            if ("file".equals(url.getProtocol())) {
                file = new File(url.toURI());
                return file.isDirectory() && new File(file, "META-INF/resources").isDirectory() || this.isResourcesJar(file);
            }
            URLConnection connection = ((URL)((Object)file)).openConnection();
            if (connection instanceof JarURLConnection && this.isResourcesJar((JarURLConnection)connection)) {
                return true;
            }
        }
        catch (Exception ex) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isResourcesJar(File file) {
        try {
            return file.getName().endsWith(".jar") && TongwebEmbedStandardContext.isResourcesJar(new JarFile(file));
        }
        catch (IOException ex) {
            void var2_2;
            void var1_1;
            log.warn((Object)("Unable to open jar '" + var1_1 + "' to determine if it contains static resources"), (Throwable)var2_2);
            return false;
        }
    }

    private static boolean isResourcesJar(JarFile jar) throws IOException {
        boolean bl;
        try {
            bl = jar.getJarEntry("META-INF/resources") != null || jar.getJarEntry("BOOT-INF/lib") != null;
        }
        catch (Throwable throwable) {
            JarFile jarFile;
            jarFile.close();
            throw throwable;
        }
        jar.close();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isResourcesJar(JarURLConnection connection) {
        try {
            return TongwebEmbedStandardContext.isResourcesJar(connection.getJarFile());
        }
        catch (IOException ex) {
            void var2_2;
            void var1_1;
            log.warn((Object)("Unable to open jar from connection '" + var1_1 + "' to determine if it contains static resources"), (Throwable)var2_2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File getCodeSourceArchive(CodeSource codeSource) {
        try {
            URL uRL;
            URL path;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            path = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().getName() : path.toURI().getPath();
            int index = ((String)((Object)path)).indexOf("!/");
            if (index != -1) {
                void var1_2;
                path = ((String)((Object)path)).substring(0, (int)var1_2);
            }
            return new File((String)((Object)uRL));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addResourceJars(List<URL> resourceJarUrls) {
        for (URL url : resourceJarUrls) {
            void var2_2;
            void var3_3;
            String path = url.getPath();
            if (path.endsWith(".jar") || var3_3.endsWith(".jar!/")) {
                String jar = url.toString();
                if (!jar.startsWith("jar:")) {
                    jar = "jar:" + jar + "!/";
                }
                this.addResourceSet((String)var2_2);
                continue;
            }
            this.addResourceSet(var2_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addResourceSet(String resource) {
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            if (TongwebEmbedStandardContext.isInsideNestedJar(resource)) {
                resource = resource.substring(0, resource.length() - 2);
            }
            URL url = new URL(resource);
            String path = "/META-INF/resources";
            log.info((Object)("add resource set " + (String)var1_1));
            this.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", (URL)var2_2, (String)var3_3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static boolean isInsideNestedJar(String dir) {
        String string;
        return dir.indexOf("!/") < string.lastIndexOf("!/");
    }
}

