/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.spring;

import com.tongweb.springboot.v1.x.spring.DataUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class DataSize
implements Comparable<DataSize> {
    private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private final long bytes;

    /*
     * WARNING - void declaration
     */
    private DataSize(long bytes) {
        void var1_1;
        this.bytes = var1_1;
    }

    public static DataSize ofBytes(long bytes) {
        long l;
        return new DataSize(l);
    }

    public static DataSize ofKilobytes(long kilobytes) {
        long l;
        return new DataSize(Math.multiplyExact(l, 1024L));
    }

    public static DataSize ofMegabytes(long megabytes) {
        long l;
        return new DataSize(Math.multiplyExact(l, 0x100000L));
    }

    public static DataSize ofGigabytes(long gigabytes) {
        long l;
        return new DataSize(Math.multiplyExact(l, 0x40000000L));
    }

    public static DataSize ofTerabytes(long terabytes) {
        long l;
        return new DataSize(Math.multiplyExact(l, 0x10000000000L));
    }

    /*
     * WARNING - void declaration
     */
    public static DataSize of(long amount, DataUnit unit) {
        void var2_1;
        long l;
        Assert.notNull((Object)((Object)unit), (String)"Unit must not be null");
        return new DataSize(Math.multiplyExact(l, var2_1.size().toBytes()));
    }

    public static DataSize parse(CharSequence text) {
        return DataSize.parse(text, null);
    }

    /*
     * WARNING - void declaration
     */
    public static DataSize parse(CharSequence text, DataUnit defaultUnit) {
        Assert.notNull((Object)text, (String)"Text must not be null");
        try {
            void var1_1;
            Matcher matcher = PATTERN.matcher(text);
            Assert.state((boolean)matcher.matches(), (String)"Does not match data size pattern");
            DataUnit unit = DataSize.determineDataUnit(matcher.group(2), defaultUnit);
            long l = Long.parseLong(matcher.group(1));
            return DataSize.of(l, (DataUnit)var1_1);
        }
        catch (Exception ex) {
            void var2_3;
            CharSequence charSequence;
            throw new IllegalArgumentException("'" + charSequence + "' is not a valid data size", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DataUnit determineDataUnit(String suffix, DataUnit defaultUnit) {
        void var1_1;
        DataUnit defaultUnitToUse;
        DataUnit dataUnit = defaultUnitToUse = defaultUnit != null ? defaultUnit : DataUnit.BYTES;
        if (StringUtils.hasLength((String)suffix)) {
            String string;
            return DataUnit.fromSuffix(string);
        }
        return var1_1;
    }

    public final boolean isNegative() {
        return this.bytes < 0L;
    }

    public final long toBytes() {
        return this.bytes;
    }

    public final long toKilobytes() {
        return this.bytes / 1024L;
    }

    public final long toMegabytes() {
        return this.bytes / 0x100000L;
    }

    public final long toGigabytes() {
        return this.bytes / 0x40000000L;
    }

    public final long toTerabytes() {
        return this.bytes / 0x10000000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(DataSize other) {
        void var1_1;
        return Long.compare(this.bytes, var1_1.bytes);
    }

    public final String toString() {
        return String.format("%dB", this.bytes);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataSize otherSize = (DataSize)other;
        return this.bytes == var1_1.bytes;
    }

    public final int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

