/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.tianfu.HdrHistogram;

import com.tongweb.tianfu.HdrHistogram.Histogram;
import com.tongweb.tianfu.HdrHistogram.ValueRecorder;
import com.tongweb.tianfu.HdrHistogram.WriterReaderPhaser;
import java.util.concurrent.atomic.AtomicLong;

public class SingleWriterRecorder
implements ValueRecorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile InternalHistogram activeHistogram;
    private InternalHistogram inactiveHistogram;

    public SingleWriterRecorder(int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalHistogram(this.instanceId, numberOfSignificantValueDigits);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    public SingleWriterRecorder(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SingleWriterRecorder(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalHistogram(this.instanceId, lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValue(long value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithCount(value, count);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized Histogram getIntervalHistogram() {
        return this.getIntervalHistogram(null);
    }

    public synchronized Histogram getIntervalHistogram(Histogram histogramToRecycle) {
        return this.getIntervalHistogram(histogramToRecycle, true);
    }

    public synchronized Histogram getIntervalHistogram(Histogram histogramToRecycle, boolean enforeContainingInstance) {
        this.validateFitAsReplacementHistogram(histogramToRecycle, enforeContainingInstance);
        this.inactiveHistogram = (InternalHistogram)histogramToRecycle;
        this.performIntervalSample();
        InternalHistogram sampledHistogram = this.inactiveHistogram;
        this.inactiveHistogram = null;
        return sampledHistogram;
    }

    public synchronized void getIntervalHistogramInto(Histogram targetHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(targetHistogram);
    }

    @Override
    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        try {
            this.recordingPhaser.readerLock();
            if (this.inactiveHistogram == null) {
                this.inactiveHistogram = new InternalHistogram(this.activeHistogram);
            }
            this.inactiveHistogram.reset();
            InternalHistogram tempHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = tempHistogram;
            long now = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(now);
            this.inactiveHistogram.setEndTimeStamp(now);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private void validateFitAsReplacementHistogram(Histogram replacementHistogram, boolean enforeContainingInstance) {
        boolean bad = true;
        if (replacementHistogram == null) {
            bad = false;
        } else if (replacementHistogram instanceof InternalHistogram && (!enforeContainingInstance || ((InternalHistogram)replacementHistogram).containingInstanceId == this.activeHistogram.containingInstanceId)) {
            bad = false;
        }
        if (bad) {
            throw new IllegalArgumentException("replacement histogram must have been obtained via a previous getIntervalHistogram() call from this " + this.getClass().getName() + (enforeContainingInstance ? " insatnce" : " class"));
        }
    }

    private class InternalHistogram
    extends Histogram {
        private final long containingInstanceId;

        private InternalHistogram(long id, int numberOfSignificantValueDigits) {
            super(numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }

        private InternalHistogram(long id, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
            super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }

        private InternalHistogram(InternalHistogram source) {
            super(source);
            this.containingInstanceId = source.containingInstanceId;
        }
    }
}

