/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket.pojo;

import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.websocket.Util;
import javax.websocket.DeploymentException;

public class PojoPathParam {
    private static final StringManager sm = StringManager.getManager(PojoPathParam.class);
    private final Class<?> type;
    private final String name;

    public PojoPathParam(Class<?> type, String name) throws DeploymentException {
        if (name != null) {
            PojoPathParam.validateType(type);
        }
        this.type = type;
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    private static void validateType(Class<?> type) throws DeploymentException {
        if (String.class == type) {
            return;
        }
        if (Util.isPrimitive(type)) {
            return;
        }
        throw new DeploymentException(sm.getString("pojoPathParam.wrongType", new Object[]{type.getName()}));
    }
}

