/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.streamhtmlparser.impl;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;

class InternalState {
    static final InternalState INTERNAL_ERROR_STATE = new InternalState();
    private static final int MAX_ID = 255;
    private static final int FIRST_ID = 1;
    private static AtomicInteger htmlStates = new AtomicInteger(1);
    private static AtomicInteger javascriptStates = new AtomicInteger(1);
    private final String name;
    private final int id;

    private InternalState(String name, int id) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((id >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((id <= 255 ? 1 : 0) != 0);
        this.name = name;
        this.id = id;
    }

    private InternalState() {
        this.name = "InternalStateError";
        this.id = 0;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.format("InternalState: Name: %s; Id: %d", this.name, this.id);
    }

    static InternalState getInstanceHtml(String name) {
        int htmlStateId = htmlStates.getAndIncrement();
        return new InternalState(name, htmlStateId);
    }

    static InternalState getInstanceJavascript(String name) {
        int javascriptStateId = javascriptStates.getAndIncrement();
        return new InternalState(name, javascriptStateId);
    }
}

