/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.exceptions;

import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.DataException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FailedPropertiesReason;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.support.exceptions.IntegrityConstraintViolationException;
import com.vertica.support.exceptions.InvalidAuthorizationException;
import com.vertica.support.exceptions.NonTransientConnectionException;
import com.vertica.support.exceptions.NonTransientException;
import com.vertica.support.exceptions.RecoverableException;
import com.vertica.support.exceptions.SyntaxErrorException;
import com.vertica.support.exceptions.TimeOutException;
import com.vertica.support.exceptions.TransactionRollbackException;
import com.vertica.support.exceptions.TransientConnectionException;
import com.vertica.support.exceptions.TransientException;
import java.util.Map;

public class ExceptionBuilder {
    private int m_componentId = 0;

    public ExceptionBuilder(int componentId) {
        this.m_componentId = componentId;
    }

    public ErrorException createClientInfoException(String msgKey, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, msgKey, failures);
    }

    public <e> ErrorException createClientInfoException(Enum<?> e, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, e.name(), failures);
    }

    public ErrorException createCustomException(String customState, String msgKey) {
        return this.createCustomErrorException(customState, msgKey, null, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e) {
        return this.createCustomErrorException(customState, e.name(), null, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, null, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), null, null, exceptionType);
    }

    public ErrorException createCustomException(String customState, String msgKey, String msgParam) {
        return this.createCustomErrorException(customState, msgKey, new String[]{msgParam}, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String msgParam) {
        return this.createCustomErrorException(customState, e.name(), new String[]{msgParam}, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, String msgParam, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, new String[]{msgParam}, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String msgParam, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), new String[]{msgParam}, null, exceptionType);
    }

    public ErrorException createClientInfoException(String msgKey, String msgParam, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, msgKey, new String[]{msgParam}, failures);
    }

    public <e> ErrorException createClientInfoException(Enum<?> e, String msgParam, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, e.name(), new String[]{msgParam}, failures);
    }

    public ErrorException createClientInfoException(String msgKey, String[] msgParams, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, msgKey, msgParams, failures);
    }

    public <e> ErrorException createClientInfoException(Enum<?> e, String[] msgParams, Map<String, FailedPropertiesReason> failures) {
        return new ClientInfoException(this.m_componentId, e.name(), msgParams, failures);
    }

    public ErrorException createCustomException(String customState, String msgKey, String[] msgParams) {
        return this.createCustomErrorException(customState, msgKey, msgParams, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String[] msgParams) {
        return this.createCustomErrorException(customState, e.name(), msgParams, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, String[] msgParams, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, msgParams, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String[] msgParams, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), msgParams, null, exceptionType);
    }

    public ErrorException createCustomException(String customState, String msgKey, Throwable cause) {
        return this.createCustomErrorException(customState, msgKey, null, cause, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, Throwable cause) {
        return this.createCustomErrorException(customState, e.name(), null, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, null, cause, exceptionType);
    }

    public ErrorException createCustomException(String customState, Enum<?> e, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), null, cause, exceptionType);
    }

    public ErrorException createCustomException(String customState, String msgKey, String msgParam, Throwable cause) {
        return this.createCustomErrorException(customState, msgKey, new String[]{msgParam}, cause, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String msgParam, Throwable cause) {
        return this.createCustomErrorException(customState, e.name(), new String[]{msgParam}, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, String msgParam, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, new String[]{msgParam}, cause, exceptionType);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String msgParam, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), new String[]{msgParam}, cause, exceptionType);
    }

    public ErrorException createCustomException(String customState, String msgKey, String[] msgParams, Throwable cause) {
        return this.createCustomErrorException(customState, msgKey, msgParams, cause, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String[] msgParams, Throwable cause) {
        return this.createCustomErrorException(customState, e.name(), msgParams, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String customState, String msgKey, String[] msgParams, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, msgKey, msgParams, cause, exceptionType);
    }

    public <e> ErrorException createCustomException(String customState, Enum<?> e, String[] msgParams, Throwable cause, ExceptionType exceptionType) {
        return this.createCustomErrorException(customState, e.name(), msgParams, cause, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey) {
        return this.createException(msgKey, null, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> e) {
        return this.createException(e.name(), null, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, ExceptionType exceptionType) {
        return this.createException(msgKey, null, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, ExceptionType exceptionType) {
        return this.createException(e.name(), null, null, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey, String argument) {
        return this.createException(msgKey, new String[]{argument}, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String argument) {
        return this.createException(e.name(), new String[]{argument}, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, String argument, ExceptionType exceptionType) {
        return this.createException(msgKey, new String[]{argument}, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String argument, ExceptionType exceptionType) {
        return this.createException(e.name(), new String[]{argument}, null, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey, String[] arguments) {
        return this.createException(msgKey, arguments, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String[] arguments) {
        return this.createException(e.name(), arguments, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, String[] arguments, ExceptionType exceptionType) {
        return this.createException(msgKey, arguments, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String[] arguments, ExceptionType exceptionType) {
        return this.createException(e.name(), arguments, null, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey, String argument, Throwable cause) {
        return this.createException(msgKey, new String[]{argument}, cause, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String argument, Throwable cause) {
        return this.createException(e.name(), new String[]{argument}, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, String argument, Throwable cause, ExceptionType exceptionType) {
        return this.createException(msgKey, new String[]{argument}, cause, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String argument, Throwable cause, ExceptionType exceptionType) {
        return this.createException(e.name(), new String[]{argument}, cause, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey, String[] arguments, Throwable cause) {
        return this.createException(msgKey, arguments, cause, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String[] arguments, Throwable cause) {
        return this.createException(e.name(), arguments, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        return this.createException(msgKey, arguments, cause, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        return this.createException(e.name(), arguments, cause, exceptionType);
    }

    public ErrorException createGeneralException(String msgKey, Throwable cause) {
        return this.createException(msgKey, null, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(Enum<?> e, Throwable cause) {
        return this.createException(e.name(), null, cause, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String msgKey, Throwable cause, ExceptionType exceptionType) {
        return this.createException(msgKey, null, cause, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> e, Throwable cause, ExceptionType exceptionType) {
        return this.createException(e.name(), null, cause, exceptionType);
    }

    private ErrorException createException(String msgKey, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        StackTraceElement[] sourceStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[sourceStackTrace.length - 4];
        System.arraycopy(sourceStackTrace, 3, stackTrace, 0, stackTrace.length);
        ErrorException ge = null;
        ge = null == arguments ? (null == cause ? this.generateException(msgKey, exceptionType) : this.generateException(msgKey, cause, exceptionType)) : (null == cause ? this.generateException(msgKey, arguments, exceptionType) : this.generateException(msgKey, arguments, cause, exceptionType));
        ge.setStackTrace(stackTrace);
        return ge;
    }

    private ErrorException createCustomErrorException(String customState, String msgKey, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        StackTraceElement[] sourceStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[sourceStackTrace.length - 4];
        System.arraycopy(sourceStackTrace, 3, stackTrace, 0, stackTrace.length);
        ErrorException ex = null;
        ex = null == arguments ? (null == cause ? this.generateException(customState, msgKey, exceptionType) : this.generateException(customState, msgKey, cause, exceptionType)) : (null == cause ? this.generateException(customState, msgKey, arguments, exceptionType) : this.generateException(customState, msgKey, arguments, cause, exceptionType));
        ex.setStackTrace(stackTrace);
        return ex;
    }

    private ErrorException generateException(String msgKey, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, msgKey, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, msgKey);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, msgKey);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, msgKey);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, msgKey);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, msgKey);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, msgKey);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, msgKey);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, msgKey);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, msgKey);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, msgKey);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, msgKey);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, msgKey);
            }
        }
        return new GeneralException(this.m_componentId, msgKey);
    }

    private ErrorException generateException(String msgKey, String[] arguments, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, msgKey, arguments, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, msgKey, arguments);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, msgKey, arguments);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, msgKey, arguments);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, msgKey, arguments);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, msgKey, arguments);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, msgKey, arguments);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, msgKey, arguments);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, msgKey, arguments);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, msgKey, arguments);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, msgKey, arguments);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, msgKey, arguments);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, msgKey, arguments);
            }
        }
        return new GeneralException(this.m_componentId, msgKey, arguments);
    }

    private ErrorException generateException(String msgKey, Throwable cause, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, msgKey, cause, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, msgKey, cause);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, msgKey, cause);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, msgKey, cause);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, msgKey, cause);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, msgKey, cause);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, msgKey, cause);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, msgKey, cause);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, msgKey, cause);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, msgKey, cause);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, msgKey, cause);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, msgKey, cause);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, msgKey, cause);
            }
        }
        return new GeneralException(this.m_componentId, msgKey, cause);
    }

    private ErrorException generateException(String msgKey, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, msgKey, arguments, cause, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, msgKey, arguments, cause);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, msgKey, arguments, cause);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, msgKey, arguments, cause);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, msgKey, arguments, cause);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, msgKey, arguments, cause);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, msgKey, arguments, cause);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, msgKey, arguments, cause);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, msgKey, arguments, cause);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, msgKey, arguments, cause);
            }
        }
        return new GeneralException(this.m_componentId, msgKey, arguments, cause);
    }

    private ErrorException generateException(String customState, String msgKey, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(customState, this.m_componentId, msgKey, null);
            }
            case DATA: {
                return new DataException(customState, this.m_componentId, msgKey);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(customState, this.m_componentId, msgKey);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(customState, this.m_componentId, msgKey);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(customState, this.m_componentId, msgKey);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(customState, this.m_componentId, msgKey);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(customState, this.m_componentId, msgKey);
            }
            case RECOVERABLE: {
                return new RecoverableException(customState, this.m_componentId, msgKey);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(customState, this.m_componentId, msgKey);
            }
            case TIME_OUT: {
                return new TimeOutException(customState, this.m_componentId, msgKey);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(customState, this.m_componentId, msgKey);
            }
            case TRANSIENT: {
                return new TransientException(customState, this.m_componentId, msgKey);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(customState, this.m_componentId, msgKey);
            }
        }
        return new ErrorException(customState, this.m_componentId, msgKey);
    }

    private ErrorException generateException(String customState, String msgKey, String[] arguments, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(customState, this.m_componentId, msgKey, arguments, null);
            }
            case DATA: {
                return new DataException(customState, this.m_componentId, msgKey, arguments);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(customState, this.m_componentId, msgKey, arguments);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(customState, this.m_componentId, msgKey, arguments);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(customState, this.m_componentId, msgKey, arguments);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(customState, this.m_componentId, msgKey, arguments);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(customState, this.m_componentId, msgKey, arguments);
            }
            case RECOVERABLE: {
                return new RecoverableException(customState, this.m_componentId, msgKey, arguments);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(customState, this.m_componentId, msgKey, arguments);
            }
            case TIME_OUT: {
                return new TimeOutException(customState, this.m_componentId, msgKey, arguments);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(customState, this.m_componentId, msgKey, arguments);
            }
            case TRANSIENT: {
                return new TransientException(customState, this.m_componentId, msgKey, arguments);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(customState, this.m_componentId, msgKey, arguments);
            }
        }
        return new ErrorException(customState, this.m_componentId, msgKey, arguments);
    }

    private ErrorException generateException(String customState, String msgKey, Throwable cause, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(customState, this.m_componentId, msgKey, cause, null);
            }
            case DATA: {
                return new DataException(customState, this.m_componentId, msgKey, cause);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(customState, this.m_componentId, msgKey, cause);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(customState, this.m_componentId, msgKey, cause);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(customState, this.m_componentId, msgKey, cause);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(customState, this.m_componentId, msgKey, cause);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(customState, this.m_componentId, msgKey, cause);
            }
            case RECOVERABLE: {
                return new RecoverableException(customState, this.m_componentId, msgKey, cause);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(customState, this.m_componentId, msgKey, cause);
            }
            case TIME_OUT: {
                return new TimeOutException(customState, this.m_componentId, msgKey, cause);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(customState, this.m_componentId, msgKey, cause);
            }
            case TRANSIENT: {
                return new TransientException(customState, this.m_componentId, msgKey, cause);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(customState, this.m_componentId, msgKey, cause);
            }
        }
        return new ErrorException(customState, this.m_componentId, msgKey, cause);
    }

    private ErrorException generateException(String customState, String msgKey, String[] arguments, Throwable cause, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(customState, this.m_componentId, msgKey, arguments, cause, null);
            }
            case DATA: {
                return new DataException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case RECOVERABLE: {
                return new RecoverableException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case TIME_OUT: {
                return new TimeOutException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSIENT: {
                return new TransientException(customState, this.m_componentId, msgKey, arguments, cause);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(customState, this.m_componentId, msgKey, arguments, cause);
            }
        }
        return new ErrorException(customState, this.m_componentId, msgKey, arguments, cause);
    }
}

