/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities.conversion;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.InvalidArgumentException;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;

public class IntervalConverter {
    private static final char DAY_HOUR_SEPARATOR = ' ';
    private static final char HOUR_MINUTE_SECOND_SEPARATOR = ':';
    private static final char SECOND_FRACTION_SEPARATOR = '.';
    private static final char YEAR_MONTH_SEPARATOR = '-';
    private static final char MINUS_SIGN = '-';
    private static final char ZERO_DIGIT = '0';
    private static final int INTERVAL_LEADING_PRECISION = 9;
    private static final short INTERVAL_FRACTIONAL_PRECISION = 9;
    private static boolean s_isLeadingFieldPadded;
    static final String[] ZERO_BUFFER;
    private static final int MONTHS_PER_YEAR = 12;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    public static String convertIntervalDayToHourToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(16);
        IntervalConverter.formatLeadingField(builder, span.getDay(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(' ');
        int hour = span.getHour();
        builder.append((char)(48 + hour / 10));
        builder.append((char)(48 + hour % 10));
        return builder.toString();
    }

    public static String convertIntervalDayToMinuteToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(19);
        IntervalConverter.formatLeadingField(builder, span.getDay(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(' ');
        int hour = span.getHour();
        builder.append((char)(48 + hour / 10));
        builder.append((char)(48 + hour % 10));
        builder.append(':');
        int minute = span.getMinute();
        builder.append((char)(48 + minute / 10));
        builder.append((char)(48 + minute % 10));
        return builder.toString();
    }

    public static String convertIntervalDayToSecondToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(30);
        IntervalConverter.formatLeadingField(builder, span.getDay(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(' ');
        int hour = span.getHour();
        builder.append((char)(48 + hour / 10));
        builder.append((char)(48 + hour % 10));
        builder.append(':');
        int minute = span.getMinute();
        builder.append((char)(48 + minute / 10));
        builder.append((char)(48 + minute % 10));
        builder.append(':');
        int second = span.getSecond();
        builder.append((char)(48 + second / 10));
        builder.append((char)(48 + second % 10));
        IntervalConverter.formatFractionField(builder, span.getFraction(), meta.isIntervalType() ? (short)meta.getPrecision() : (short)9);
        return builder.toString();
    }

    public static String convertIntervalDayToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(builder, span.getDay(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        return builder.toString();
    }

    public static String convertIntervalHourToMinuteToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(13);
        IntervalConverter.formatLeadingField(builder, span.getHour(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(':');
        int minute = span.getMinute();
        builder.append((char)(48 + minute / 10));
        builder.append((char)(48 + minute % 10));
        return builder.toString();
    }

    public static String convertIntervalHourToSecondToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(26);
        IntervalConverter.formatLeadingField(builder, span.getHour(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(':');
        int minute = span.getMinute();
        builder.append((char)(48 + minute / 10));
        builder.append((char)(48 + minute % 10));
        builder.append(':');
        int second = span.getSecond();
        builder.append((char)(48 + second / 10));
        builder.append((char)(48 + second % 10));
        IntervalConverter.formatFractionField(builder, span.getFraction(), meta.isIntervalType() ? (short)meta.getPrecision() : (short)9);
        return builder.toString();
    }

    public static String convertIntervalHourToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(builder, span.getHour(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        return builder.toString();
    }

    public static String convertIntervalMinuteToSecondToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(22);
        IntervalConverter.formatLeadingField(builder, span.getMinute(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append(':');
        int second = span.getSecond();
        builder.append((char)(48 + second / 10));
        builder.append((char)(48 + second % 10));
        IntervalConverter.formatFractionField(builder, span.getFraction(), meta.isIntervalType() ? (short)meta.getPrecision() : (short)9);
        return builder.toString();
    }

    public static String convertIntervalMinuteToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(builder, span.getMinute(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        return builder.toString();
    }

    public static String convertIntervalMonthToString(Object value, TypeMetadata meta) {
        DSIMonthSpan span = (DSIMonthSpan)value;
        StringBuilder builder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(builder, span.getMonth(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        return builder.toString();
    }

    public static String convertIntervalSecondToString(Object value, TypeMetadata meta) {
        DSITimeSpan span = (DSITimeSpan)value;
        StringBuilder builder = new StringBuilder(20);
        IntervalConverter.formatLeadingField(builder, span.getSecond(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        IntervalConverter.formatFractionField(builder, span.getFraction(), meta.isIntervalType() ? (short)meta.getPrecision() : (short)9);
        return builder.toString();
    }

    public static String convertIntervalToString(Object value, TypeMetadata meta) {
        String str = null;
        switch (meta.getType()) {
            case 103: {
                str = IntervalConverter.convertIntervalDayToString(value, meta);
                break;
            }
            case 108: {
                str = IntervalConverter.convertIntervalDayToHourToString(value, meta);
                break;
            }
            case 109: {
                str = IntervalConverter.convertIntervalDayToMinuteToString(value, meta);
                break;
            }
            case 110: {
                str = IntervalConverter.convertIntervalDayToSecondToString(value, meta);
                break;
            }
            case 104: {
                str = IntervalConverter.convertIntervalHourToString(value, meta);
                break;
            }
            case 111: {
                str = IntervalConverter.convertIntervalHourToMinuteToString(value, meta);
                break;
            }
            case 112: {
                str = IntervalConverter.convertIntervalHourToSecondToString(value, meta);
                break;
            }
            case 105: {
                str = IntervalConverter.convertIntervalMinuteToString(value, meta);
                break;
            }
            case 113: {
                str = IntervalConverter.convertIntervalMinuteToSecondToString(value, meta);
                break;
            }
            case 102: {
                str = IntervalConverter.convertIntervalMonthToString(value, meta);
                break;
            }
            case 106: {
                str = IntervalConverter.convertIntervalSecondToString(value, meta);
                break;
            }
            case 101: {
                str = IntervalConverter.convertIntervalYearToString(value, meta);
                break;
            }
            case 107: {
                str = IntervalConverter.convertIntervalYearToMonthToString(value, meta);
                break;
            }
            default: {
                throw new InvalidArgumentException(1, JDBCMessageKey.INVALID_INTERVAL_DATA_TYPE.name(), null);
            }
        }
        return str;
    }

    public static String convertIntervalYearToMonthToString(Object value, TypeMetadata meta) {
        DSIMonthSpan span = (DSIMonthSpan)value;
        StringBuilder builder = new StringBuilder(13);
        IntervalConverter.formatLeadingField(builder, span.getYear(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        builder.append('-');
        int month = span.getMonth();
        builder.append((char)(48 + month / 10));
        builder.append((char)(48 + month % 10));
        return builder.toString();
    }

    public static String convertIntervalYearToString(Object value, TypeMetadata meta) {
        DSIMonthSpan span = (DSIMonthSpan)value;
        StringBuilder builder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(builder, span.getYear(), span.isNegative(), meta.isIntervalType() ? (long)meta.getIntervalPrecision() : 9L);
        return builder.toString();
    }

    public static Object convertStringToInterval(String value, TypeMetadata meta, IWarningListener warningListener) {
        value = value.trim();
        switch (meta.getType()) {
            case 102: {
                return IntervalConverter.stringToIntervalMonth(value, meta, warningListener);
            }
            case 101: {
                return IntervalConverter.stringToIntervalYear(value, meta, warningListener);
            }
            case 107: {
                return IntervalConverter.stringToIntervalYearMonth(value, meta, warningListener);
            }
            case 103: {
                return IntervalConverter.stringToIntervalDay(value, meta, warningListener);
            }
            case 108: {
                return IntervalConverter.stringToIntervalDayToHour(value, meta, warningListener);
            }
            case 109: {
                return IntervalConverter.stringToIntervalDayToMinute(value, meta, warningListener);
            }
            case 110: {
                return IntervalConverter.stringToIntervalDayToSecond(value, meta, warningListener);
            }
            case 104: {
                return IntervalConverter.stringToIntervalHour(value, meta, warningListener);
            }
            case 111: {
                return IntervalConverter.stringToIntervalHourToMinute(value, meta, warningListener);
            }
            case 112: {
                return IntervalConverter.stringToIntervalHourToSecond(value, meta, warningListener);
            }
            case 105: {
                return IntervalConverter.stringToIntervalMinute(value, meta, warningListener);
            }
            case 113: {
                return IntervalConverter.stringToIntervalMinuteToSecond(value, meta, warningListener);
            }
            case 106: {
                return IntervalConverter.stringToIntervalSecond(value, meta, warningListener);
            }
        }
        throw new InvalidArgumentException(1, JDBCMessageKey.INVALID_INTERVAL_DATA_TYPE.name(), null);
    }

    private static void checkLeadingField(int leadingField, int intervalPrecision) {
        int numDigits = 0;
        if (leadingField < 100000) {
            numDigits = leadingField < 100 ? (leadingField < 10 ? 1 : 2) : (leadingField < 1000 ? 3 : (leadingField < 10000 ? 4 : 5));
        } else if (leadingField < 10000000) {
            numDigits = leadingField < 1000000 ? 6 : 7;
        } else {
            int n = leadingField < 100000000 ? 8 : (numDigits = leadingField < 1000000000 ? 9 : 10);
        }
        if (numDigits > intervalPrecision) {
            throw new InvalidArgumentException(1, JDBCMessageKey.INTERVAL_FIELD_OVERFLOW.name(), null);
        }
    }

    private static IllegalArgumentException createException(JDBCMessageKey key, String value, IWarningListener warningListener) {
        return new IllegalArgumentException(JDBCMessageBuilder.getMessage(key, warningListener, value));
    }

    private static void formatFractionField(StringBuilder builder, int fraction, short precision) {
        if (0 < precision) {
            builder.append('.');
            int index = precision;
            StringBuilder fracBuilder = new StringBuilder("000000000");
            while (index > 0) {
                fracBuilder.setCharAt(--index, (char)(48 + fraction % 10));
                fraction /= 10;
            }
            if (fraction > 0) {
                throw new InvalidArgumentException(1, JDBCMessageKey.INTERVAL_FIELD_OVERFLOW.name(), null);
            }
            builder.append(fracBuilder.substring(0, precision));
        }
    }

    private static void formatLeadingField(StringBuilder builder, int value, boolean isNegative, long leadingPrecision) {
        if (isNegative) {
            builder.append('-');
        }
        if (s_isLeadingFieldPadded) {
            String str = Integer.toString(value);
            builder.append(ZERO_BUFFER[(int)leadingPrecision - str.length()]);
            builder.append(str);
        } else {
            builder.append(value);
        }
    }

    private static int getFractionField(String str, short precision, IWarningListener warningListener) {
        int fraction = 0;
        if (0 < precision) {
            int length = str.length();
            if (length == precision) {
                fraction = Integer.valueOf(str);
            } else if (length > precision) {
                fraction = Integer.valueOf(str.substring(0, precision));
                if (0 != Integer.valueOf(str.substring(precision))) {
                    warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
                }
            } else {
                int digitsToAdd = precision - length;
                fraction = Integer.valueOf(str);
                while (digitsToAdd-- > 0) {
                    fraction *= 10;
                }
            }
        }
        return fraction;
    }

    private static DaySecondValue stringToDaySecondValue(String value, TypeMetadata meta, IWarningListener warningListener, JDBCMessageKey messageKey) {
        if (0 == value.length()) {
            throw IntervalConverter.createException(messageKey, value, warningListener);
        }
        DaySecondValue dsValue = new DaySecondValue();
        int index = 0;
        int strLength = value.length();
        if ('-' == value.charAt(0)) {
            dsValue.m_isNegative = true;
            ++index;
        }
        while (index < strLength && Character.isDigit(value.charAt(index))) {
            ++index;
        }
        int leadingTerminatorIndex = index;
        IntervalFieldType indicator = IntervalFieldType.DAY;
        if (index < strLength) {
            switch (value.charAt(index)) {
                case ' ': {
                    indicator = IntervalFieldType.DAY;
                    break;
                }
                case ':': {
                    ++index;
                    while (index < strLength && Character.isDigit(value.charAt(index))) {
                        ++index;
                    }
                    if (index < strLength && '.' == value.charAt(index)) {
                        indicator = IntervalFieldType.MINUTE;
                        break;
                    }
                    indicator = IntervalFieldType.HOUR;
                    break;
                }
                case '.': {
                    indicator = IntervalFieldType.SECOND;
                    break;
                }
                default: {
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
            }
        }
        boolean hasLeadingField = false;
        int n = index = dsValue.m_isNegative ? 1 : 0;
        while (index < strLength) {
            dsValue.m_numFields = (short)(dsValue.m_numFields + 1);
            switch (indicator) {
                case DAY: {
                    dsValue.m_day = Integer.valueOf(value.substring(index, leadingTerminatorIndex));
                    hasLeadingField = true;
                    indicator = IntervalFieldType.HOUR;
                    index = leadingTerminatorIndex;
                    if (index == strLength || ' ' == value.charAt(index)) break;
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
                case HOUR: {
                    if (hasLeadingField) {
                        dsValue.m_hour = Integer.valueOf(value.substring(index, index + 2));
                        index += 2;
                    } else {
                        dsValue.m_hour = Integer.valueOf(value.substring(index, leadingTerminatorIndex));
                        hasLeadingField = true;
                        index = leadingTerminatorIndex;
                    }
                    indicator = IntervalFieldType.MINUTE;
                    if (index == strLength || ':' == value.charAt(index)) break;
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
                case MINUTE: {
                    if (hasLeadingField) {
                        dsValue.m_minute = Integer.valueOf(value.substring(index, index + 2));
                        index += 2;
                    } else {
                        dsValue.m_minute = Integer.valueOf(value.substring(index, leadingTerminatorIndex));
                        hasLeadingField = true;
                        index = leadingTerminatorIndex;
                    }
                    indicator = IntervalFieldType.SECOND;
                    if (index == strLength || ':' == value.charAt(index)) break;
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
                case SECOND: {
                    if (hasLeadingField) {
                        dsValue.m_second = Integer.valueOf(value.substring(index, index + 2));
                        index += 2;
                    } else {
                        dsValue.m_second = Integer.valueOf(value.substring(index, leadingTerminatorIndex));
                        hasLeadingField = true;
                        index = leadingTerminatorIndex;
                    }
                    indicator = IntervalFieldType.FRACTION;
                    if (index == strLength || '.' == value.charAt(index)) break;
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
                case FRACTION: {
                    if (!hasLeadingField) {
                        throw IntervalConverter.createException(messageKey, value, warningListener);
                    }
                    dsValue.m_fraction = IntervalConverter.getFractionField(value.substring(index), meta.getPrecision(), warningListener);
                    return dsValue;
                }
                default: {
                    throw IntervalConverter.createException(messageKey, value, warningListener);
                }
            }
            ++index;
        }
        return dsValue;
    }

    private static DSITimeSpan stringToIntervalDay(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_FORMAT);
        int days = dsValue.m_day + dsValue.m_hour / 24 + dsValue.m_minute / 1440 + dsValue.m_second / 86400;
        DSITimeSpan timespan = new DSITimeSpan(103, days, 0, 0, 0, 0, dsValue.m_isNegative);
        if (0 != dsValue.m_hour % 24 || 0 != dsValue.m_minute % 1440 || 0 != dsValue.m_second % 86400 || 0 != dsValue.m_fraction) {
            warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(timespan.getDay(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalDayToHour(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_HOUR_FORMAT);
        int hours = dsValue.m_hour + dsValue.m_minute / 60 + dsValue.m_second / 3600;
        DSITimeSpan timespan = new DSITimeSpan(108, dsValue.m_day + hours / 24, hours % 24, 0, 0, 0, dsValue.m_isNegative);
        if (0 != dsValue.m_minute % 60 || 0 != dsValue.m_second % 3600 || 0 != dsValue.m_fraction) {
            warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(timespan.getDay(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalDayToMinute(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_MINUTE_FORMAT);
        int tempValue = dsValue.m_minute + dsValue.m_second / 60;
        int minutes = tempValue % 60;
        tempValue = dsValue.m_hour + tempValue / 60;
        DSITimeSpan timespan = new DSITimeSpan(109, dsValue.m_day + tempValue / 24, tempValue % 24, minutes, 0, 0, dsValue.m_isNegative);
        if (0 != dsValue.m_second % 60 || 0 != dsValue.m_fraction) {
            warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(timespan.getDay(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalDayToSecond(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_SECOND_FORMAT);
        IntervalConverter.checkLeadingField(dsValue.m_day, meta.getIntervalPrecision());
        int tempVariable = dsValue.m_minute + dsValue.m_second / 60;
        int minutes = tempVariable % 60;
        tempVariable = dsValue.m_hour + tempVariable / 60;
        return new DSITimeSpan(110, dsValue.m_day + tempVariable / 24, tempVariable % 24, minutes, dsValue.m_second % 60, dsValue.m_fraction, dsValue.m_isNegative);
    }

    private static DSITimeSpan stringToIntervalHour(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(104, 0, dsValue.m_day, 0, 0, 0, dsValue.m_isNegative);
        } else {
            int hours = dsValue.m_day * 24 + dsValue.m_hour + dsValue.m_minute / 60 + dsValue.m_second / 60;
            timespan = new DSITimeSpan(104, 0, hours, 0, 0, 0, dsValue.m_isNegative);
            if (0 != dsValue.m_minute % 60 || 0 != dsValue.m_second % 60 || 0 != dsValue.m_fraction) {
                warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(timespan.getHour(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalHourToMinute(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_MINUTE_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(111, 0, dsValue.m_day, 0, 0, 0, dsValue.m_isNegative);
        } else {
            int minutes = dsValue.m_minute + dsValue.m_second / 60;
            timespan = new DSITimeSpan(111, 0, dsValue.m_day * 24 + dsValue.m_hour + minutes / 60, minutes % 60, 0, 0, dsValue.m_isNegative);
            if (0 != dsValue.m_second % 60 || 0 != dsValue.m_fraction) {
                warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(timespan.getHour(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalHourToSecond(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_SECOND_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(112, 0, dsValue.m_day, 0, 0, 0, dsValue.m_isNegative);
        } else {
            int minutes = dsValue.m_minute + dsValue.m_second / 60;
            timespan = new DSITimeSpan(112, 0, dsValue.m_day * 24 + dsValue.m_hour + minutes / 60, minutes % 60, dsValue.m_second % 60, dsValue.m_fraction, dsValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(timespan.getHour(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalMinute(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_MINUTE_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(105, 0, 0, dsValue.m_day, 0, 0, dsValue.m_isNegative);
        } else {
            int minutes = dsValue.m_day * 1440 + dsValue.m_hour * 60 + dsValue.m_minute + dsValue.m_second / 60;
            timespan = new DSITimeSpan(105, 0, 0, minutes, 0, 0, dsValue.m_isNegative);
            if (0 != dsValue.m_second % 60 || 0 != dsValue.m_fraction) {
                warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(timespan.getMinute(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSITimeSpan stringToIntervalMinuteToSecond(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_MINUTE_SECOND_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(113, 0, 0, dsValue.m_day, 0, 0, dsValue.m_isNegative);
        } else if (2 == dsValue.m_numFields && 0 == dsValue.m_day && 0 == dsValue.m_second && 0 == dsValue.m_fraction) {
            timespan = new DSITimeSpan(113, 0, 0, dsValue.m_hour + dsValue.m_minute / 60, dsValue.m_minute % 60, 0, dsValue.m_isNegative);
        } else {
            int minutes = dsValue.m_day * 1440 + dsValue.m_hour * 60 + dsValue.m_minute + dsValue.m_second / 60;
            timespan = new DSITimeSpan(113, 0, 0, minutes, dsValue.m_second % 60, dsValue.m_fraction, dsValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(timespan.getMinute(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSIMonthSpan stringToIntervalMonth(String value, TypeMetadata meta, IWarningListener warningListener) {
        YearMonthValue ymValue = IntervalConverter.stringToYearMonthValue(value, JDBCMessageKey.INVALID_INTERVAL_MONTH_FORMAT, warningListener);
        DSIMonthSpan monthSpan = null;
        monthSpan = 1 == ymValue.m_numFields ? new DSIMonthSpan(102, 0, ymValue.m_first, ymValue.m_isNegative) : new DSIMonthSpan(102, 0, ymValue.m_first * 12 + ymValue.m_second, ymValue.m_isNegative);
        IntervalConverter.checkLeadingField(monthSpan.getMonth(), meta.getIntervalPrecision());
        return monthSpan;
    }

    private static DSITimeSpan stringToIntervalSecond(String value, TypeMetadata meta, IWarningListener warningListener) {
        DaySecondValue dsValue = IntervalConverter.stringToDaySecondValue(value, meta, warningListener, JDBCMessageKey.INVALID_INTERVAL_SECOND_FORMAT);
        DSITimeSpan timespan = null;
        if (1 == dsValue.m_numFields) {
            timespan = new DSITimeSpan(106, 0, 0, 0, dsValue.m_day, 0, dsValue.m_isNegative);
        } else if (2 == dsValue.m_numFields && 0 == dsValue.m_day && 0 == dsValue.m_second && 0 == dsValue.m_fraction) {
            timespan = new DSITimeSpan(106, 0, 0, 0, dsValue.m_hour * 60 + dsValue.m_minute, 0, dsValue.m_isNegative);
        } else {
            int seconds = dsValue.m_day * 86400 + dsValue.m_hour * 3600 + dsValue.m_minute * 60 + dsValue.m_second;
            timespan = new DSITimeSpan(106, 0, 0, 0, seconds, dsValue.m_fraction, dsValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(timespan.getSecond(), meta.getIntervalPrecision());
        return timespan;
    }

    private static DSIMonthSpan stringToIntervalYear(String value, TypeMetadata meta, IWarningListener warningListener) {
        YearMonthValue ymValue = IntervalConverter.stringToYearMonthValue(value, JDBCMessageKey.INVALID_INTERVAL_YEAR_FORMAT, warningListener);
        DSIMonthSpan monthSpan = null;
        if (1 == ymValue.m_numFields) {
            monthSpan = new DSIMonthSpan(101, ymValue.m_first, 0, ymValue.m_isNegative);
        } else {
            if (0 != ymValue.m_second % 12) {
                warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
            monthSpan = new DSIMonthSpan(101, ymValue.m_first + ymValue.m_second / 12, 0, ymValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(monthSpan.getYear(), meta.getIntervalPrecision());
        return monthSpan;
    }

    private static DSIMonthSpan stringToIntervalYearMonth(String value, TypeMetadata meta, IWarningListener warningListener) {
        YearMonthValue ymValue = IntervalConverter.stringToYearMonthValue(value, JDBCMessageKey.INVALID_INTERVAL_YEAR_MONTH_FORMAT, warningListener);
        IntervalConverter.checkLeadingField(ymValue.m_first, meta.getIntervalPrecision());
        return new DSIMonthSpan(107, ymValue.m_first, ymValue.m_second, ymValue.m_isNegative);
    }

    private static YearMonthValue stringToYearMonthValue(String value, JDBCMessageKey messageKey, IWarningListener warningListener) {
        if (0 == value.length()) {
            throw IntervalConverter.createException(messageKey, value, warningListener);
        }
        YearMonthValue ymValue = new YearMonthValue();
        boolean bl = ymValue.m_isNegative = '-' == value.charAt(0);
        if (ymValue.m_isNegative) {
            value = value.substring(1);
        }
        int terminatorIndex = value.lastIndexOf(45);
        try {
            if (-1 == terminatorIndex) {
                ymValue.m_first = Integer.parseInt(value);
                ymValue.m_numFields = 1;
            } else {
                ymValue.m_first = Integer.parseInt(value.substring(0, terminatorIndex));
                ymValue.m_second = Integer.parseInt(value.substring(terminatorIndex + 1));
                ymValue.m_numFields = (short)2;
            }
        }
        catch (NumberFormatException nfe) {
            throw IntervalConverter.createException(messageKey, value, warningListener);
        }
        return ymValue;
    }

    static {
        IDriver driver = DSIDriverSingleton.getInstance();
        try {
            Variant var = driver.getProperty(21);
            s_isLeadingFieldPadded = 1L == var.getLong();
        }
        catch (Exception e) {
            s_isLeadingFieldPadded = false;
        }
        ZERO_BUFFER = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000"};
    }

    private static class YearMonthValue {
        public int m_first;
        public int m_second;
        public short m_numFields;
        public boolean m_isNegative;

        private YearMonthValue() {
        }
    }

    private static enum IntervalFieldType {
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        FRACTION;

    }

    private static class DaySecondValue {
        public int m_day;
        public int m_hour;
        public int m_minute;
        public int m_second;
        public int m_fraction;
        public short m_numFields;
        public boolean m_isNegative;

        private DaySecondValue() {
        }
    }
}

