/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;

abstract class ExceptionInternalResolverFactory {
    private static final EventResolver NULL_RESOLVER = (ignored, jsonGenerator) -> jsonGenerator.writeNull();

    ExceptionInternalResolverFactory() {
    }

    EventResolver createInternalResolver(EventResolverContext context, String key) {
        String minorKey;
        String majorKey;
        int colonIndex = key.indexOf(58);
        if (colonIndex >= 0) {
            majorKey = key.substring(0, colonIndex);
            minorKey = key.substring(colonIndex + 1);
        } else {
            majorKey = key;
            minorKey = "";
        }
        switch (majorKey) {
            case "className": {
                return this.createClassNameResolver();
            }
            case "message": {
                return this.createMessageResolver(context);
            }
            case "stackTrace": {
                return this.createStackTraceResolver(context, minorKey);
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    abstract EventResolver createClassNameResolver();

    abstract EventResolver createMessageResolver(EventResolverContext var1);

    private EventResolver createStackTraceResolver(EventResolverContext context, String minorKey) {
        if (!context.isStackTraceEnabled()) {
            return NULL_RESOLVER;
        }
        switch (minorKey) {
            case "text": {
                return this.createStackTraceTextResolver(context);
            }
            case "": {
                return this.createStackTraceObjectResolver(context);
            }
        }
        throw new IllegalArgumentException("unknown minor key: " + minorKey);
    }

    abstract EventResolver createStackTraceTextResolver(EventResolverContext var1);

    abstract EventResolver createStackTraceObjectResolver(EventResolverContext var1);
}

