/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.StackTraceResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import java.io.IOException;

class StackTraceObjectResolver
implements StackTraceResolver {
    private final TemplateResolver<StackTraceElement> stackTraceElementResolver;

    StackTraceObjectResolver(TemplateResolver<StackTraceElement> stackTraceElementResolver) {
        this.stackTraceElementResolver = stackTraceElementResolver;
    }

    @Override
    public void resolve(Throwable throwable, JsonGenerator jsonGenerator) throws IOException {
        StackTraceElement[] stackTraceElements;
        Throwable lastThrowable = throwable;
        while (true) {
            try {
                stackTraceElements = lastThrowable.getStackTrace();
            }
            catch (Throwable newThrowable) {
                lastThrowable = newThrowable;
                continue;
            }
            break;
        }
        if (stackTraceElements.length == 0) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeStartArray();
            for (int stackTraceElementIndex = 0; stackTraceElementIndex < stackTraceElements.length; ++stackTraceElementIndex) {
                StackTraceElement stackTraceElement = stackTraceElements[stackTraceElementIndex];
                this.stackTraceElementResolver.resolve(stackTraceElement, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

