/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.util.JsonGenerators;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

class TimestampResolver
implements EventResolver {
    private final EventResolver internalResolver;
    private static final EventResolver SECS_LONG_RESOLVER = (logEvent, jsonGenerator) -> {
        Instant logEventInstant = logEvent.getInstant();
        long epochSecs = logEventInstant.getEpochSecond();
        jsonGenerator.writeNumber(epochSecs);
    };
    private static final EventResolver SECS_DOUBLE_RESOLVER = (logEvent, jsonGenerator) -> {
        Instant logEventInstant = logEvent.getInstant();
        JsonGenerators.writeDouble(jsonGenerator, logEventInstant.getEpochSecond(), logEventInstant.getNanoOfSecond());
    };
    private static final EventResolver MILLIS_LONG_RESOLVER = (logEvent, jsonGenerator) -> {
        Instant logEventInstant = logEvent.getInstant();
        long epochMillis = logEventInstant.getEpochMillisecond();
        jsonGenerator.writeNumber(epochMillis);
    };
    private static final EventResolver MILLIS_DOUBLE_RESOLVER = (logEvent, jsonGenerator) -> {
        Instant logEventInstant = logEvent.getInstant();
        JsonGenerators.writeDouble(jsonGenerator, logEventInstant.getEpochMillisecond(), logEventInstant.getNanoOfMillisecond());
    };
    private static final EventResolver NANOS_RESOLVER = (logEvent, jsonGenerator) -> {
        Instant logEventInstant = logEvent.getInstant();
        long epochNanos = Math.multiplyExact(1000000000L, logEventInstant.getEpochSecond());
        long number = Math.addExact(epochNanos, (long)logEventInstant.getNanoOfSecond());
        jsonGenerator.writeNumber(number);
    };

    TimestampResolver(EventResolverContext context, String key) {
        this.internalResolver = TimestampResolver.createInternalResolver(context, key);
    }

    private static EventResolver createInternalResolver(EventResolverContext eventResolverContext, String key) {
        boolean integral;
        double divisor;
        if (key == null || key.isEmpty()) {
            return TimestampResolver.createFormatResolver(eventResolverContext);
        }
        Matcher matcher = Pattern.compile("^epoch(:divisor=([^,]+)(,integral)?)?$").matcher(key);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unknown key: " + key);
        }
        String divisorString = matcher.group(2);
        String integralString = matcher.group(3);
        if (divisorString == null) {
            divisor = 1.0;
            integral = false;
        } else {
            try {
                divisor = Double.parseDouble(divisorString);
            }
            catch (NumberFormatException error) {
                throw new IllegalArgumentException("invalid divisor: " + divisorString, error);
            }
            if (Double.compare(0.0, divisor) == 0) {
                throw new IllegalArgumentException("invalid divisor: " + divisorString);
            }
            integral = integralString != null;
        }
        return TimestampResolver.createDivisorResolver(divisor, integral);
    }

    private static EventResolver createFormatResolver(EventResolverContext eventResolverContext) {
        return Constants.ENABLE_THREADLOCALS ? new ThreadLocalFormatResolver(eventResolverContext) : new LockingFormatResolver(eventResolverContext);
    }

    private static EventResolver createDivisorResolver(double divisor, boolean integral) {
        if (Double.compare(1.0E9, divisor) == 0) {
            return integral ? SECS_LONG_RESOLVER : SECS_DOUBLE_RESOLVER;
        }
        if (Double.compare(1000000.0, divisor) == 0) {
            return integral ? MILLIS_LONG_RESOLVER : MILLIS_DOUBLE_RESOLVER;
        }
        if (Double.compare(1.0, divisor) == 0) {
            return NANOS_RESOLVER;
        }
        return (logEvent, jsonGenerator) -> {
            Instant logEventInstant = logEvent.getInstant();
            double quotient = 1.0E9 * ((double)logEventInstant.getEpochSecond() / divisor) + (double)logEventInstant.getNanoOfSecond() / divisor;
            if (integral) {
                long integralQuotient = (long)quotient;
                jsonGenerator.writeNumber(integralQuotient);
            } else {
                jsonGenerator.writeNumber(quotient);
            }
        };
    }

    static String getName() {
        return "timestamp";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }

    private static final class LockingFormatResolver
    extends ContextualFormatResolver {
        private final FormatResolverContext formatResolverContext;
        private final Lock lock = new ReentrantLock();

        private LockingFormatResolver(EventResolverContext eventResolverContext) {
            this.formatResolverContext = FormatResolverContext.fromEventResolverContext(eventResolverContext);
        }

        @Override
        FormatResolverContext acquireContext() {
            this.lock.lock();
            return this.formatResolverContext;
        }

        @Override
        void releaseContext() {
            this.lock.unlock();
        }
    }

    private static final class ThreadLocalFormatResolver
    extends ContextualFormatResolver {
        private final ThreadLocal<FormatResolverContext> formatResolverContextRef = ThreadLocal.withInitial(() -> FormatResolverContext.access$500(eventResolverContext));

        private ThreadLocalFormatResolver(EventResolverContext eventResolverContext) {
        }

        @Override
        FormatResolverContext acquireContext() {
            return this.formatResolverContextRef.get();
        }

        @Override
        void releaseContext() {
        }
    }

    private static abstract class ContextualFormatResolver
    implements EventResolver {
        private ContextualFormatResolver() {
        }

        abstract FormatResolverContext acquireContext();

        abstract void releaseContext();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
            long timestampMillis = logEvent.getTimeMillis();
            FormatResolverContext formatResolverContext = this.acquireContext();
            try {
                if (formatResolverContext.calendar.getTimeInMillis() != timestampMillis) {
                    formatResolverContext.formattedTimestampBuilder.setLength(0);
                    formatResolverContext.calendar.setTimeInMillis(timestampMillis);
                    formatResolverContext.timestampFormat.format(formatResolverContext.calendar, (Appendable)formatResolverContext.formattedTimestampBuilder);
                    int formattedTimestampLength = formatResolverContext.formattedTimestampBuilder.length();
                    if (formattedTimestampLength > formatResolverContext.formattedTimestampBuffer.length) {
                        FormatResolverContext.access$302(formatResolverContext, new char[formattedTimestampLength]);
                    }
                    formatResolverContext.formattedTimestampBuilder.getChars(0, formattedTimestampLength, formatResolverContext.formattedTimestampBuffer, 0);
                }
                jsonGenerator.writeString(formatResolverContext.formattedTimestampBuffer, 0, formatResolverContext.formattedTimestampBuilder.length());
            }
            finally {
                this.releaseContext();
            }
        }
    }

    private static final class FormatResolverContext {
        private final FastDateFormat timestampFormat;
        private final Calendar calendar;
        private final StringBuilder formattedTimestampBuilder;
        private char[] formattedTimestampBuffer;

        private FormatResolverContext(TimeZone timeZone, Locale locale, FastDateFormat timestampFormat) {
            this.timestampFormat = timestampFormat;
            this.formattedTimestampBuilder = new StringBuilder();
            this.calendar = Calendar.getInstance(timeZone, locale);
            timestampFormat.format(this.calendar, (Appendable)this.formattedTimestampBuilder);
            int formattedTimestampLength = this.formattedTimestampBuilder.length();
            this.formattedTimestampBuffer = new char[formattedTimestampLength];
            this.formattedTimestampBuilder.getChars(0, formattedTimestampLength, this.formattedTimestampBuffer, 0);
        }

        private static FormatResolverContext fromEventResolverContext(EventResolverContext eventResolverContext) {
            return new FormatResolverContext(eventResolverContext.getTimeZone(), eventResolverContext.getLocale(), eventResolverContext.getTimestampFormat());
        }

        static /* synthetic */ char[] access$302(FormatResolverContext x0, char[] x1) {
            x0.formattedTimestampBuffer = x1;
            return x1;
        }
    }
}

