/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.ApiResponse;
import com.volcengine.ProgressRequestBody;
import com.volcengine.ProgressResponseBody;
import com.volcengine.UniversalRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class UniversalApi {
    private ApiClient apiClient;

    public UniversalApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UniversalApi() {
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Map<String, Object> doCall(UniversalRequest info, Map<String, Object> input) throws ApiException {
        ApiResponse<Map<String, Object>> resp = this.doCallWithHttpInfo(info, input);
        return resp.getData();
    }

    public ApiResponse<Map<String, Object>> doCallWithHttpInfo(@NotNull UniversalRequest info, @NotNull Map<String, Object> input) throws ApiException {
        Call call = this.doCallValidateBeforeCall(info, input, null, null);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        ApiResponse<Map<String, Object>> obj = this.apiClient.execute(call, localVarReturnType, true);
        this.processNumber((Map)obj.getData());
        return obj;
    }

    private void processNumber(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() != null && entry.getValue() instanceof Map) {
                this.processNumber((Map)entry.getValue());
            }
            if (entry.getValue() == null || !this.isNumeric(entry.getValue().toString()) || !entry.getValue().toString().contains(".") || !entry.getValue().toString().endsWith(".0")) continue;
            entry.setValue(Double.valueOf(entry.getValue().toString()).longValue());
        }
    }

    private boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Call doCallValidateBeforeCall(UniversalRequest info, Map<String, Object> input, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (input == null) {
            throw new ApiException("Missing the required parameter 'input' when calling doCall(Async)");
        }
        Call call = this.doCall(info, input, progressListener, progressRequestListener);
        return call;
    }

    private Call doCall(UniversalRequest info, Map<String, Object> input, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPath = String.format("/%s/%s/%s/%s/", info.getAction(), info.getVersion(), info.getServiceName(), info.getHttpMethod().GetMethod().toLowerCase());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("Accept", "application/json");
        if (info.getContentType().GetType().equals("")) {
            localVarHeaderParams.put("Content-Type", "text/plain");
        } else {
            localVarHeaderParams.put("Content-Type", info.getContentType().GetType());
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"volcengineSign"};
        return this.apiClient.buildCall(localVarPath, info.getHttpMethod().GetMethod(), (List)new ArrayList(), (List)new ArrayList(), (Object)input, localVarHeaderParams, (Map)new HashMap(), localVarAuthNames, progressRequestListener, new boolean[]{true});
    }
}

