/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.utils;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class LoggerUtil {
    public static final LoggerUtil CORE_LOGGER = LoggerUtil.loggerFor("com.volcengine.sdkcore");
    private static final String FQCN = LoggerUtil.class.getName();
    private final Logger log;

    LoggerUtil(Logger log) {
        this.log = log;
    }

    public void trace(Supplier<String> msg) {
        if (this.log.isTraceEnabled()) {
            this.doLog(0, msg, null, new Object[0]);
        }
    }

    public void trace(Supplier<String> msg, Throwable t) {
        if (this.log.isTraceEnabled()) {
            this.doLog(0, msg, t, new Object[0]);
        }
    }

    public void trace(String msg, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.doLog(0, () -> msg, null, args);
        }
    }

    public void debug(Supplier<String> msg) {
        if (this.log.isDebugEnabled()) {
            this.doLog(10, msg, null, new Object[0]);
        }
    }

    public void debug(Supplier<String> msg, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.doLog(10, msg, t, new Object[0]);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.doLog(10, () -> msg, null, args);
        }
    }

    public void debug(Marker marker, String msg, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.doLog(marker, 10, () -> msg, null, args);
        }
    }

    public void info(Supplier<String> msg) {
        if (this.log.isInfoEnabled()) {
            this.doLog(20, msg, null, new Object[0]);
        }
    }

    public void info(Supplier<String> msg, Throwable t) {
        if (this.log.isInfoEnabled()) {
            this.doLog(20, msg, t, new Object[0]);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.doLog(20, () -> msg, null, args);
        }
    }

    public void warn(Supplier<String> msg) {
        if (this.log.isWarnEnabled()) {
            this.doLog(30, msg, null, new Object[0]);
        }
    }

    public void warn(Supplier<String> msg, Throwable t) {
        if (this.log.isWarnEnabled()) {
            this.doLog(30, msg, t, new Object[0]);
        }
    }

    public void warn(String msg, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.doLog(30, () -> msg, null, args);
        }
    }

    public void error(Supplier<String> msg) {
        if (this.log.isErrorEnabled()) {
            this.doLog(40, msg, null, new Object[0]);
        }
    }

    public void error(Supplier<String> msg, Throwable t) {
        if (this.log.isErrorEnabled()) {
            this.doLog(40, msg, t, new Object[0]);
        }
    }

    public void error(String msg, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.doLog(40, () -> msg, null, args);
        }
    }

    private void doLog(int level, Supplier<String> supplier, Throwable t, Object ... args) {
        this.doLog(null, level, supplier, t, args);
    }

    private void doLog(Marker marker, int level, Supplier<String> supplier, Throwable t, Object ... args) {
        if (this.log instanceof LocationAwareLogger) {
            ((LocationAwareLogger)this.log).log(marker, FQCN, level, supplier == null ? null : supplier.get(), args, t);
            return;
        }
        this.fallback(level, supplier, t, args);
    }

    private void fallback(int level, Supplier<String> supplier, Throwable t, Object ... args) {
        String msg = supplier == null ? null : supplier.get();
        switch (level) {
            case 0: {
                if (t != null) {
                    this.log.trace(msg, t);
                    break;
                }
                this.log.trace(msg, args);
                break;
            }
            case 10: {
                if (t != null) {
                    this.log.debug(msg, t);
                    break;
                }
                this.log.debug(msg, args);
                break;
            }
            case 20: {
                if (t != null) {
                    this.log.info(msg, t);
                    break;
                }
                this.log.info(msg, args);
                break;
            }
            case 30: {
                if (t != null) {
                    this.log.warn(msg, t);
                    break;
                }
                this.log.warn(msg, args);
                break;
            }
            case 40: {
                if (t != null) {
                    this.log.error(msg, t);
                    break;
                }
                this.log.error(msg, args);
                break;
            }
        }
    }

    public static LoggerUtil loggerFor(Class<?> clz) {
        return new LoggerUtil(LoggerFactory.getLogger(clz));
    }

    public static LoggerUtil loggerFor(String name) {
        return new LoggerUtil(LoggerFactory.getLogger((String)name));
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }
}

