/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.jsonp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class AccessControlAllowFilter
implements Filter {
    static final Logger LOG = LoggerFactory.getLogger(AccessControlAllowFilter.class);

    public void init(FilterConfig fc) throws ServletException {
        LOG.debug("init()");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String accessControlRequestOrigin;
        String accessControlRequestHeaders;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String accessControlRequestMethod = request.getHeader("Access-Control-Request-Method");
        if (null != accessControlRequestMethod) {
            response.setHeader("Access-Control-Allow-Methods", "DELETE, GET, OPTIONS, POST, PUT");
            LOG.debug("Access-Control-Allow-Methods: {}", (Object)"DELETE, GET, OPTIONS, POST, PUT");
        }
        if (null != (accessControlRequestHeaders = request.getHeader("Access-Control-Request-Headers"))) {
            response.setHeader("Access-Control-Allow-Headers", accessControlRequestHeaders);
            LOG.debug("Access-Control-Allow-Headers: {}", (Object)accessControlRequestHeaders);
        }
        if (null != (accessControlRequestOrigin = request.getHeader("Origin"))) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            LOG.debug("Access-Control-Allow-Origin: * for {}", (Object)accessControlRequestOrigin);
        }
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(HttpStatus.OK.value());
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
        LOG.debug("destroy()");
    }
}

